/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.fs;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.GCSOptions;
import com.vertica.spark.config.GCSServiceAuth;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.config.SensitiveArg;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.GCSSparkOptions$;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer$;
import com.vertica.spark.datasource.fs.HadoopFileStoreReader;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.datasource.partitions.parquet.ParquetFileRange;
import com.vertica.spark.util.error.CloseWriteError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.CreateDirectoryError;
import com.vertica.spark.util.error.CreateFileAlreadyExistsError;
import com.vertica.spark.util.error.CreateFileError;
import com.vertica.spark.util.error.FileListError;
import com.vertica.spark.util.error.FileStoreThrownError;
import com.vertica.spark.util.error.IntermediaryStoreReaderNotInitializedError;
import com.vertica.spark.util.error.IntermediaryStoreWriteError;
import com.vertica.spark.util.error.IntermediaryStoreWriterNotInitializedError;
import com.vertica.spark.util.error.MissingHDFSImpersonationTokenError;
import com.vertica.spark.util.error.OpenReadError;
import com.vertica.spark.util.error.OpenWriteError;
import com.vertica.spark.util.error.RemoveDirectoryError;
import com.vertica.spark.util.error.RemoveFileError;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015u!B&M\u0011\u00039f!B-M\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007\"B2\u0002\t\u0003!\u0007BB2\u0002\t\u0003\u0019YH\u0002\u0003Z\u0019\u00021\u0007\u0002\u00036\u0006\u0005\u0003\u0005\u000b\u0011B6\t\u0011E,!\u0011!Q\u0001\nIDa!Y\u0003\u0005\u0002\u0005\u0015\u0001\"CA\u0006\u000b\t\u0007I\u0011BA\u0007\u0011!\t)#\u0002Q\u0001\n\u0005=\u0001\"CA\u0014\u000b\t\u0007I\u0011BA\u0007\u0011!\tI#\u0002Q\u0001\n\u0005=\u0001\"CA\u0016\u000b\t\u0007I\u0011BA\u0007\u0011!\ti#\u0002Q\u0001\n\u0005=\u0001\"CA\u0018\u000b\t\u0007I\u0011BA\u0007\u0011!\t\t$\u0002Q\u0001\n\u0005=\u0001\"CA\u001a\u000b\t\u0007I\u0011BA\u0007\u0011!\t)$\u0002Q\u0001\n\u0005=\u0001\"CA\u001c\u000b\t\u0007I\u0011BA\u0007\u0011!\tI$\u0002Q\u0001\n\u0005=\u0001\"CA\u001e\u000b\t\u0007I\u0011BA\u0007\u0011!\ti$\u0002Q\u0001\n\u0005=\u0001\"CA \u000b\t\u0007I\u0011AA!\u0011!\t\u0019&\u0002Q\u0001\n\u0005\r\u0003\"CA+\u000b\t\u0007I\u0011BA,\u0011!\tI'\u0002Q\u0001\n\u0005e\u0003\"CA6\u000b\t\u0007I\u0011BA,\u0011!\ti'\u0002Q\u0001\n\u0005e\u0003\"CA8\u000b\t\u0007I\u0011BA,\u0011!\t\t(\u0002Q\u0001\n\u0005e\u0003\"CA:\u000b\t\u0007I\u0011BA;\u0011!\t))\u0002Q\u0001\n\u0005]\u0004\"CAD\u000b\t\u0007I\u0011BA;\u0011!\tI)\u0002Q\u0001\n\u0005]\u0004\"CAF\u000b\t\u0007I\u0011BA;\u0011!\ti)\u0002Q\u0001\n\u0005]\u0004\"CAH\u000b\t\u0007I\u0011BA;\u0011!\t\t*\u0002Q\u0001\n\u0005]\u0004\"CAJ\u000b\u0001\u0007I\u0011BAK\u0011%\t\u0019,\u0002a\u0001\n\u0013\t)\f\u0003\u0005\u0002B\u0016\u0001\u000b\u0015BAL\u0011%\t\u0019-\u0002a\u0001\n\u0013\t)\rC\u0005\u0002P\u0016\u0001\r\u0011\"\u0003\u0002R\"A\u0011Q[\u0003!B\u0013\t9\rC\u0005\u0002X\u0016\u0011\r\u0011\"\u0001\u0002Z\"A\u0011q]\u0003!\u0002\u0013\tY\u000eC\u0005\u0002j\u0016\u0011\r\u0011\"\u0003\u0002l\"A\u00111_\u0003!\u0002\u0013\ti\u000fC\u0005\u0002v\u0016\u0011\r\u0011\"\u0003\u0002x\"A\u0011q`\u0003!\u0002\u0013\tIP\u0002\u0004\u0003\u0002\u0015!!1\u0001\u0005\u000b\u0005/\u0019$\u0011!Q\u0001\n\te\u0001BB14\t\u0003\u0011\u0019\u0003C\u0004\u0003(M\"\tF!\u000b\t\u000f\t-2\u0007\"\u0005\u0003.!9!1I\u0003\u0005\u0002\t\u0015\u0003b\u0002B;\u000b\u0011\u0005#q\u000f\u0005\b\u0005\u0013+A\u0011\tBF\u0011\u001d\u0011i)\u0002C\u0005\u0005\u001fCqA!2\u0006\t\u0003\u00129\rC\u0004\u0003T\u0016!\tE!6\t\u000f\t\u001dX\u0001\"\u0011\u0003j\"9!q_\u0003\u0005B\t-\u0005b\u0002B}\u000b\u0011\u0005#1 \u0005\b\u0007')A\u0011IB\u000b\u0011\u001d\u0019I\"\u0002C!\u00077Aqaa\b\u0006\t\u0003\u001a\t\u0003C\u0004\u0004&\u0015!\tea\n\t\u000f\r=R\u0001\"\u0001\u00042!91QH\u0003\u0005B\r}\u0002bBB$\u000b\u0011\u00053\u0011\n\u0005\b\u0007\u001f*A\u0011IAv\u0011\u001d\u0019\t&\u0002C!\u0003oDqaa\u0015\u0006\t\u0013\u0019)&\u0001\u000bIC\u0012|w\u000e\u001d$jY\u0016\u001cFo\u001c:f\u0019\u0006LXM\u001d\u0006\u0003\u001b:\u000b!AZ:\u000b\u0005=\u0003\u0016A\u00033bi\u0006\u001cx.\u001e:dK*\u0011\u0011KU\u0001\u0006gB\f'o\u001b\u0006\u0003'R\u000bqA^3si&\u001c\u0017MC\u0001V\u0003\r\u0019w.\\\u0002\u0001!\tA\u0016!D\u0001M\u0005QA\u0015\rZ8pa\u001aKG.Z*u_J,G*Y=feN\u0011\u0011a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0016\u0001B7bW\u0016$2!ZB:!\tAVaE\u0002\u00067\u001e\u0004\"\u0001\u00175\n\u0005%d%a\u0006$jY\u0016\u001cFo\u001c:f\u0019\u0006LXM]%oi\u0016\u0014h-Y2f\u0003=1\u0017\u000e\\3Ti>\u0014XmQ8oM&<\u0007C\u00017p\u001b\u0005i'B\u00018Q\u0003\u0019\u0019wN\u001c4jO&\u0011\u0001/\u001c\u0002\u0010\r&dWm\u0015;pe\u0016\u001cuN\u001c4jO\u000611o\u00195f[\u0006\u00042\u0001X:v\u0013\t!XL\u0001\u0004PaRLwN\u001c\t\u0004m\u0006\u0005Q\"A<\u000b\u0005aL\u0018!\u0002;za\u0016\u001c(B\u0001>|\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#rT!! @\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0018aA8sO&\u0019\u00111A<\u0003\u0015M#(/^2u)f\u0004X\rF\u0003f\u0003\u000f\tI\u0001C\u0003k\u0011\u0001\u00071\u000eC\u0003r\u0011\u0001\u0007!/A\u0007Tg}\u000b5iQ#T'~[U)W\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002 9!\u00111CA\u000e!\r\t)\"X\u0007\u0003\u0003/Q1!!\u0007W\u0003\u0019a$o\\8u}%\u0019\u0011QD/\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\ti\"X\u0001\u000f'Nz\u0016iQ\"F'N{6*R-!\u00035\u00196gX*F\u0007J+EkX&F3\u0006q1kM0T\u000b\u000e\u0013V\tV0L\u000bf\u0003\u0013\u0001E*4?N+5kU%P\u001d~#vjS#O\u0003E\u00196gX*F'NKuJT0U\u001f.+e\nI\u0001\u0019\u0003^\u001bvl\u0011*F\t\u0016sE+S!M'~\u0003&k\u0014,J\t\u0016\u0013\u0016!G!X'~\u001b%+\u0012#F\u001dRK\u0015\tT*`!J{e+\u0013#F%\u0002\n1bU\u001a`\u000b:#\u0005kT%O)\u0006a1kM0F\u001d\u0012\u0003v*\u0013(UA\u0005i1kM0F\u001d\u0006\u0013E*R0T'2\u000babU\u001a`\u000b:\u000b%\tT#`'Nc\u0005%\u0001\u000bTg}+e*\u0011\"M\u000b~\u0003\u0016\t\u0016%`'RKF*R\u0001\u0016'NzVIT!C\u0019\u0016{\u0006+\u0011+I?N#\u0016\fT#!\u0003\u0019awnZ4feV\u0011\u00111\t\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u00031\u00198-\u00197bY><w-\u001b8h\u0015\r\ti\u0005V\u0001\tif\u0004Xm]1gK&!\u0011\u0011KA$\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!H,F\u0005\"#eiU0E\u000b2+u)\u0011+J\u001f:{FkT&F\u001d~#V\t\u0017+\u0016\u0005\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0003S>T1!a\u0019}\u0003\u0019A\u0017\rZ8pa&!\u0011qMA/\u0005\u0011!V\r\u001f;\u0002=]+%\t\u0013#G'~#U\tT#H\u0003RKuJT0U\u001f.+ej\u0018+F1R\u0003\u0013AH*X\u000b\nCEIR*`\t\u0016cUiR!U\u0013>su\fV(L\u000b:{F+\u0012-U\u0003}\u0019v+\u0012\"I\t\u001a\u001bv\fR#M\u000b\u001e\u000bE+S(O?R{5*\u0012(`)\u0016CF\u000bI\u0001\u001b\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\fV\u0001\u001c\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\f\u0016\u0011\u0002G1+u)Q\"Z?B\u000b%+U+F)~\u0013VIQ!T\u000b~ku\nR#`\u0013:{vKU%U\u000bV\u0011\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006LA!!\t\u0002|\u0005!C*R$B\u0007f{\u0006+\u0011*R+\u0016#vLU#C\u0003N+u,T(E\u000b~KejX,S\u0013R+\u0005%\u0001\u0012M\u000b\u001e\u000b5)W0Q\u0003J\u000bV+\u0012+`%\u0016\u0013\u0015iU#`\u001b>#UiX%O?J+\u0015\tR\u0001$\u0019\u0016;\u0015iQ-`!\u0006\u0013\u0016+V#U?J+%)Q*F?6{E)R0J\u001d~\u0013V)\u0011#!\u0003%bUiR!D3~\u0003\u0016IU)V\u000bR{\u0016J\u0014+:m}\u0013VIQ!T\u000b~ku\nR#`\u0013:{vKU%U\u000b\u0006QC*R$B\u0007f{\u0006+\u0011*R+\u0016#v,\u0013(UsYz&+\u0012\"B'\u0016{Vj\u0014#F?&sul\u0016*J)\u0016\u0003\u0013A\b)B%F+V\tV0G\u0013\u0016cEiX%E?^\u0013\u0016\nV#`\u000b:\u000b%\tT#E\u0003}\u0001\u0016IU)V\u000bR{f)S#M\t~KEiX,S\u0013R+u,\u0012(B\u00052+E\tI\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005]\u0005\u0003\u0002/t\u00033\u0003b!a'\u0002$\u0006\u001dVBAAO\u0015\u0011\t\u0019'a(\u000b\u0007\u0005\u0005F0A\u0004qCJ\fX/\u001a;\n\t\u0005\u0015\u0016Q\u0014\u0002\u000e!\u0006\u0014\u0018/^3u/JLG/\u001a:\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,z\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAY\u0003W\u00131\"\u00138uKJt\u0017\r\u001c*po\u0006QqO]5uKJ|F%Z9\u0015\t\u0005]\u0016Q\u0018\t\u00049\u0006e\u0016bAA^;\n!QK\\5u\u0011%\ty\fKA\u0001\u0002\u0004\t9*A\u0002yIE\nqa\u001e:ji\u0016\u0014\b%\u0001\u0004sK\u0006$WM]\u000b\u0003\u0003\u000f\u0004B\u0001X:\u0002JB\u0019\u0001,a3\n\u0007\u00055GJA\u000bIC\u0012|w\u000e\u001d$jY\u0016\u001cFo\u001c:f%\u0016\fG-\u001a:\u0002\u0015I,\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0003\u00028\u0006M\u0007\"CA`W\u0005\u0005\t\u0019AAd\u0003\u001d\u0011X-\u00193fe\u0002\n!\u0002\u001b3gg\u000e{gNZ5h+\t\tY\u000e\u0005\u0003\u0002^\u0006\rXBAAp\u0015\u0011\t\t/!\u0019\u0002\t\r|gNZ\u0005\u0005\u0003K\fyNA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\fQ\u001247oQ8oM&<\u0007%\u0001\u0006boN|\u0005\u000f^5p]N,\"!!<\u0011\u00071\fy/C\u0002\u0002r6\u0014!\"Q,T\u001fB$\u0018n\u001c8t\u0003-\two](qi&|gn\u001d\u0011\u0002\u0015\u001d\u001c7o\u00149uS>t7/\u0006\u0002\u0002zB\u0019A.a?\n\u0007\u0005uXN\u0001\u0006H\u0007N{\u0005\u000f^5p]N\f1bZ2t\u001fB$\u0018n\u001c8tA\t)b+\u001a:uS\u000e\f\u0007+\u0019:rk\u0016$()^5mI\u0016\u00148cA\u001a\u0003\u0006AA!q\u0001B\u0007\u0003O\u0013\u0019B\u0004\u0003\u0002\u001c\n%\u0011\u0002\u0002B\u0006\u0003;\u000bQ\u0002U1scV,Go\u0016:ji\u0016\u0014\u0018\u0002\u0002B\b\u0005#\u0011qAQ;jY\u0012,'O\u0003\u0003\u0003\f\u0005u\u0005c\u0001B\u000bg5\tQ!\u0001\u0003gS2,\u0007\u0003\u0002B\u000e\u0005?i!A!\b\u000b\u00075\u000b\t'\u0003\u0003\u0003\"\tu!\u0001\u0002)bi\"$BAa\u0005\u0003&!9!qC\u001bA\u0002\te\u0011\u0001B:fY\u001a$\"Aa\u0005\u0002\u001f\u001d,Go\u0016:ji\u0016\u001cV\u000f\u001d9peR$BAa\f\u0003BA!!\u0011\u0007B\u001f\u001b\t\u0011\u0019D\u0003\u0003\u0002\"\nU\"\u0002\u0002B\u001c\u0005s\t1\u0002Z1uCN|WO]2fg*\u0019!1H=\u0002\u0013\u0015DXmY;uS>t\u0017\u0002\u0002B \u0005g\u00111\u0003U1scV,Go\u0016:ji\u0016\u001cV\u000f\u001d9peRDq!!98\u0001\u0004\tY.\u0001\u000bpa\u0016twK]5uKB\u000b'/];fi\u001aKG.\u001a\u000b\u0005\u0005\u000f\u0012\t\b\u0005\u0004\u0003J\t-\u0014q\u0017\b\u0005\u0005\u0017\u0012)G\u0004\u0003\u0003N\t}c\u0002\u0002B(\u00057rAA!\u0015\u0003Z9!!1\u000bB,\u001d\u0011\t)B!\u0016\n\u0003UK!a\u0015+\n\u0005E\u0013\u0016b\u0001B/!\u0006!Q\u000f^5m\u0013\u0011\u0011\tGa\u0019\u0002\u000b\u0015\u0014(o\u001c:\u000b\u0007\tu\u0003+\u0003\u0003\u0003h\t%\u0014!D#se>\u0014\b*\u00198eY&twM\u0003\u0003\u0003b\t\r\u0014\u0002\u0002B7\u0005_\u0012qbQ8o]\u0016\u001cGo\u001c:SKN,H\u000e\u001e\u0006\u0005\u0005O\u0012I\u0007C\u0004\u0003ta\u0002\r!a\u0004\u0002\u0011\u0019LG.\u001a8b[\u0016\fac\u001e:ji\u0016$\u0015\r^1U_B\u000b'/];fi\u001aKG.\u001a\u000b\u0005\u0005\u000f\u0012I\bC\u0004\u0003|e\u0002\rA! \u0002\u0013\u0011\fG/\u0019\"m_\u000e\\\u0007\u0003\u0002B@\u0005\u000bk!A!!\u000b\u0007\t\re*\u0001\u0003d_J,\u0017\u0002\u0002BD\u0005\u0003\u0013\u0011\u0002R1uC\ncwnY6\u0002+\rdwn]3Xe&$X\rU1scV,GOR5mKR\u0011!qI\u0001\u000ei>\u001cV\r^'vYRLW*\u00199\u0016\r\tE%\u0011\u0015B^)\u0011\u0011\u0019Ja0\u0011\u0011\tU%\u0011\u0014BO\u0005gk!Aa&\u000b\t\tu\u0013qP\u0005\u0005\u00057\u00139JA\u0002NCB\u0004BAa(\u0003\"2\u0001Aa\u0002BRw\t\u0007!Q\u0015\u0002\u0002\u0017F!!q\u0015BW!\ra&\u0011V\u0005\u0004\u0005Wk&a\u0002(pi\"Lgn\u001a\t\u00049\n=\u0016b\u0001BY;\n\u0019\u0011I\\=\u0011\r\tU%Q\u0017B]\u0013\u0011\u00119La&\u0003\u0007M+G\u000f\u0005\u0003\u0003 \nmFa\u0002B_w\t\u0007!Q\u0015\u0002\u0002-\"9!\u0011Y\u001eA\u0002\t\r\u0017aA7baBA!Q\u0013BM\u0005;\u0013I,\u0001\fhKR\u0004\u0016M]9vKR4\u0015\u000e\\3NKR\fG-\u0019;b)\u0011\u0011IM!5\u0011\r\t%#1\u000eBf!\rA&QZ\u0005\u0004\u0005\u001fd%a\u0005)beF,X\r\u001e$jY\u0016lU\r^1eCR\f\u0007b\u0002B:y\u0001\u0007\u0011qB\u0001\u0014_B,gNU3bIB\u000b'/];fi\u001aKG.\u001a\u000b\u0005\u0005\u000f\u00129\u000eC\u0004\u0003\u0018u\u0002\rA!7\u0011\t\tm'1]\u0007\u0003\u0005;TA!!)\u0003`*\u0019!\u0011\u001d(\u0002\u0015A\f'\u000f^5uS>t7/\u0003\u0003\u0003f\nu'\u0001\u0005)beF,X\r\u001e$jY\u0016\u0014\u0016M\\4f\u0003]\u0011X-\u00193ECR\fgI]8n!\u0006\u0014\u0018/^3u\r&dW\r\u0006\u0003\u0003l\n5\bC\u0002B%\u0005W\u0012i\bC\u0004\u0003pz\u0002\rA!=\u0002\u0013\tdwnY6TSj,\u0007c\u0001/\u0003t&\u0019!Q_/\u0003\u0007%sG/\u0001\u000bdY>\u001cXMU3bIB\u000b'/];fi\u001aKG.Z\u0001\fO\u0016$h)\u001b7f\u0019&\u001cH\u000f\u0006\u0003\u0003~\u000eE\u0001C\u0002B%\u0005W\u0012y\u0010\u0005\u0004\u0004\u0002\r-\u0011q\u0002\b\u0005\u0007\u0007\u00199A\u0004\u0003\u0002\u0016\r\u0015\u0011\"\u00010\n\u0007\r%Q,A\u0004qC\u000e\\\u0017mZ3\n\t\r51q\u0002\u0002\u0004'\u0016\f(bAB\u0005;\"9!1\u000f!A\u0002\u0005=\u0011A\u0003:f[>4XMR5mKR!!qIB\f\u0011\u001d\u0011\u0019(\u0011a\u0001\u0003\u001f\t\u0011B]3n_Z,G)\u001b:\u0015\t\t\u001d3Q\u0004\u0005\b\u0005g\u0012\u0005\u0019AA\b\u0003)\u0019'/Z1uK\u001aKG.\u001a\u000b\u0005\u0005\u000f\u001a\u0019\u0003C\u0004\u0003t\r\u0003\r!a\u0004\u0002\u0013\r\u0014X-\u0019;f\t&\u0014HC\u0002B$\u0007S\u0019Y\u0003C\u0004\u0003t\u0011\u0003\r!a\u0004\t\u000f\r5B\t1\u0001\u0002\u0010\u0005Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u0002\u0015\u0019LG.Z#ySN$8\u000f\u0006\u0003\u00044\rm\u0002C\u0002B%\u0005W\u001a)\u0004E\u0002]\u0007oI1a!\u000f^\u0005\u001d\u0011un\u001c7fC:DqAa\u001dF\u0001\u0004\ty!A\u000bhKRLU\u000e]3sg>t\u0017\r^5p]R{7.\u001a8\u0015\t\r\u000531\t\t\u0007\u0005\u0013\u0012Y'a\u0004\t\u000f\r\u0015c\t1\u0001\u0002\u0010\u0005!Qo]3s\u000359W\r^$m_\n\u001cF/\u0019;vgR!!Q`B&\u0011\u001d\u0019ie\u0012a\u0001\u0003\u001f\tq\u0001]1ui\u0016\u0014h.A\u0007hKR\fukU(qi&|gn]\u0001\u000eO\u0016$xiQ*PaRLwN\\:\u0002\u001bU\u001cXMR5mKNK8\u000f^3n+\u0011\u00199f!\u0018\u0015\r\re3\u0011MB2!\u0019\u0011IEa\u001b\u0004\\A!!qTB/\t\u001d\u0019yF\u0013b\u0001\u0005K\u0013\u0011\u0001\u0016\u0005\b\u0005gR\u0005\u0019AA\b\u0011\u001d\u0019)G\u0013a\u0001\u0007O\n\u0001BZ:BGRLwN\u001c\t\n9\u000e%4Q\u000eB\r\u00073J1aa\u001b^\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0003\u001c\r=\u0014\u0002BB9\u0005;\u0011!BR5mKNK8\u000f^3n\u0011\u0019q7\u00011\u0001\u0004vA\u0019Ana\u001e\n\u0007\reTNA\u0010ESN$(/\u001b2vi\u0016$g)\u001b7fgf\u001cH/Z7SK\u0006$7i\u001c8gS\u001e$2!ZB?\u0011\u0019qG\u00011\u0001\u0004\u0000A\u0019An!!\n\u0007\r\rUN\u0001\u0006SK\u0006$7i\u001c8gS\u001e\u0004")
public class HadoopFileStoreLayer
implements FileStoreLayerInterface {
    private final FileStoreConfig fileStoreConfig;
    private final String S3_ACCESS_KEY;
    private final String S3_SECRET_KEY;
    private final String S3_SESSION_TOKEN;
    private final String AWS_CREDENTIALS_PROVIDER;
    private final String S3_ENDPOINT;
    private final String S3_ENABLE_SSL;
    private final String S3_ENABLE_PATH_STYLE;
    private final Logger logger;
    private final Text WEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text SWEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text HDFS_DELEGATION_TOKEN_TEXT;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_READ;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    private final String PARQUET_FIELD_ID_WRITE_ENABLED;
    private Option<ParquetWriter<InternalRow>> writer;
    private Option<HadoopFileStoreReader> reader;
    private final Configuration hdfsConfig;
    private final AWSOptions awsOptions;
    private final GCSOptions gcsOptions;

    public static HadoopFileStoreLayer make(ReadConfig config) {
        return HadoopFileStoreLayer$.MODULE$.make(config);
    }

    public static HadoopFileStoreLayer make(DistributedFilesystemReadConfig config) {
        return HadoopFileStoreLayer$.MODULE$.make(config);
    }

    private String S3_ACCESS_KEY() {
        return this.S3_ACCESS_KEY;
    }

    private String S3_SECRET_KEY() {
        return this.S3_SECRET_KEY;
    }

    private String S3_SESSION_TOKEN() {
        return this.S3_SESSION_TOKEN;
    }

    private String AWS_CREDENTIALS_PROVIDER() {
        return this.AWS_CREDENTIALS_PROVIDER;
    }

    private String S3_ENDPOINT() {
        return this.S3_ENDPOINT;
    }

    private String S3_ENABLE_SSL() {
        return this.S3_ENABLE_SSL;
    }

    private String S3_ENABLE_PATH_STYLE() {
        return this.S3_ENABLE_PATH_STYLE;
    }

    public Logger logger() {
        return this.logger;
    }

    private Text WEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.WEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text SWEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.SWEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text HDFS_DELEGATION_TOKEN_TEXT() {
        return this.HDFS_DELEGATION_TOKEN_TEXT;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_READ() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_READ;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    private String PARQUET_FIELD_ID_WRITE_ENABLED() {
        return this.PARQUET_FIELD_ID_WRITE_ENABLED;
    }

    private Option<ParquetWriter<InternalRow>> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<ParquetWriter<InternalRow>> x$1) {
        this.writer = x$1;
    }

    private Option<HadoopFileStoreReader> reader() {
        return this.reader;
    }

    private void reader_$eq(Option<HadoopFileStoreReader> x$1) {
        this.reader = x$1;
    }

    public Configuration hdfsConfig() {
        return this.hdfsConfig;
    }

    private AWSOptions awsOptions() {
        return this.awsOptions;
    }

    private GCSOptions gcsOptions() {
        return this.gcsOptions;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openWriteParquetFile(String filename) {
        Either writerOrError;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(23).append("Opening write to file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaParquetBuilder builder = new VerticaParquetBuilder(new Path(String.valueOf(filename)));
        Either either = writerOrError = this.removeFile(filename).flatMap((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            return Try$.MODULE$.apply((Function0 & Serializable)() -> builder.withConf(this.hdfsConfig()).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withCompressionCodec(CompressionCodecName.SNAPPY).build()).toEither().left().map((Function1 & Serializable)exception -> new OpenWriteError((Throwable)exception).context("Error opening write to HDFS.")).map((Function1 & Serializable)writer -> writer);
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            return new Left((Object)err);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            ParquetWriter writer = (ParquetWriter)right.value();
            this.writer_$eq((Option<ParquetWriter<InternalRow>>)new Some((Object)writer));
            return new Right((Object)BoxedUnit.UNIT);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeDataToParquetFile(DataBlock dataBlock) {
        Left left;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            left = new Right((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            left = new Left((Object)new IntermediaryStoreWriterNotInitializedError().context("Error writing parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return left.flatMap((Function1 & Serializable)writer -> ((Either)implicits$.MODULE$.toTraverseOps(dataBlock.data(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)record -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> writer.write(record)).toEither().left().map((Function1 & Serializable)exception -> new IntermediaryStoreWriteError((Throwable)exception).context("Error writing parquet file to HDFS.")), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)x$4 -> {
            list = x$4;
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> closeWriteParquetFile() {
        Left left;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            left = new Right((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            left = new Left((Object)new IntermediaryStoreWriterNotInitializedError().context("Error closing write of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return left.flatMap((Function1 & Serializable)writer -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> writer.close()).toEither().left().map((Function1 & Serializable)exception -> new CloseWriteError((Throwable)exception).context("Error closing write of parquet file to HDFS.")).map((Function1 & Serializable)x$5 -> {
            boxedUnit = x$5;
            return BoxedUnit.UNIT;
        }));
    }

    private <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(map.entrySet()).asScala()).foreach((Function1 & Serializable)entry -> setMultiMap.put(entry.getKey(), Collections.singleton(entry.getValue())));
        return Collections.unmodifiableMap(setMultiMap);
    }

    @Override
    public Either<ConnectorError, ParquetFileMetadata> getParquetFileMetadata(String filename) {
        Path path = new Path(String.valueOf(filename));
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);
            int rowGroupCount = reader.getRowGroups().size();
            reader.close();
            return new ParquetFileMetadata(filename, rowGroupCount);
        }).toEither().left().map((Function1 & Serializable)exception -> new FileListError((Throwable)exception).context(new StringBuilder(33).append("Error getting metadata for file ").append(filename).append(".").toString()));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openReadParquetFile(ParquetFileRange file) {
        Either readerOrError;
        BoxedUnit boxedUnit;
        String filename = file.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(24).append("Opening read from file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)None$.MODULE$, false, LegacyBehaviorPolicy$.MODULE$.CORRECTED(), LegacyBehaviorPolicy$.MODULE$.CORRECTED());
        Either either = readerOrError = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile);
            FileMetaData parquetFileMetadata = fileReader.getFooter().getFileMetaData();
            MessageType fileSchema = parquetFileMetadata.getSchema();
            Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
            ReadSupport.ReadContext readContext = readSupport.init(new InitContext(this.hdfsConfig(), this.toSetMultiMap(fileMetadata), fileSchema));
            RecordMaterializer<InternalRow> recordConverter = readSupport.prepareForRead(this.hdfsConfig(), fileMetadata, fileSchema, readContext);
            MessageType requestedSchema = readContext.getRequestedSchema();
            fileReader.setRequestedSchema(requestedSchema);
            ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
            boolean strictTypeChecking = false;
            MessageColumnIO columnIO = columnIOFactory.getColumnIO(requestedSchema, fileSchema, strictTypeChecking);
            return new HadoopFileStoreReader(fileReader, columnIO, recordConverter, file);
        }).toEither().left().map((Function1 & Serializable)exception -> new OpenReadError((Throwable)exception).context("Error creating Parquet Reader"));
        if (either instanceof Right) {
            Right right = (Right)either;
            HadoopFileStoreReader reader = (HadoopFileStoreReader)right.value();
            this.reader_$eq((Option<HadoopFileStoreReader>)new Some((Object)reader));
            return new Right((Object)BoxedUnit.UNIT);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            return new Left((Object)err);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public Either<ConnectorError, DataBlock> readDataFromParquetFile(int blockSize) {
        Left left;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            left = new Right((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            left = new Left((Object)new IntermediaryStoreReaderNotInitializedError().context("Error reading parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return left.flatMap((Function1 & Serializable)reader -> reader.read(blockSize).map((Function1 & Serializable)dataBlock -> dataBlock)).map((Function1 & Serializable)dataBlock -> dataBlock);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> closeReadParquetFile() {
        Left left;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            left = new Right((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            left = new Left((Object)new IntermediaryStoreReaderNotInitializedError().context("Error closing read of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        Either r = left.flatMap((Function1 & Serializable)reader -> reader.close().map((Function1 & Serializable)x$6 -> {
            boxedUnit = x$6;
            return BoxedUnit.UNIT;
        }));
        this.reader_$eq((Option<HadoopFileStoreReader>)None$.MODULE$);
        return r;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getFileList(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable)(fs, path) -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> fs.listStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                return new Right((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fileStatuses), (Function1 & Serializable)x$7 -> x$7.getPath().toString(), ClassTag$.MODULE$.apply(String.class)))));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                return new Left((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            }
            throw new MatchError((Object)try_);
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable)(fs, path) -> {
            if (fs.exists(path)) {
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable)exception -> new RemoveFileError((Path)path, (Throwable)exception).context("Error removing HDFS file."));
            }
            return new Right((Object)BoxedUnit.UNIT);
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeDir(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable)(fs, path) -> {
            if (fs.exists(path)) {
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable)exception -> new RemoveDirectoryError((Path)path, (Throwable)exception).context("Error removing HDFS directory."));
            }
            return new Right((Object)BoxedUnit.UNIT);
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable)(fs, path) -> {
            if (!fs.exists(path)) {
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    FSDataOutputStream stream = fs.create(path);
                    stream.write(0);
                    stream.close();
                }).toEither().left().map((Function1 & Serializable)exception -> new CreateFileError((Path)path, (Throwable)exception).context("Error creating HDFS file."));
            }
            return new Left((Object)new CreateFileAlreadyExistsError(filename));
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createDir(String filename, String permission) {
        FsPermission perms = new FsPermission(permission);
        return this.useFileSystem(filename, (Function2 & Serializable)(fs, path) -> {
            if (!fs.exists(path)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Making path ").append(path).append(" with permissions: ").append(perms.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> fs.mkdirs(path, perms)).toEither().left().map((Function1 & Serializable)exception -> new CreateDirectoryError((Path)path, (Throwable)exception).context("Error creating HDFS directory."));
            }
            return new Left((Object)new CreateDirectoryAlreadyExistsError(filename));
        });
    }

    @Override
    public Either<ConnectorError, Object> fileExists(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable)(fs, path) -> new Right((Object)BoxesRunTime.boxToBoolean((boolean)fs.exists(path))));
    }

    @Override
    public Either<ConnectorError, String> getImpersonationToken(String user) {
        ObjectRef hdfsToken = ObjectRef.create((Object)None$.MODULE$);
        Option ugiUser = Option$.MODULE$.apply((Object)UserGroupInformation.getLoginUser());
        Option option = ugiUser;
        if (None$.MODULE$.equals(option)) {
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserGroupInformation user2 = (UserGroupInformation)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Got UGI user.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Collection existingTokens = user2.getCredentials().getAllTokens();
            for (Token token : existingTokens) {
                BoxedUnit boxedUnit2;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(21).append("Existing token kind: ").append(tokenKind.toString()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken.elem = new Some((Object)token.encodeToUrlString());
            }
        } else {
            throw new MatchError((Object)option);
        }
        this.useFileSystem(this.fileStoreConfig.address(), (Function2 & Serializable)(fs, x$8) -> {
            Token[] tokens = fs.addDelegationTokens(user, null);
            Iterator itr = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])tokens));
            while (itr.hasNext()) {
                BoxedUnit boxedUnit;
                Token token = (Token)itr.next();
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Hadoop impersonation: IT kind: ").append(tokenKind.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken$1.elem = new Some((Object)token.encodeToUrlString());
            }
            return new Right((Object)BoxedUnit.UNIT);
        });
        Option option2 = (Option)hdfsToken.elem;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String token = (String)some.value();
            return new Right((Object)token);
        }
        if (None$.MODULE$.equals(option2)) {
            return new Left((Object)new MissingHDFSImpersonationTokenError(user, this.fileStoreConfig.address()));
        }
        throw new MatchError((Object)option2);
    }

    @Override
    public Either<ConnectorError, Seq<String>> getGlobStatus(String pattern) {
        return this.useFileSystem(pattern, (Function2 & Serializable)(fs, path) -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> fs.globStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                return new Right((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fileStatuses), (Function1 & Serializable)x$9 -> x$9.getPath().toString(), ClassTag$.MODULE$.apply(String.class)))));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                return new Left((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            }
            throw new MatchError((Object)try_);
        });
    }

    @Override
    public AWSOptions getAWSOptions() {
        return this.fileStoreConfig.awsOptions();
    }

    @Override
    public GCSOptions getGCSOptions() {
        return this.fileStoreConfig.gcsOptions();
    }

    private <T> Either<ConnectorError, T> useFileSystem(String filename, Function2<FileSystem, Path, Either<ConnectorError, T>> fsAction) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(16).append("Filestore path: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            FileSystem fs = path.getFileSystem(this.hdfsConfig());
            return (Either)fsAction.apply((Object)fs, (Object)path);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Either value = (Either)success.value();
            return value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return new Left((Object)new FileStoreThrownError(exception));
        }
        throw new MatchError((Object)try_);
    }

    public HadoopFileStoreLayer(FileStoreConfig fileStoreConfig, Option<StructType> schema) {
        this.fileStoreConfig = fileStoreConfig;
        this.S3_ACCESS_KEY = "fs.s3a.access.key";
        this.S3_SECRET_KEY = "fs.s3a.secret.key";
        this.S3_SESSION_TOKEN = "fs.s3a.session.token";
        this.AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
        this.S3_ENDPOINT = "fs.s3a.endpoint";
        this.S3_ENABLE_SSL = "fs.s3a.connection.ssl.enabled";
        this.S3_ENABLE_PATH_STYLE = "fs.s3a.path.style.access";
        this.logger = LogProvider$.MODULE$.getLogger(HadoopFileStoreLayer.class);
        this.WEBHDFS_DELEGATION_TOKEN_TEXT = new Text("WEBHDFS delegation");
        this.SWEBHDFS_DELEGATION_TOKEN_TEXT = new Text("SWEBHDFS delegation");
        this.HDFS_DELEGATION_TOKEN_TEXT = new Text("HDFS_DELEGATION_TOKEN");
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_REBASE_MODE_IN_READ = "spark.sql.legacy.parquet.datetimeRebaseModeInRead";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
        this.PARQUET_FIELD_ID_WRITE_ENABLED = "spark.sql.parquet.fieldId.write.enabled";
        this.writer = None$.MODULE$;
        this.reader = None$.MODULE$;
        this.hdfsConfig = new Configuration();
        Option<StructType> option = schema;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            StructType schema2 = (StructType)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("Read and write support schema: ").append(schema2).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), schema2.json());
            this.hdfsConfig().set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), schema2.json());
            ParquetWriteSupport$.MODULE$.setSchema(schema2, this.hdfsConfig());
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        this.awsOptions = fileStoreConfig.awsOptions();
        Option<SensitiveArg<String>> option2 = this.awsOptions().awsCredentialsProvider();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            SensitiveArg provider = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.AWS_CREDENTIALS_PROVIDER(), (String)provider.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Setting {}: {}", new Object[]{this.AWS_CREDENTIALS_PROVIDER(), provider});
            }
        } else if (None$.MODULE$.equals(option2)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS credentials provider for Hadoop config");
            }
        } else {
            throw new MatchError(option2);
        }
        Option<AWSAuth> option3 = this.awsOptions().awsAuth();
        if (option3 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option3;
            AWSAuth auth = (AWSAuth)some.value();
            this.hdfsConfig().set(this.S3_ACCESS_KEY(), auth.accessKeyId().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ACCESS_KEY(), auth.accessKeyId().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(this.S3_SECRET_KEY(), auth.secretAccessKey().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SECRET_KEY(), auth.secretAccessKey().origin()});
            }
        } else if (None$.MODULE$.equals(option3)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS auth for Hadoop config");
            }
        } else {
            throw new MatchError(option3);
        }
        Option<SensitiveArg<String>> option4 = this.awsOptions().awsSessionToken();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            SensitiveArg token = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_SESSION_TOKEN(), (String)token.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SESSION_TOKEN(), token.origin()});
            }
        } else if (None$.MODULE$.equals(option4)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS session token for Hadoop config");
            }
        } else {
            throw new MatchError(option4);
        }
        Option<SensitiveArg<String>> option5 = this.awsOptions().awsEndpoint();
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            SensitiveArg endpoint = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENDPOINT(), (String)endpoint.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENDPOINT(), endpoint.origin()});
            }
        } else if (None$.MODULE$.equals(option5)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS endpoint, using default.");
            }
        } else {
            throw new MatchError(option5);
        }
        Option<SensitiveArg<String>> option6 = this.awsOptions().enableSSL();
        if (option6 instanceof Some) {
            Some some = (Some)option6;
            SensitiveArg enable = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_SSL(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_SSL(), enable.origin()});
            }
        } else if (None$.MODULE$.equals(option6)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS SSL enabled flag, using default of true.");
            }
        } else {
            throw new MatchError(option6);
        }
        Option<SensitiveArg<String>> option7 = this.awsOptions().enablePathStyle();
        if (option7 instanceof Some) {
            Some some = (Some)option7;
            SensitiveArg enable = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_PATH_STYLE(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_PATH_STYLE(), enable.origin()});
            }
        } else if (None$.MODULE$.equals(option7)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS path style enabled flag, using default of false.");
            }
        } else {
            throw new MatchError(option7);
        }
        this.gcsOptions = fileStoreConfig.gcsOptions();
        Option<SensitiveArg<String>> option8 = this.gcsOptions().gcsServiceKeyFile();
        if (option8 instanceof Some) {
            Some some = (Some)option8;
            SensitiveArg auth = (SensitiveArg)some.value();
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_JSON_KEYFILE(), (String)auth.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{GCSSparkOptions$.MODULE$.SERVICE_JSON_KEYFILE(), auth.origin()});
            }
        } else if (None$.MODULE$.equals(option8)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not load GCS key file");
            }
        } else {
            throw new MatchError(option8);
        }
        Option<GCSServiceAuth> option9 = this.gcsOptions().gcsServiceAuth();
        if (option9 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Some some = (Some)option9;
            GCSServiceAuth auth = (GCSServiceAuth)some.value();
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY_ID(), auth.serviceKeyId().arg());
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY(), auth.serviceKeySecret().arg());
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_EMAIL(), auth.serviceEmail().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key id from {}", (Object)auth.serviceKeyId().origin());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key secret from {}", (Object)auth.serviceKeySecret().origin());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key email from {}", (Object)auth.serviceEmail().origin());
            }
        } else if (None$.MODULE$.equals(option9)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not load Google Cloud Storage service account authentications");
            }
        } else {
            throw new MatchError(option9);
        }
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), "true");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), "INT96");
        this.hdfsConfig().set(this.PARQUET_FIELD_ID_WRITE_ENABLED(), "false");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_READ(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        this.hdfsConfig().set("fs.permissions.umask-mode", "000");
    }

    private class VerticaParquetBuilder
    extends ParquetWriter.Builder<InternalRow, VerticaParquetBuilder> {
        public VerticaParquetBuilder self() {
            return this;
        }

        public ParquetWriteSupport getWriteSupport(Configuration conf) {
            return new ParquetWriteSupport();
        }

        public /* synthetic */ HadoopFileStoreLayer com$vertica$spark$datasource$fs$HadoopFileStoreLayer$VerticaParquetBuilder$$$outer() {
            return HadoopFileStoreLayer.this;
        }

        public VerticaParquetBuilder(Path file) {
            if (HadoopFileStoreLayer.this == null) {
                throw null;
            }
            super(file);
        }
    }
}

