/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.jdbc;

import buildinfo.BuildInfo$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.BasicJdbcAuth;
import com.vertica.spark.config.GCSOptions;
import com.vertica.spark.config.GCSVerticaAuth;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.JDBCTLSConfig;
import com.vertica.spark.config.JdbcAuth;
import com.vertica.spark.config.KerberosAuth;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.SensitiveArg;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerIntParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerStringParam;
import com.vertica.spark.util.error.ConnectionDownError;
import com.vertica.spark.util.error.ConnectionError;
import com.vertica.spark.util.error.ConnectionSqlError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DataError;
import com.vertica.spark.util.error.GenericError;
import com.vertica.spark.util.error.MissingNameNodeAddressError;
import com.vertica.spark.util.error.NoSparkSessionFound;
import com.vertica.spark.util.error.ParamsNotSupported;
import com.vertica.spark.util.error.SyntaxError;
import com.vertica.spark.util.general.Utils$;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001\u0002\u0014(\u0001IB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019\u0011\u0006\u0001)A\u0005\u0015\"91\u000b\u0001b\u0001\n\u0013!\u0006BB/\u0001A\u0003%Q\u000bC\u0004_\u0001\t\u0007I\u0011B0\t\r\u0019\u0004\u0001\u0015!\u0003a\u0011\u001d9\u0007A1A\u0005\nQCa\u0001\u001b\u0001!\u0002\u0013)\u0006bB5\u0001\u0001\u0004%IA\u001b\u0005\b]\u0002\u0001\r\u0011\"\u0003p\u0011\u0019)\b\u0001)Q\u0005W\"Aa\u000f\u0001EC\u0002\u0013%q\u000fC\u0004\u0002,\u0001!I!!\f\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA2\u0001\u0011%\u0011Q\r\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\u001c\u0002!\t!!(\t\u0013\u0005-\u0006!%A\u0005\u0002\u00055\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\n\u0003\u001b\u0004\u0011\u0013!C\u0001\u0003[Cq!a4\u0001\t\u0003\t\t\u000eC\u0005\u0002`\u0002\t\n\u0011\"\u0001\u0002.\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\bbBAs\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003O\u0004A\u0011AAr\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDq!!<\u0001\t\u0003\ty\u000fC\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!9!Q\u0002\u0001\u0005\n\t=\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0005A1VM\u001d;jG\u0006TEMY2MCf,'O\u0003\u0002)S\u0005!!\u000e\u001a2d\u0015\tQ3&\u0001\u0006eCR\f7o\\;sG\u0016T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013a\u0002<feRL7-\u0019\u0006\u0002a\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\tQ4(D\u0001(\u0013\tatE\u0001\nKI\n\u001cG*Y=fe&sG/\u001a:gC\u000e,\u0017aA2gOB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iK\u0001\u0007G>tg-[4\n\u0005\r\u0003%A\u0003&E\u0005\u000e\u001buN\u001c4jO\u00061A(\u001b8jiz\"\"AR$\u0011\u0005i\u0002\u0001\"B\u001f\u0003\u0001\u0004q\u0014A\u00027pO\u001e,'/F\u0001K!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002P_\u0005AA/\u001f9fg\u00064W-\u0003\u0002R\u0019\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0004uQJ,\u0017\rZ\u000b\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0005Y\u0006twMC\u0001[\u0003\u0011Q\u0017M^1\n\u0005q;&AB*ue&tw-A\u0004uQJ,\u0017\r\u001a\u0011\u0002\tA\u0014x\u000e]\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111-W\u0001\u0005kRLG.\u0003\u0002fE\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u000bA\u0014x\u000e\u001d\u0011\u0002\u000f)$'mY+S\u0013\u0006A!\u000e\u001a2d+JK\u0005%A\bmCjL\u0018J\\5uS\u0006d\u0017N_3e+\u0005Y\u0007C\u0001\u001bm\u0013\tiWGA\u0004C_>dW-\u00198\u0002'1\f'0_%oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u0005A\u001c\bC\u0001\u001br\u0013\t\u0011XG\u0001\u0003V]&$\bb\u0002;\r\u0003\u0003\u0005\ra[\u0001\u0004q\u0012\n\u0014\u0001\u00057bufLe.\u001b;jC2L'0\u001a3!\u0003)\u0019wN\u001c8fGRLwN\\\u000b\u0002qB)\u00110!\u0007\u0002 9\u0019!0a\u0005\u000f\u0007m\fiAD\u0002}\u0003\u0017q1!`A\u0005\u001d\rq\u0018q\u0001\b\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019!M\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!AL\u0018\n\u00051j\u0013BA2,\u0013\u0011\ty!!\u0005\u0002\u000b\u0015\u0014(o\u001c:\u000b\u0005\r\\\u0013\u0002BA\u000b\u0003/\tQ\"\u0012:s_JD\u0015M\u001c3mS:<'\u0002BA\b\u0003#IA!a\u0007\u0002\u001e\ty1i\u001c8oK\u000e$xN\u001d*fgVdGO\u0003\u0003\u0002\u0016\u0005]\u0001\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015\u0012,A\u0002tc2LA!!\u000b\u0002$\tQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002#\r\u0014X-\u0019;f\u00072LWM\u001c;MC\n,G.\u0006\u0002\u00020A!\u0011\u0011GA\u001d\u001d\u0011\t\u0019$!\u000e\u0011\u0005},\u0014bAA\u001ck\u00051\u0001K]3eK\u001aL1\u0001XA\u001e\u0015\r\t9$N\u0001\u001aQ\u0006tG\r\\3D_:tWm\u0019;j_:,\u0005pY3qi&|g\u000e\u0006\u0003\u0002B\u0005%\u0003\u0003BA\"\u0003\u000bj!!a\u0006\n\t\u0005\u001d\u0013q\u0003\u0002\u000f\u0007>tg.Z2u_J,%O]8s\u0011\u001d\tY\u0005\u0005a\u0001\u0003\u001b\n\u0011!\u001a\t\u0005\u0003\u001f\nIF\u0004\u0003\u0002R\u0005UcbA@\u0002T%\ta'C\u0002\u0002XU\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\\\u0005u#!\u0003+ie><\u0018M\u00197f\u0015\r\t9&N\u0001\u0011C\u0012$G\u000bT*Qe>\u0004XM\u001d;jKN$\u0012\u0001]\u0001\rO\u0016$8\u000b^1uK6,g\u000e^\u000b\u0003\u0003O\u0002R!_A\r\u0003S\u0002B!!\t\u0002l%!\u0011QNA\u0012\u0005%\u0019F/\u0019;f[\u0016tG/\u0001\u000bhKR\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u000b\u0005\u0003g\nY\bE\u0003z\u00033\t)\b\u0005\u0003\u0002\"\u0005]\u0014\u0002BA=\u0003G\u0011\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0011\u001d\t)c\u0005a\u0001\u0003_\t1\u0003[1oI2,'\n\u0012\"D\u000bb\u001cW\r\u001d;j_:$B!!\u0011\u0002\u0002\"9\u00111\n\u000bA\u0002\u00055\u0013\u0001F1eIB\u000b'/Y7t)>\u001cF/\u0019;f[\u0016tG\u000fF\u0003q\u0003\u000f\u000bY\tC\u0004\u0002\nV\u0001\r!!\u001e\u0002\u0013M$\u0018\r^3nK:$\bbBAG+\u0001\u0007\u0011qR\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\r\u0005=\u0013\u0011SAK\u0013\u0011\t\u0019*!\u0018\u0003\u0007M+\u0017\u000fE\u0002;\u0003/K1!!'(\u00059QEMY2MCf,'\u000fU1sC6\fQ!];fef$b!a(\u0002(\u0006%\u0006#B=\u0002\u001a\u0005\u0005\u0006\u0003BA\u0011\u0003GKA!!*\u0002$\tI!+Z:vYR\u001cV\r\u001e\u0005\b\u000373\u0002\u0019AA\u0018\u0011%\tiI\u0006I\u0001\u0002\u0004\ty)A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyK\u000b\u0003\u0002\u0010\u0006E6FAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uV'\u0001\u0006b]:|G/\u0019;j_:LA!!1\u00028\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000f\u0015DXmY;uKR1\u0011qYAe\u0003\u0017\u0004B!_A\ra\"9\u0011\u0011\u0012\rA\u0002\u0005=\u0002\"CAG1A\u0005\t\u0019AAH\u0003E)\u00070Z2vi\u0016$C-\u001a4bk2$HEM\u0001\u000eKb,7-\u001e;f+B$\u0017\r^3\u0015\r\u0005M\u00171\\Ao!\u0015I\u0018\u0011DAk!\r!\u0014q[\u0005\u0004\u00033,$aA%oi\"9\u0011\u0011\u0012\u000eA\u0002\u0005=\u0002\"CAG5A\u0005\t\u0019AAH\u0003])\u00070Z2vi\u0016,\u0006\u000fZ1uK\u0012\"WMZ1vYR$#'A\u0003dY>\u001cX\r\u0006\u0002\u0002H\u000611m\\7nSR\f\u0001B]8mY\n\f7m[\u0001\tSN\u001cEn\\:fIR\t1.\u0001\td_:4\u0017nZ;sKN+7o]5p]R!\u0011qYAy\u0011\u001d\t\u0019\u0010\ta\u0001\u0003k\faBZ5mKN#xN]3MCf,'\u000f\u0005\u0003\u0002x\u0006uXBAA}\u0015\r\tY0K\u0001\u0003MNLA!a@\u0002z\n9b)\u001b7f'R|'/\u001a'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-Z\u0001\u0017G>tg-[4ve\u0016\fuk\u0015)be\u0006lW\r^3sgR!\u0011q\u0019B\u0003\u0011\u001d\t\u00190\ta\u0001\u0003k\facY8oM&<WO]3H\u0007N\u0003\u0016M]1nKR,'o\u001d\u000b\u0005\u0003\u000f\u0014Y\u0001C\u0004\u0002t\n\u0002\r!!>\u00029\r|gNZ5hkJ,7*\u001a:cKJ|7\u000fV8GS2,7\u000f^8sKR!\u0011q\u0019B\t\u0011\u001d\t\u0019p\ta\u0001\u0003k\f\u0001\u0003\\8h\u0011\u0006$wn\u001c9D_:4\u0017nZ:\u0015\u0007A\u00149\u0002C\u0004\u0003\u001a\u0011\u0002\rAa\u0007\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0003\u001e\t=RB\u0001B\u0010\u0015\u0011\u0011\tCa\t\u0002\t\r|gN\u001a\u0006\u0005\u0005K\u00119#\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0005\u0005S\u0011Y#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0005[\t1a\u001c:h\u0013\u0011\u0011\tDa\b\u0003\u001b\r{gNZ5hkJ\fG/[8o\u00035)8/Z\"p]:,7\r^5p]V!!q\u0007B )!\u0011ID!\u0015\u0003T\tu\u0003#B=\u0002\u001a\tm\u0002\u0003\u0002B\u001f\u0005\u007fa\u0001\u0001B\u0004\u0003B\u0015\u0012\rAa\u0011\u0003\u0003Q\u000bBA!\u0012\u0003LA\u0019AGa\u0012\n\u0007\t%SGA\u0004O_RD\u0017N\\4\u0011\u0007Q\u0012i%C\u0002\u0003PU\u00121!\u00118z\u0011\u00191X\u00051\u0001\u0002 !9!QK\u0013A\u0002\t]\u0013AB1di&|g\u000eE\u00045\u00053\nyBa\u000f\n\u0007\tmSGA\u0005Gk:\u001cG/[8oc!9!qL\u0013A\u0002\t\u0005\u0014\u0001E3yG\u0016\u0004H/[8o\u0007\u0006$8\r[3s!\u001d!$\u0011LA'\u0003\u0003\u0002")
public class VerticaJdbcLayer
implements JdbcLayerInterface {
    private Either<ConnectorError, Connection> connection;
    private final JDBCConfig cfg;
    private final Logger logger;
    private final String thread;
    private final Properties prop;
    private final String jdbcURI;
    private boolean lazyInitialized;
    private volatile boolean bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    private String thread() {
        return this.thread;
    }

    private Properties prop() {
        return this.prop;
    }

    private String jdbcURI() {
        return this.jdbcURI;
    }

    private boolean lazyInitialized() {
        return this.lazyInitialized;
    }

    private void lazyInitialized_$eq(boolean x$1) {
        this.lazyInitialized = x$1;
    }

    private Either<ConnectorError, Connection> connection$lzycompute() {
        VerticaJdbcLayer verticaJdbcLayer = this;
        synchronized (verticaJdbcLayer) {
            if (!this.bitmap$0) {
                this.connection = Try$.MODULE$.apply((Function0 & Serializable)() -> DriverManager.getConnection(this.jdbcURI(), this.prop())).toEither().left().map((Function1 & Serializable)e -> this.handleConnectionException((Throwable)e)).flatMap((Function1 & Serializable)conn -> {
                    BoxedUnit boxedUnit;
                    this.lazyInitialized_$eq(true);
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(new StringBuilder(27).append(this.thread()).append("Connection lazy initialized").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return this.useConnection((Connection)conn, (Function1 & Serializable)c -> {
                        BoxedUnit boxedUnit;
                        c.setAutoCommit(false);
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder(34).append(this.thread()).append("Successfully connected to Vertica.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return c;
                    }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable)e -> this.handleConnectionException((Throwable)e)).left().map((Function1 & Serializable)x$1 -> x$1.context("Initial connection was not valid."));
                });
                this.bitmap$0 = true;
            }
        }
        return this.connection;
    }

    private Either<ConnectorError, Connection> connection() {
        if (!this.bitmap$0) {
            return this.connection$lzycompute();
        }
        return this.connection;
    }

    private String createClientLabel() {
        String string;
        String string2;
        JdbcAuth jdbcAuth = this.cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            string2 = "-p";
        } else if (jdbcAuth instanceof KerberosAuth) {
            string2 = "-k";
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        String authMethod = string2;
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            string = session.sparkContext().version();
        } else if (None$.MODULE$.equals(option)) {
            string = "0.0";
        } else {
            throw new MatchError((Object)option);
        }
        String sparkVersion = string;
        return new StringBuilder(12).append("vspark-vs").append(BuildInfo$.MODULE$.version()).append(authMethod).append("-sp").append(sparkVersion).toString();
    }

    private ConnectorError handleConnectionException(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            return new ConnectionSqlError(sQLException);
        }
        if (throwable != null) {
            Throwable throwable2 = throwable;
            return new ConnectionError(throwable2);
        }
        throw new MatchError((Object)throwable);
    }

    private void addTLSProperties() {
        JDBCTLSConfig tlsConfig = this.cfg.tlsConfig();
        Utils$.MODULE$.ignore(this.prop().put("TLSmode", tlsConfig.tlsMode().toString()));
        Option<String> option = tlsConfig.keyStorePath();
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePath", path));
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        Option<String> option2 = tlsConfig.keyStorePassword();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePassword", password));
        } else if (None$.MODULE$.equals(option2)) {
        } else {
            throw new MatchError(option2);
        }
        Option<String> option3 = tlsConfig.trustStorePath();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePath", path));
        } else if (None$.MODULE$.equals(option3)) {
        } else {
            throw new MatchError(option3);
        }
        Option<String> option4 = tlsConfig.trustStorePassword();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePassword", password));
            return;
        }
        if (None$.MODULE$.equals(option4)) {
            return;
        }
        throw new MatchError(option4);
    }

    private Either<ConnectorError, Statement> getStatement() {
        return this.connection().flatMap((Function1 & Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable)c -> c.createStatement(), (Function1<Throwable, ConnectorError>)(Function1 & Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable)x$2 -> x$2.context("getStatement: Error while trying to create statement.")));
    }

    private Either<ConnectorError, PreparedStatement> getPreparedStatement(String sql) {
        return this.connection().flatMap((Function1 & Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable)c -> c.prepareStatement(sql), (Function1<Throwable, ConnectorError>)(Function1 & Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable)x$3 -> x$3.context("getPreparedStatement: Error while getting prepared statement.")));
    }

    @Override
    public ConnectorError handleJDBCException(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLSyntaxErrorException) {
            SQLSyntaxErrorException sQLSyntaxErrorException = (SQLSyntaxErrorException)throwable;
            return new SyntaxError(sQLSyntaxErrorException);
        }
        if (throwable instanceof SQLDataException) {
            SQLDataException sQLDataException = (SQLDataException)throwable;
            return new DataError(sQLDataException);
        }
        if (throwable != null) {
            return new GenericError(e).context("Unexpected SQL Error.");
        }
        throw new MatchError((Object)throwable);
    }

    private void addParamsToStatement(PreparedStatement statement, Seq<JdbcLayerParam> params) {
        ((IterableOnceOps)params.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            VerticaJdbcLayer.$anonfun$addParamsToStatement$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Either<ConnectorError, ResultSet> query(String query, Seq<JdbcLayerParam> params) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(26).append("Attempting to send query: ").append(query).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(query);
            if (either instanceof Right) {
                Right right = (Right)either;
                PreparedStatement stmt = (PreparedStatement)right.value();
                this.addParamsToStatement(stmt, params);
                return new Right((Object)stmt.executeQuery());
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                return new Left((Object)err);
            }
            throw new MatchError(either);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Either v = (Either)success.value();
            return v;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return new Left((Object)this.handleJDBCException(e).context("Error when sending query"));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Seq<JdbcLayerParam> query$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> execute(String statement, Seq<JdbcLayerParam> params) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (params.nonEmpty()) {
                Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(statement);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    PreparedStatement stmt = (PreparedStatement)right.value();
                    this.addParamsToStatement(stmt, params);
                    stmt.execute();
                    return new Right((Object)BoxedUnit.UNIT);
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ConnectorError err = (ConnectorError)left.value();
                    return new Left((Object)err);
                }
                throw new MatchError(either);
            }
            Either<ConnectorError, Statement> either = this.getStatement();
            if (either instanceof Right) {
                Right right = (Right)either;
                Statement stmt = (Statement)right.value();
                stmt.execute(statement);
                return new Right((Object)BoxedUnit.UNIT);
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                return new Left((Object)err);
            }
            throw new MatchError(either);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Either v = (Either)success.value();
            return v;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return new Left((Object)this.handleJDBCException(e));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Seq<JdbcLayerParam> execute$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, Object> executeUpdate(String statement, Seq<JdbcLayerParam> params) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (params.nonEmpty()) {
            return new Left((Object)new ParamsNotSupported("executeUpdate"));
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.getStatement().map((Function1 & Serializable)stmt -> BoxesRunTime.boxToInteger((int)stmt.executeUpdate(statement))));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Either v = (Either)success.value();
            return v;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return new Left((Object)this.handleJDBCException(e));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Seq<JdbcLayerParam> executeUpdate$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> close() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Closing connection.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable)c -> {
            c.close();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable)x$4 -> x$4.context("close: JDBC Error closing the connection.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Commiting.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable)c -> {
            c.commit();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable)x$5 -> x$5.context("commit: JDBC Error while commiting.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> rollback() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Rolling back.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable)c -> {
            c.rollback();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable)x$6 -> x$6.context("rollback: JDBC Error while rolling back.")));
    }

    @Override
    public boolean isClosed() {
        boolean bl;
        block5: {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(23).append(this.thread()).append("Check connection closed").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            try {
                if (this.lazyInitialized()) {
                    bl = BoxesRunTime.unboxToBoolean((Object)this.connection().fold((Function1 & Serializable)err -> BoxesRunTime.boxToBoolean((boolean)VerticaJdbcLayer.$anonfun$isClosed$1(this, err)), (Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)conn.isClosed())));
                    break block5;
                }
                bl = true;
            }
            catch (Throwable throwable) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> configureSession(FileStoreLayerInterface fileStoreLayer) {
        return this.configureKerberosToFilestore(fileStoreLayer).flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            return this.configureAWSParameters(fileStoreLayer).flatMap((Function1 & Serializable)x$8 -> {
                BoxedUnit boxedUnit = x$8;
                return this.configureGCSParameters(fileStoreLayer).map((Function1 & Serializable)x$7 -> {
                    boxedUnit = x$7;
                    return BoxedUnit.UNIT;
                });
            });
        });
    }

    private Either<ConnectorError, BoxedUnit> configureAWSParameters(FileStoreLayerInterface fileStoreLayer) {
        AWSOptions awsOptions = fileStoreLayer.getAWSOptions();
        return new Right((Object)VerticaVersionUtils$.MODULE$.getVersionOrDefault(this)).flatMap((Function1 & Serializable)verticaVersion -> {
            Either<ConnectorError, BoxedUnit> either;
            Option<AWSAuth> option = awsOptions.awsAuth();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                AWSAuth awsAuth = (AWSAuth)some.value();
                String sql = new StringBuilder(29).append("ALTER SESSION SET AWSAuth='").append((Object)awsAuth.accessKeyId().arg()).append(":").append((Object)awsAuth.secretAccessKey().arg()).append("'").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Loaded AWS access key ID from {}", (Object)awsAuth.accessKeyId().origin());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Loaded AWS secret access key from {}", (Object)awsAuth.secretAccessKey().origin());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = this.execute(sql, this.execute$default$2());
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Did not set AWSAuth");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError(option);
            }
            return either.flatMap((Function1 & Serializable)x$15 -> {
                Either<ConnectorError, BoxedUnit> either;
                BoxedUnit boxedUnit = x$15;
                Option<SensitiveArg<String>> option = awsOptions.awsRegion();
                if (option instanceof Some) {
                    BoxedUnit boxedUnit2;
                    Some some = (Some)option;
                    SensitiveArg awsRegion = (SensitiveArg)some.value();
                    String sql = new StringBuilder(30).append("ALTER SESSION SET AWSRegion='").append(awsRegion.arg()).append("'").toString();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Setting AWSRegion for session: {}", (Object)awsRegion);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    either = this.execute(sql, this.execute$default$2());
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit3;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Did not set AWSRegion");
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
                } else {
                    throw new MatchError(option);
                }
                return either.flatMap((Function1 & Serializable)x$14 -> {
                    Either<ConnectorError, BoxedUnit> either;
                    BoxedUnit boxedUnit = x$14;
                    Option<SensitiveArg<String>> option = awsOptions.awsSessionToken();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit2;
                        Some some = (Some)option;
                        SensitiveArg token = (SensitiveArg)some.value();
                        String sql = new StringBuilder(36).append("ALTER SESSION SET AWSSessionToken='").append(token.arg()).append("'").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Loaded AWSSessionToken from {}", (Object)token.origin());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        either = this.execute(sql, this.execute$default$2());
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit3;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Did not set AWSSessionToken");
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
                    } else {
                        throw new MatchError(option);
                    }
                    return either.flatMap((Function1 & Serializable)x$13 -> {
                        Either<ConnectorError, BoxedUnit> either;
                        BoxedUnit boxedUnit = x$13;
                        Option<SensitiveArg<String>> option = awsOptions.awsEndpoint();
                        if (option instanceof Some) {
                            BoxedUnit boxedUnit2;
                            Some some = (Some)option;
                            SensitiveArg endpoint = (SensitiveArg)some.value();
                            String sql = new StringBuilder(32).append("ALTER SESSION SET AWSEndpoint='").append(endpoint.arg()).append("'").toString();
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Loaded AWSEndpoint from {}", (Object)endpoint.origin());
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            either = this.execute(sql, this.execute$default$2());
                        } else if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit3;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Did not set AWSEndpoint");
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
                        } else {
                            throw new MatchError(option);
                        }
                        return either.flatMap((Function1 & Serializable)x$12 -> {
                            Either<ConnectorError, BoxedUnit> either;
                            BoxedUnit boxedUnit = x$12;
                            Option<SensitiveArg<String>> option = awsOptions.enableSSL();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                SensitiveArg enable = (SensitiveArg)some.value();
                                if (verticaVersion.major() < 11) {
                                    BoxedUnit boxedUnit2;
                                    BoxedUnit boxedUnit3;
                                    if (this.logger().underlying().isWarnEnabled()) {
                                        this.logger().underlying().warn("enable_ssl is only support for Vertica version 11+");
                                        boxedUnit3 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit3 = BoxedUnit.UNIT;
                                    }
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Did not set AWSEnableHttps");
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    either = new Right((Object)BoxedUnit.UNIT);
                                } else {
                                    BoxedUnit boxedUnit4;
                                    int enableInt = ((String)enable.arg()).equalsIgnoreCase("true") ? 1 : 0;
                                    String sql = new StringBuilder(33).append("ALTER SESSION SET AWSEnableHttps=").append(enableInt).toString();
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Loaded AWSEnableHttps from {}", (Object)enable.origin());
                                        boxedUnit4 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit4 = BoxedUnit.UNIT;
                                    }
                                    either = this.execute(sql, this.execute$default$2());
                                }
                            } else if (None$.MODULE$.equals(option)) {
                                BoxedUnit boxedUnit5;
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Did not set AWSEnableHttps");
                                    boxedUnit5 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit5 = BoxedUnit.UNIT;
                                }
                                either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
                            } else {
                                throw new MatchError(option);
                            }
                            return either.flatMap((Function1 & Serializable)x$11 -> {
                                Either<ConnectorError, BoxedUnit> either;
                                BoxedUnit boxedUnit = x$11;
                                Option<SensitiveArg<String>> option = awsOptions.enablePathStyle();
                                if (option instanceof Some) {
                                    BoxedUnit boxedUnit2;
                                    Some some = (Some)option;
                                    SensitiveArg enable = (SensitiveArg)some.value();
                                    int enableInt = ((String)enable.arg()).equalsIgnoreCase("true") ? 0 : 1;
                                    String sql = new StringBuilder(44).append("ALTER SESSION SET S3EnableVirtualAddressing=").append(enableInt).toString();
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Loaded S3EnableVirtualAddressing from {}", (Object)enable.origin());
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    either = this.execute(sql, this.execute$default$2());
                                } else if (None$.MODULE$.equals(option)) {
                                    BoxedUnit boxedUnit3;
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Did not set S3EnableVirtualAddressing");
                                        boxedUnit3 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit3 = BoxedUnit.UNIT;
                                    }
                                    either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
                                } else {
                                    throw new MatchError(option);
                                }
                                return either.map((Function1 & Serializable)x$10 -> {
                                    boxedUnit = x$10;
                                    return BoxedUnit.UNIT;
                                });
                            });
                        });
                    });
                });
            });
        });
    }

    private Either<ConnectorError, BoxedUnit> configureGCSParameters(FileStoreLayerInterface fileStoreLayer) {
        Either<ConnectorError, BoxedUnit> either;
        GCSOptions gcsOptions = fileStoreLayer.getGCSOptions();
        Option<GCSVerticaAuth> option = gcsOptions.gcsVerticaAuth();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Some some = (Some)option;
            GCSVerticaAuth gcsAuth = (GCSVerticaAuth)some.value();
            SensitiveArg<String> keyId = gcsAuth.accessKeyId();
            SensitiveArg<String> keySecret = gcsAuth.accessKeySecret();
            String query = new StringBuilder(29).append("ALTER SESSION SET GCSAuth='").append((Object)keyId.arg()).append(":").append((Object)keySecret.arg()).append("'").toString();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage - Vertica access key ID from {}", (Object)gcsAuth.accessKeyId().origin());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage - Vertica access key secret from {}", (Object)gcsAuth.accessKeySecret().origin());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = this.execute(query, this.execute$default$2());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not setup GCS authentications");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return either.map((Function1 & Serializable)x$16 -> {
            boxedUnit = x$16;
            return BoxedUnit.UNIT;
        });
    }

    private Either<ConnectorError, BoxedUnit> configureKerberosToFilestore(FileStoreLayerInterface fileStoreLayer) {
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Hadoop impersonation: found session");
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            Configuration hadoopConf = session.sparkContext().hadoopConfiguration();
            Option authMethod = Option$.MODULE$.apply((Object)hadoopConf.get("hadoop.security.authentication"));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logHadoopConfigs(hadoopConf);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(35).append("Hadoop impersonation: auth method: ").append(authMethod).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Option option2 = authMethod;
            if (option2 instanceof Some) {
                String authMethod2;
                Some some2 = (Some)option2;
                String string = authMethod2 = (String)some2.value();
                String string2 = "kerberos";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return Option$.MODULE$.apply((Object)hadoopConf.get("dfs.namenode.https-address")).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)hadoopConf.get("dfs.namenode.http-address"))).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)hadoopConf.get("dfs.nameservices"))).toRight((Function0 & Serializable)() -> new MissingNameNodeAddressError()).map((Function1 & Serializable)nameNodeAddressOrNameservice -> {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug(new StringBuilder(56).append("Hadoop impersonation: name node address or nameservice: ").append((String)nameNodeAddressOrNameservice).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$17 = boxedUnit;
                        return new Tuple2(nameNodeAddressOrNameservice, (Object)x$17);
                    }).flatMap((Function1 & Serializable)x$20 -> {
                        Tuple2 tuple2 = x$20;
                        if (tuple2 != null) {
                            String nameNodeAddressOrNameservice = (String)tuple2._1();
                            return fileStoreLayer.getImpersonationToken($this.cfg.auth().user()).map((Function1 & Serializable)encodedDelegationToken -> {
                                String string;
                                Option option = Option$.MODULE$.apply((Object)hadoopConf.get("dfs.nameservices"));
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    String nameservice = (String)some.value();
                                    string = new StringBuilder(113).append("\n                  {\n                     \"nameservice\": \"").append(nameservice).append("\",\n                     \"token\": \"").append((String)encodedDelegationToken).append("\"\n                  }").toString();
                                } else if (None$.MODULE$.equals(option)) {
                                    string = new StringBuilder(111).append("\n                  {\n                     \"authority\": \"").append(nameNodeAddressOrNameservice).append("\",\n                     \"token\": \"").append((String)encodedDelegationToken).append("\"\n                  }").toString();
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                String jsonString = string;
                                String sql = new StringBuilder(48).append("ALTER SESSION SET HadoopImpersonationConfig='[").append(jsonString).append("]'").toString();
                                return new Tuple3(encodedDelegationToken, (Object)jsonString, (Object)sql);
                            }).flatMap((Function1 & Serializable)x$19 -> {
                                Tuple3 tuple3 = x$19;
                                if (tuple3 != null) {
                                    String sql = (String)tuple3._3();
                                    return this.execute(sql, this.execute$default$2()).map((Function1 & Serializable)x$18 -> {
                                        boxedUnit = x$18;
                                        return BoxedUnit.UNIT;
                                    });
                                }
                                throw new MatchError((Object)tuple3);
                            });
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Kerberos is not enabled in the hadoop config.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Right((Object)BoxedUnit.UNIT);
        }
        if (None$.MODULE$.equals(option)) {
            return new Left((Object)new NoSparkSessionFound());
        }
        throw new MatchError((Object)option);
    }

    private void logHadoopConfigs(Configuration hadoopConf) {
        BoxedUnit boxedUnit;
        String configs = ((List)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)hadoopConf).asScala()).toList().sortBy((Function1 & Serializable)x$21 -> (String)x$21.getKey(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)entry -> new StringBuilder(1).append(entry.getKey()).append(":").append(entry.getValue()).toString()).mkString("\n");
        String hostname = InetAddress.getLocalHost().getHostName();
        String executorId = SparkEnv$.MODULE$.get().executorId();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Hadoop configurations for host {}, executorId {}:\n{}", new Object[]{hostname, executorId, configs});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private <T> Either<ConnectorError, T> useConnection(Connection connection, Function1<Connection, T> action, Function1<Throwable, ConnectorError> exceptionCatcher) {
        Left left;
        block3: {
            try {
                if (connection.isValid(0)) {
                    left = new Right(action.apply((Object)connection));
                    break block3;
                }
                left = new Left((Object)new ConnectionDownError());
            }
            catch (Throwable e) {
                left = new Left(exceptionCatcher.apply((Object)e));
            }
        }
        return left;
    }

    public static final /* synthetic */ void $anonfun$addParamsToStatement$1(PreparedStatement statement$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            JdbcLayerParam param = (JdbcLayerParam)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            int i = idx + 1;
            JdbcLayerParam jdbcLayerParam = param;
            if (jdbcLayerParam instanceof JdbcLayerStringParam) {
                JdbcLayerStringParam jdbcLayerStringParam = (JdbcLayerStringParam)jdbcLayerParam;
                statement$1.setString(i, jdbcLayerStringParam.value());
            } else if (jdbcLayerParam instanceof JdbcLayerIntParam) {
                JdbcLayerIntParam jdbcLayerIntParam = (JdbcLayerIntParam)jdbcLayerParam;
                statement$1.setInt(i, jdbcLayerIntParam.value());
            } else {
                throw new MatchError((Object)jdbcLayerParam);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isClosed$1(VerticaJdbcLayer $this, ConnectorError err) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(new StringBuilder(0).append($this.thread()).append(err.getFullContext()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return true;
    }

    public VerticaJdbcLayer(JDBCConfig cfg) {
        BoxedUnit boxedUnit;
        this.cfg = cfg;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaJdbcLayer.class);
        this.thread = new StringBuilder(2).append(Thread.currentThread().getName()).append(": ").toString();
        this.prop = new Properties();
        this.prop().put("LABEL", this.createClientLabel());
        JdbcAuth jdbcAuth = cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            BasicJdbcAuth basicJdbcAuth = (BasicJdbcAuth)jdbcAuth;
            String username = basicJdbcAuth.username();
            String password = basicJdbcAuth.password();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("password", password));
        } else if (jdbcAuth instanceof KerberosAuth) {
            KerberosAuth kerberosAuth = (KerberosAuth)jdbcAuth;
            String username = kerberosAuth.username();
            String kerberosServiceName = kerberosAuth.kerberosServiceName();
            String kerberosHostname = kerberosAuth.kerberosHostname();
            String jaasConfigName = kerberosAuth.jaasConfigName();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("KerberosServiceName", kerberosServiceName));
            Utils$.MODULE$.ignore(this.prop().put("KerberosHostname", kerberosHostname));
            Utils$.MODULE$.ignore(this.prop().put("JAASConfigName", jaasConfigName));
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        this.addTLSProperties();
        if (cfg.backupServerNodes().isDefined()) {
            Utils$.MODULE$.ignore(this.prop().put("BackupServerNode", cfg.backupServerNodes().get()));
        }
        Class.forName("com.vertica.jdbc.Driver");
        this.jdbcURI = new StringBuilder(17).append("jdbc:vertica://").append(cfg.host()).append(":").append(cfg.port()).append("/").append(cfg.db()).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(32).append("Connecting to Vertica with URI: ").append(this.jdbcURI()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.lazyInitialized = false;
    }
}

