/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.v2;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.WriteConfig;
import com.vertica.spark.datasource.core.DSConfigSetupInterface;
import com.vertica.spark.datasource.core.DSWriterInterface;
import com.vertica.spark.datasource.core.PartitionInfo;
import com.vertica.spark.datasource.v2.VerticaBatchReader;
import com.vertica.spark.datasource.v2.VerticaWriterFactory;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.error.JobAbortedError;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u000594AAC\u0006\u0001-!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!Y\u0004A!A!\u0002\u0013a\u0004\"B \u0001\t\u0003\u0001\u0005b\u0002$\u0001\u0005\u0004%Ia\u0012\u0005\u0007!\u0002\u0001\u000b\u0011\u0002%\t\u000bE\u0003A\u0011\t*\t\u000bm\u0003A\u0011\t/\t\u000b-\u0004A\u0011\t7\u0003#Y+'\u000f^5dC\n\u000bGo\u00195Xe&$XM\u0003\u0002\r\u001b\u0005\u0011aO\r\u0006\u0003\u001d=\t!\u0002Z1uCN|WO]2f\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00059a/\u001a:uS\u000e\f'\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00019r\u0004\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\t\u0001C&D\u0001\"\u0015\t\u00113%A\u0003xe&$XM\u0003\u0002%K\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003M\u001d\n1a]9m\u0015\t\u0001\u0002F\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017\"\u0005)\u0011\u0015\r^2i/JLG/Z\u0001\u0007G>tg-[4\u0011\u0005A\u0012T\"A\u0019\u000b\u00059z\u0011BA\u001a2\u0005-9&/\u001b;f\u0007>tg-[4\u0002']\u0014\u0018\u000e^3TKR,\b/\u00138uKJ4\u0017mY3\u0011\u0007YJt&D\u00018\u0015\tAT\"\u0001\u0003d_J,\u0017B\u0001\u001e8\u0005Y!5kQ8oM&<7+\u001a;va&sG/\u001a:gC\u000e,\u0017\u0001\u00043sSZ,'o\u0016:ji\u0016\u0014\bC\u0001\u001c>\u0013\tqtGA\tE'^\u0013\u0018\u000e^3s\u0013:$XM\u001d4bG\u0016\fa\u0001P5oSRtD\u0003B!D\t\u0016\u0003\"A\u0011\u0001\u000e\u0003-AQA\f\u0003A\u0002=BQ\u0001\u000e\u0003A\u0002UBQa\u000f\u0003A\u0002q\na\u0001\\8hO\u0016\u0014X#\u0001%\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001D:dC2\fGn\\4hS:<'BA'\u0014\u0003!!\u0018\u0010]3tC\u001a,\u0017BA(K\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001G2sK\u0006$XMQ1uG\"<&/\u001b;fe\u001a\u000b7\r^8ssR\u00111K\u0016\t\u0003AQK!!V\u0011\u0003#\u0011\u000bG/Y,sSR,'OR1di>\u0014\u0018\u0010C\u0003X\u000f\u0001\u0007\u0001,A\tqQf\u001c\u0018nY1m/JLG/Z%oM>\u0004\"\u0001I-\n\u0005i\u000b#!\u0005)isNL7-\u00197Xe&$X-\u00138g_\u000611m\\7nSR$\"!X2\u0011\u0005y\u000bW\"A0\u000b\u0003\u0001\fQa]2bY\u0006L!AY0\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\"\u0001\r!Z\u0001\u0015oJLG/\u001a:D_6l\u0017\u000e^'fgN\fw-Z:\u0011\u0007y3\u0007.\u0003\u0002h?\n)\u0011I\u001d:bsB\u0011\u0001%[\u0005\u0003U\u0006\u00121c\u0016:ji\u0016\u00148i\\7nSRlUm]:bO\u0016\fQ!\u00192peR$\"!X7\t\u000b\u0011L\u0001\u0019A3")
public class VerticaBatchWrite
implements BatchWrite {
    private final WriteConfig config;
    private final DSWriterInterface driverWriter;
    private final Logger logger;

    public boolean useCommitCoordinator() {
        return super.useCommitCoordinator();
    }

    public void onDataWriterCommit(WriterCommitMessage x$1) {
        super.onDataWriterCommit(x$1);
    }

    private Logger logger() {
        return this.logger;
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo physicalWriteInfo) {
        return new VerticaWriterFactory(this.config);
    }

    public void commit(WriterCommitMessage[] writerCommitMessages) {
        Either<ConnectorError, BoxedUnit> either = this.driverWriter.commitRows();
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
        }
        if (either instanceof Right) {
            return;
        }
        throw new MatchError(either);
    }

    public void abort(WriterCommitMessage[] writerCommitMessages) {
        throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new JobAbortedError());
    }

    public VerticaBatchWrite(WriteConfig config, DSConfigSetupInterface<WriteConfig> writeSetupInterface, DSWriterInterface driverWriter) {
        this.config = config;
        this.driverWriter = driverWriter;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaBatchReader.class);
        Either<ConnectorError, Option<PartitionInfo>> either = writeSetupInterface.performInitialSetup(config);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
    }
}

