/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.v2;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.core.DSConfigSetupInterface;
import com.vertica.spark.datasource.core.TableMetaInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer$;
import com.vertica.spark.datasource.json.JsonBatchFactory;
import com.vertica.spark.datasource.json.VerticaJsonScan;
import com.vertica.spark.datasource.v2.NonPushFilter;
import com.vertica.spark.datasource.v2.PushFilter;
import com.vertica.spark.datasource.v2.UnknownColumnName;
import com.vertica.spark.datasource.v2.VerticaScan;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.pushdown.PushdownUtils$;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools;
import com.vertica.spark.util.version.SparkVersionTools;
import com.vertica.spark.util.version.SparkVersionTools$;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import java.io.Serializable;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001B\u000f\u001f\u0001%B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\")!\f\u0001C\u00017\"9!\r\u0001a\u0001\n#\u0019\u0007bB;\u0001\u0001\u0004%\tB\u001e\u0005\u0007{\u0002\u0001\u000b\u0015\u00023\t\u000fy\u0004\u0001\u0019!C\t\u007f\"I\u0011Q\u0002\u0001A\u0002\u0013E\u0011q\u0002\u0005\t\u0003'\u0001\u0001\u0015)\u0003\u0002\u0002!I\u0011Q\u0003\u0001A\u0002\u0013E\u0011q\u0003\u0005\n\u0003?\u0001\u0001\u0019!C\t\u0003CA\u0001\"!\n\u0001A\u0003&\u0011\u0011\u0004\u0005\n\u0003O\u0001\u0001\u0019!C\t\u0003SA\u0011\"a\u000e\u0001\u0001\u0004%\t\"!\u000f\t\u0011\u0005u\u0002\u0001)Q\u0005\u0003WA\u0011\"a\u0010\u0001\u0005\u0004%\t\"!\u0011\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u0007B\u0011\"!\u0016\u0001\u0005\u0004%\t\"a\u0016\t\u0011\u0005%\u0004\u0001)A\u0005\u00033B\u0011\"a\u001b\u0001\u0005\u0004%\t\"!\u001c\t\u0011\u0005m\u0004\u0001)A\u0005\u0003_Bq!! \u0001\t\u0003\ny\bC\u0004\u0002\b\u0002!I!!#\t\r\t\u0004A\u0011IAH\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!a*\u0001\t\u0003\nI\u000bC\u0004\u0002.\u0002!\t\"a,\t\r\u0005-\u0007\u0001\"\u0005\u0000\u0005I1VM\u001d;jG\u0006\u001c6-\u00198Ck&dG-\u001a:\u000b\u0005}\u0001\u0013A\u0001<3\u0015\t\t#%\u0001\u0006eCR\f7o\\;sG\u0016T!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013a\u0002<feRL7-\u0019\u0006\u0002O\u0005\u00191m\\7\u0004\u0001M)\u0001A\u000b\u001aB\tB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005Y\u0006twMC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#AB(cU\u0016\u001cG\u000f\u0005\u00024\u007f5\tAG\u0003\u00026m\u0005!!/Z1e\u0015\t9\u0004(A\u0005d_:tWm\u0019;pe*\u0011\u0011HO\u0001\u0004gFd'BA\u0012<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001#$aC*dC:\u0014U/\u001b7eKJ\u0004\"a\r\"\n\u0005\r#$aF*vaB|'\u000f^:QkNDGi\\<o\r&dG/\u001a:t!\t\u0019T)\u0003\u0002Gi\ty2+\u001e9q_J$8\u000fU;tQ\u0012{wO\u001c*fcVL'/\u001a3D_2,XN\\:\u0002\r\r|gNZ5h!\tI5*D\u0001K\u0015\t9%%\u0003\u0002M\u0015\nQ!+Z1e\u0007>tg-[4\u0002\u001fI,\u0017\rZ\"p]\u001aLwmU3ukB\u00142aT)X\r\u0011\u0001\u0006\u0001\u0001(\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007I+\u0006*D\u0001T\u0015\t!\u0006%\u0001\u0003d_J,\u0017B\u0001,T\u0005Y!5kQ8oM&<7+\u001a;va&sG/\u001a:gC\u000e,\u0007c\u0001*Y\u0011&\u0011\u0011l\u0015\u0002\u0013)\u0006\u0014G.Z'fi\u0006Le\u000e^3sM\u0006\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u00049z{\u0006CA/\u0001\u001b\u0005q\u0002\"B$\u0004\u0001\u0004A\u0005\"B'\u0004\u0001\u0004\u0001'cA1R/\u001a!\u0001\u000b\u0001\u0001a\u0003-\u0001Xo\u001d5GS2$XM]:\u0016\u0003\u0011\u00042!Z8s\u001d\t1GN\u0004\u0002hU6\t\u0001N\u0003\u0002jQ\u00051AH]8pizJ\u0011a[\u0001\u0006g\u000e\fG.Y\u0005\u0003[:\fq\u0001]1dW\u0006<WMC\u0001l\u0013\t\u0001\u0018O\u0001\u0003MSN$(BA7o!\ti6/\u0003\u0002u=\tQ\u0001+^:i\r&dG/\u001a:\u0002\u001fA,8\u000f\u001b$jYR,'o]0%KF$\"a^>\u0011\u0005aLX\"\u00018\n\u0005it'\u0001B+oSRDq\u0001`\u0003\u0002\u0002\u0003\u0007A-A\u0002yIE\nA\u0002];tQ\u001aKG\u000e^3sg\u0002\naB]3rk&\u0014X\rZ*dQ\u0016l\u0017-\u0006\u0002\u0002\u0002A!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\ba\nQ\u0001^=qKNLA!a\u0003\u0002\u0006\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002%I,\u0017/^5sK\u0012\u001c6\r[3nC~#S-\u001d\u000b\u0004o\u0006E\u0001\u0002\u0003?\t\u0003\u0003\u0005\r!!\u0001\u0002\u001fI,\u0017/^5sK\u0012\u001c6\r[3nC\u0002\nQ\"Y4h!V\u001c\b.\u001a3E_^tWCAA\r!\rA\u00181D\u0005\u0004\u0003;q'a\u0002\"p_2,\u0017M\\\u0001\u0012C\u001e<\u0007+^:iK\u0012$un\u001e8`I\u0015\fHcA<\u0002$!AApCA\u0001\u0002\u0004\tI\"\u0001\bbO\u001e\u0004Vo\u001d5fI\u0012{wO\u001c\u0011\u0002\u000f\u001d\u0014x.\u001e9CsV\u0011\u00111\u0006\t\u0006q\u00065\u0012\u0011G\u0005\u0004\u0003_q'!B!se\u0006L\b\u0003BA\u0002\u0003gIA!!\u000e\u0002\u0006\tY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003-9'o\\;q\u0005f|F%Z9\u0015\u0007]\fY\u0004\u0003\u0005}\u001d\u0005\u0005\t\u0019AA\u0016\u0003!9'o\\;q\u0005f\u0004\u0013A\u00027pO\u001e,'/\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001D:dC2\fGn\\4hS:<'bAA'M\u0005AA/\u001f9fg\u00064W-\u0003\u0003\u0002R\u0005\u001d#A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u000f\r$Hk\\8mgV\u0011\u0011\u0011\f\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0019\u00198\r[3nC*\u0019\u00111\r\u0012\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003O\niFA\fD_6\u0004H.\u001a=UsB,7oU2iK6\fGk\\8mg\u0006A1\r\u001e+p_2\u001c\b%A\tta\u0006\u00148NV3sg&|g\u000eV8pYN,\"!a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gRA!!\u001e\u0002b\u00059a/\u001a:tS>t\u0017\u0002BA=\u0003g\u0012\u0011c\u00159be.4VM]:j_:$vn\u001c7t\u0003I\u0019\b/\u0019:l-\u0016\u00148/[8o)>|Gn\u001d\u0011\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0005\u0005\u0005\u0005cA\u001a\u0002\u0004&\u0019\u0011Q\u0011\u001b\u0003\tM\u001b\u0017M\\\u0001\bkN,'j]8o)\u0011\tI\"a#\t\r\u00055u\u00031\u0001I\u0003\r\u0019gm\u001a\u000b\u0005\u0003#\u000by\nE\u0003y\u0003[\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI\nO\u0001\bg>,(oY3t\u0013\u0011\ti*a&\u0003\r\u0019KG\u000e^3s\u0011\u001d\t\t\u000b\u0007a\u0001\u0003#\u000bqAZ5mi\u0016\u00148/A\u0007qkNDW\r\u001a$jYR,'o\u001d\u000b\u0003\u0003#\u000bA\u0002\u001d:v]\u0016\u001cu\u000e\\;n]N$2a^AV\u0011\u0019q(\u00041\u0001\u0002\u0002\u0005Qq-\u001a;D_2$\u0016\u0010]3\u0015\t\u0005E\u0016q\u0017\t\u0005\u0003\u0007\t\u0019,\u0003\u0003\u00026\u0006\u0015!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005e6\u00041\u0001\u0002<\u000691m\u001c7OC6,\u0007\u0003BA_\u0003\u000btA!a0\u0002BB\u0011qM\\\u0005\u0004\u0003\u0007t\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0006%'AB*ue&twMC\u0002\u0002D:\f1\u0002^1cY\u0016\u001c6\r[3nC\u0002")
public class VerticaScanBuilder
implements SupportsPushDownFilters,
SupportsPushDownRequiredColumns {
    private final ReadConfig config;
    private final DSConfigSetupInterface<ReadConfig> readConfigSetup;
    private List<PushFilter> pushFilters;
    private StructType requiredSchema;
    private boolean aggPushedDown;
    private StructField[] groupBy;
    private final Logger logger;
    private final ComplexTypesSchemaTools ctTools;
    private final SparkVersionTools sparkVersionTools;

    public List<PushFilter> pushFilters() {
        return this.pushFilters;
    }

    public void pushFilters_$eq(List<PushFilter> x$1) {
        this.pushFilters = x$1;
    }

    public StructType requiredSchema() {
        return this.requiredSchema;
    }

    public void requiredSchema_$eq(StructType x$1) {
        this.requiredSchema = x$1;
    }

    public boolean aggPushedDown() {
        return this.aggPushedDown;
    }

    public void aggPushedDown_$eq(boolean x$1) {
        this.aggPushedDown = x$1;
    }

    public StructField[] groupBy() {
        return this.groupBy;
    }

    public void groupBy_$eq(StructField[] x$1) {
        this.groupBy = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public ComplexTypesSchemaTools ctTools() {
        return this.ctTools;
    }

    public SparkVersionTools sparkVersionTools() {
        return this.sparkVersionTools;
    }

    public Scan build() {
        ReadConfig cfg = this.config.copyConfig();
        cfg.setPushdownFilters(this.pushFilters());
        cfg.setRequiredSchema(this.requiredSchema());
        cfg.setPushdownAgg(this.aggPushedDown());
        cfg.setGroupBy(this.groupBy());
        if (this.useJson(cfg)) {
            return new VerticaJsonScan(cfg, this.readConfigSetup, new JsonBatchFactory(), HadoopFileStoreLayer$.MODULE$.make(this.config));
        }
        return new VerticaScan(cfg, this.readConfigSetup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean useJson(ReadConfig cfg) {
        ReadConfig readConfig = cfg;
        if (!(readConfig instanceof DistributedFilesystemReadConfig)) return false;
        DistributedFilesystemReadConfig distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig;
        Tuple2 tuple2 = new Tuple2(((TableMetaInterface)((Object)this.readConfigSetup)).getTableMetadata(distributedFilesystemReadConfig), (Object)distributedFilesystemReadConfig.getRequiredSchema());
        if (tuple2 != null) {
            Either either = (Either)tuple2._1();
            StructType requiredSchema = (StructType)tuple2._2();
            if (either instanceof Right) {
                Right right = (Right)either;
                VerticaReadMetadata metadata = (VerticaReadMetadata)right.value();
                StructType schema = requiredSchema.nonEmpty() ? requiredSchema : metadata.schema();
                if (distributedFilesystemReadConfig.useJson()) return true;
                Either<ConnectorError, BoxedUnit> either2 = VerticaVersionUtils$.MODULE$.checkComplexTypesParquetExport(schema, metadata.version());
                if (either2 instanceof Left) {
                    BoxedUnit boxedUnit;
                    Left left = (Left)either2;
                    ConnectorError err = (ConnectorError)left.value();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder(41).append(err.getFullContext()).append(". Export will be written to JSON instead.").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    if (!(either2 instanceof Right)) throw new MatchError(either2);
                    return false;
                }
                boolean bl = this.ctTools().filterComplexTypeColumns(schema).nonEmpty();
                if (!bl) return false;
                return true;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Either either = (Either)tuple2._1();
        if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
        Left left = (Left)either;
        ConnectorError err = (ConnectorError)left.value();
        throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
    }

    public Filter[] pushFilters(Filter[] filters) {
        Tuple2 initialLists = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
        Tuple2 tuple2 = (Tuple2)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filters), (Function1 & Serializable)filter -> PushdownUtils$.MODULE$.genFilter((Filter)filter), ClassTag$.MODULE$.apply(Either.class))), (Object)initialLists, (Function2 & Serializable)(acc, filter) -> {
            Tuple2 tuple2 = acc;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List nonPushFilters = (List)tuple2._1();
            List pushFilters = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nonPushFilters, (Object)pushFilters);
            List nonPushFilters2 = (List)tuple22._1();
            List pushFilters2 = (List)tuple22._2();
            Either either = filter;
            if (either instanceof Left) {
                Filter nonPushFilter;
                Left left = (Left)either;
                Filter filter2 = nonPushFilter = ((NonPushFilter)left.value()).filter();
                return new Tuple2((Object)nonPushFilters2.$colon$colon((Object)new NonPushFilter(filter2)), (Object)pushFilters2);
            }
            if (either instanceof Right) {
                PushFilter pushFilter;
                Right right = (Right)either;
                PushFilter pushFilter2 = pushFilter = (PushFilter)right.value();
                return new Tuple2((Object)nonPushFilters2, (Object)pushFilters2.$colon$colon((Object)pushFilter2));
            }
            throw new MatchError((Object)either);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List nonPushFilters = (List)tuple2._1();
        List pushFilters = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nonPushFilters, (Object)pushFilters);
        List nonPushFilters2 = (List)tuple22._1();
        List pushFilters2 = (List)tuple22._2();
        this.pushFilters_$eq((List<PushFilter>)pushFilters2);
        return (Filter[])nonPushFilters2.map((Function1 & Serializable)x$3 -> ((NonPushFilter)x$3).filter()).toArray(ClassTag$.MODULE$.apply(Filter.class));
    }

    public Filter[] pushedFilters() {
        return (Filter[])this.pushFilters().map((Function1 & Serializable)x$4 -> x$4.filter()).toArray(ClassTag$.MODULE$.apply(Filter.class));
    }

    public void pruneColumns(StructType requiredSchema) {
        this.requiredSchema_$eq(requiredSchema);
        this.aggPushedDown_$eq(false);
        this.groupBy_$eq((StructField[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public DataType getColType(String colName) {
        Option option = this.tableSchema().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VerticaScanBuilder.$anonfun$getColType$1(colName, x$5)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField col = (StructField)some.value();
            return col.dataType();
        }
        if (None$.MODULE$.equals(option)) {
            throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new UnknownColumnName(colName));
        }
        throw new MatchError((Object)option);
    }

    public StructType tableSchema() {
        Either<ConnectorError, VerticaReadMetadata> either = ((TableMetaInterface)((Object)this.readConfigSetup)).getTableMetadata(this.config);
        if (either instanceof Right) {
            Right right = (Right)either;
            VerticaReadMetadata metadata = (VerticaReadMetadata)right.value();
            return metadata.schema();
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err.context("Scan builder failed to get table schema"));
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$getColType$1(String colName$1, StructField x$5) {
        return x$5.name().equalsIgnoreCase(colName$1);
    }

    public VerticaScanBuilder(ReadConfig config, DSConfigSetupInterface<ReadConfig> readConfigSetup) {
        this.config = config;
        this.readConfigSetup = readConfigSetup;
        this.pushFilters = Nil$.MODULE$;
        this.requiredSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aggPushedDown = false;
        this.groupBy = (StructField[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StructField.class));
        this.logger = LogProvider$.MODULE$.getLogger(VerticaScanBuilder.class);
        this.ctTools = new ComplexTypesSchemaTools();
        this.sparkVersionTools = new SparkVersionTools(SparkVersionTools$.MODULE$.$lessinit$greater$default$1());
    }
}

