/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.v2;

import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.datasource.core.DSConfigSetupInterface;
import com.vertica.spark.datasource.v2.AggregateNotSupported;
import com.vertica.spark.datasource.v2.VerticaScanBuilder;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ConnectorException;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.version.SparkVersionTools$;
import com.vertica.spark.util.version.Version;
import java.io.Serializable;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.connector.expressions.aggregate.Sum;
import org.apache.spark.sql.connector.read.SupportsPushDownAggregates;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y3AAB\u0004\u0001%!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015\u0001\u0005\u0001\"\u0011B\u0011\u0015\u0011\u0006\u0001\"\u0003T\u0005y1VM\u001d;jG\u0006\u001c6-\u00198Ck&dG-\u001a:XSRD\u0007+^:iI><hN\u0003\u0002\t\u0013\u0005\u0011aO\r\u0006\u0003\u0015-\t!\u0002Z1uCN|WO]2f\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00059a/\u001a:uS\u000e\f'\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019r\u0003\u0005\u0002\u0015+5\tq!\u0003\u0002\u0017\u000f\t\u0011b+\u001a:uS\u000e\f7kY1o\u0005VLG\u000eZ3s!\tAB%D\u0001\u001a\u0015\tQ2$\u0001\u0003sK\u0006$'B\u0001\u000f\u001e\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u00051\u0001#BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001eL!!J\r\u00035M+\b\u000f]8siN\u0004Vo\u001d5E_^t\u0017iZ4sK\u001e\fG/Z:\u0002\r\r|gNZ5h!\tA#&D\u0001*\u0015\t13\"\u0003\u0002,S\tQ!+Z1e\u0007>tg-[4\u0002\u001fI,\u0017\rZ\"p]\u001aLwmU3ukB\u00142A\f\u00197\r\u0011y\u0003\u0001A\u0017\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007E\"t%D\u00013\u0015\t\u0019\u0014\"\u0001\u0003d_J,\u0017BA\u001b3\u0005Y!5kQ8oM&<7+\u001a;va&sG/\u001a:gC\u000e,\u0007cA\u00198O%\u0011\u0001H\r\u0002\u0013)\u0006\u0014G.Z'fi\u0006Le\u000e^3sM\u0006\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0004wqj\u0004C\u0001\u000b\u0001\u0011\u001513\u00011\u0001(\u0011\u0015a3\u00011\u0001?%\ry\u0004G\u000e\u0004\u0005_\u0001\u0001a(A\bqkND\u0017iZ4sK\u001e\fG/[8o)\t\u0011\u0005\n\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0004C_>dW-\u00198\t\u000b%#\u0001\u0019\u0001&\u0002\u0017\u0005<wM]3hCRLwN\u001c\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005=[\u0012aC3yaJ,7o]5p]NL!!\u0015'\u0003\u0017\u0005;wM]3hCRLwN\\\u0001\u0012O\u0016$xI]8va\nK8i\u001c7v[:\u001cHC\u0001+^!\r\u0019UkV\u0005\u0003-\u0012\u0013Q!\u0011:sCf\u0004\"\u0001W.\u000e\u0003eS!AW\u000f\u0002\u000bQL\b/Z:\n\u0005qK&aC*ueV\u001cGOR5fY\u0012DQ!S\u0003A\u0002)\u0003")
public class VerticaScanBuilderWithPushdown
extends VerticaScanBuilder
implements SupportsPushDownAggregates {
    public boolean supportCompletePushDown(Aggregation x$1) {
        return super.supportCompletePushDown(x$1);
    }

    public boolean pushAggregation(Aggregation aggregation) {
        try {
            StructField[] aggregatesStructFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.aggregateExpressions()), (Function1 & Serializable)x0$1 -> {
                AggregateFunc aggregateFunc = x0$1;
                if (aggregateFunc instanceof CountStar) {
                    return new StructField("COUNT(*)", (DataType)LongType$.MODULE$, false, Metadata$.MODULE$.empty());
                }
                if (aggregateFunc instanceof Count) {
                    Count count = (Count)aggregateFunc;
                    return new StructField(count.describe(), (DataType)LongType$.MODULE$, false, Metadata$.MODULE$.empty());
                }
                if (aggregateFunc instanceof Sum) {
                    Sum sum = (Sum)aggregateFunc;
                    return new StructField(sum.describe(), this.getColType(sum.column().describe()), false, Metadata$.MODULE$.empty());
                }
                if (aggregateFunc instanceof Min) {
                    Min min = (Min)aggregateFunc;
                    return new StructField(min.describe(), this.getColType(min.column().describe()), false, Metadata$.MODULE$.empty());
                }
                if (aggregateFunc instanceof Max) {
                    Max max = (Max)aggregateFunc;
                    return new StructField(max.describe(), this.getColType(max.column().describe()), false, Metadata$.MODULE$.empty());
                }
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new AggregateNotSupported(aggregateFunc.describe()));
            }, ClassTag$.MODULE$.apply(StructField.class));
            StructField[] groupByColumnsStructFields = this.getGroupByColumns(aggregation);
            this.requiredSchema_$eq(new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])groupByColumnsStructFields), (Object)aggregatesStructFields, ClassTag$.MODULE$.apply(StructField.class))));
            this.groupBy_$eq(groupByColumnsStructFields);
            this.aggPushedDown_$eq(true);
        }
        catch (ConnectorException e) {
            ConnectorError connectorError = e.error();
            if (connectorError instanceof AggregateNotSupported) {
                this.requiredSchema_$eq(StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                this.groupBy_$eq((StructField[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StructField.class)));
                this.aggPushedDown_$eq(false);
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return this.aggPushedDown();
    }

    private StructField[] getGroupByColumns(Aggregation aggregation) {
        Version sparkVersion = (Version)this.sparkVersionTools().getVersion().getOrElse((Function0 & Serializable)() -> SparkVersionTools$.MODULE$.SPARK_3_3_0());
        return (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.sparkVersionTools().getCompatibleGroupByExpressions(sparkVersion, aggregation)), (Function1 & Serializable)expr -> new StructField(expr.describe(), this.getColType(expr.describe()), false, Metadata$.MODULE$.empty()), ClassTag$.MODULE$.apply(StructField.class));
    }

    public VerticaScanBuilderWithPushdown(ReadConfig config, DSConfigSetupInterface<ReadConfig> readConfigSetup) {
        super(config, readConfigSetup);
    }
}

