/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.cleanup;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.util.cleanup.CleanupUtilsInterface;
import com.vertica.spark.util.cleanup.FileCleanupInfo;
import com.vertica.spark.util.error.CleanupError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ParentDirMissingError;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\u0006\f\u0001YAQ!\t\u0001\u0005\u0002\tBq\u0001\n\u0001C\u0002\u0013%Q\u0005\u0003\u0004/\u0001\u0001\u0006IA\n\u0005\u0006_\u0001!I\u0001\r\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0006]\u0002!Ia\u001c\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0003\u0001\u0005B\u0005e!\u0001D\"mK\u0006tW\u000f]+uS2\u001c(B\u0001\u0007\u000e\u0003\u001d\u0019G.Z1okBT!AD\b\u0002\tU$\u0018\u000e\u001c\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\u000fY,'\u000f^5dC*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005Y\u0011B\u0001\u0011\f\u0005U\u0019E.Z1okB,F/\u001b7t\u0013:$XM\u001d4bG\u0016\fa\u0001P5oSRtD#A\u0012\u0011\u0005y\u0001\u0011A\u00027pO\u001e,'/F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002,'\u0005AA/\u001f9fg\u00064W-\u0003\u0002.Q\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\bsK\u000e|'\u000f\u001a$jY\u0016t\u0015-\\3\u0015\u0007EJT\t\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\rM#(/\u001b8h\u0011\u0015QD\u00011\u0001<\u0003!1\u0017\u000e\\3oC6,\u0007C\u0001\u001fD\u001d\ti\u0014\t\u0005\u0002?35\tqH\u0003\u0002A+\u00051AH]8pizJ!AQ\r\u0002\rA\u0013X\rZ3g\u0013\tADI\u0003\u0002C3!)a\t\u0002a\u0001\u000f\u0006\u0019\u0011\u000e\u001a=\u0011\u0005aA\u0015BA%\u001a\u0005\u0011auN\\4\u0002\u0015\rdW-\u00198va\u0006cG\u000eF\u0002ME2\u00042!\u0014/`\u001d\tq\u0015L\u0004\u0002P/:\u0011\u0001K\u0016\b\u0003#Vs!A\u0015+\u000f\u0005y\u001a\u0016\"\u0001\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002Y\u001b\u0005)QM\u001d:pe&\u0011!lW\u0001\u000e\u000bJ\u0014xN\u001d%b]\u0012d\u0017N\\4\u000b\u0005ak\u0011BA/_\u0005=\u0019uN\u001c8fGR|'OU3tk2$(B\u0001.\\!\tA\u0002-\u0003\u0002b3\t!QK\\5u\u0011\u0015\u0019W\u00011\u0001e\u000391\u0017\u000e\\3Ti>\u0014X\rT1zKJ\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\u0005\u0019\u001c(BA5\u0010\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0003W\u001a\u0014qCR5mKN#xN]3MCf,'/\u00138uKJ4\u0017mY3\t\u000b5,\u0001\u0019A\u001e\u0002\tA\fG\u000f[\u0001\u0018G2,\u0017M\\;q!\u0006\u0014XM\u001c;ESJLe-R7qif$2\u0001]?\u007f!\u0011\th/_0\u000f\u0005I$hB\u0001 t\u0013\u0005Q\u0012BA;\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001e=\u0003\r\u0015KG\u000f[3s\u0015\t)\u0018\u0004\u0005\u0002{w6\t1,\u0003\u0002}7\nq1i\u001c8oK\u000e$xN]#se>\u0014\b\"B2\u0007\u0001\u0004!\u0007\"B7\u0007\u0001\u0004Y\u0014aE4fiB\u000b'/\u001a8u\u0011\u0006$wn\u001c9QCRDG\u0003BA\u0002\u0003\u000b\u00012!\u0014/<\u0011\u0015iw\u00011\u0001<\u00039\u0001XM\u001d4pe6\u001cE.Z1okB$R\u0001TA\u0006\u0003\u001bAQa\u0019\u0005A\u0002\u0011Dq!a\u0004\t\u0001\u0004\t\t\"A\bgS2,7\t\\3b]V\u0004\u0018J\u001c4p!\rq\u00121C\u0005\u0004\u0003+Y!a\u0004$jY\u0016\u001cE.Z1okBLeNZ8\u0002\u001f\rDWmY6B]\u0012\u001cE.Z1okB$R\u0001TA\u000e\u0003;AQaY\u0005A\u0002\u0011Dq!a\u0004\n\u0001\u0004\t\t\u0002")
public class CleanupUtils
implements CleanupUtilsInterface {
    private final Logger logger = LogProvider$.MODULE$.getLogger(CleanupUtils.class);

    private Logger logger() {
        return this.logger;
    }

    private String recordFileName(String filename, long idx) {
        return new StringBuilder(8).append(filename).append(".cleanup").append(idx).toString();
    }

    @Override
    public Either<ConnectorError, BoxedUnit> cleanupAll(FileStoreLayerInterface fileStoreLayer, String path) {
        Path p = new Path(String.valueOf(path));
        Path parent = p.getParent();
        if (parent != null) {
            fileStoreLayer.removeDir(parent.toString());
            return new Right((Object)BoxedUnit.UNIT);
        }
        return new Left((Object)new CleanupError(path));
    }

    private Either<ConnectorError, BoxedUnit> cleanupParentDirIfEmpty(FileStoreLayerInterface fileStoreLayer, String path) {
        return this.getParentHadoopPath(path).flatMap((Function1 & Serializable)parentPath -> fileStoreLayer.getFileList((String)parentPath).flatMap((Function1 & Serializable)allFiles -> this.getParentHadoopPath((String)parentPath).flatMap((Function1 & Serializable)parentPath2 -> (allFiles.isEmpty() ? fileStoreLayer.removeDir((String)parentPath2) : new Right((Object)BoxedUnit.UNIT)).map((Function1 & Serializable)x$1 -> {
            boxedUnit = x$1;
            return BoxedUnit.UNIT;
        }))));
    }

    private Either<ConnectorError, String> getParentHadoopPath(String path) {
        Path p = new Path(String.valueOf(path));
        Path parent = p.getParent();
        if (parent != null) {
            return new Right((Object)parent.toString());
        }
        return new Left((Object)new ParentDirMissingError(path));
    }

    private Either<ConnectorError, BoxedUnit> performCleanup(FileStoreLayerInterface fileStoreLayer, FileCleanupInfo fileCleanupInfo) {
        String filename = fileCleanupInfo.filename();
        return ((Either)implicits$.MODULE$.toTraverseOps((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), fileCleanupInfo.fileRangeCount()).map((Function1 & Serializable)idx -> CleanupUtils.$anonfun$performCleanup$1(this, filename, fileStoreLayer, BoxesRunTime.unboxToInt((Object)idx))).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(18).append("Removing parquet: ").append(filename).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$3 = boxedUnit;
            return new Tuple2(x$2, (Object)x$3);
        }).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                return fileStoreLayer.removeFile(filename).flatMap((Function1 & Serializable)x$5 -> {
                    BoxedUnit boxedUnit = x$5;
                    return this.cleanupParentDirIfEmpty(fileStoreLayer, filename).map((Function1 & Serializable)x$4 -> {
                        boxedUnit = x$4;
                        return BoxedUnit.UNIT;
                    });
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> checkAndCleanup(FileStoreLayerInterface fileStoreLayer, FileCleanupInfo fileCleanupInfo) {
        BoxedUnit boxedUnit;
        String filename = fileCleanupInfo.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(33).append("Doing partition cleanup of file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fileStoreLayer.createFile(this.recordFileName(filename, fileCleanupInfo.fileIdx())).map((Function1 & Serializable)x$7 -> {
            BoxedUnit boxedUnit;
            BoxedUnit x$9;
            BoxedUnit boxedUnit2;
            BoxedUnit x$8;
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("File: ").append(filename).append(", Checking file existance").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = x$8 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(18).append("File: ").append(filename).append(", File idx: ").append(fileCleanupInfo.fileIdx()).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = x$9 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(26).append("File: ").append(filename).append(", File range count: ").append(fileCleanupInfo.fileRangeCount()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$10 = boxedUnit;
            return new Tuple4(x$7, (Object)x$8, (Object)x$9, (Object)x$10);
        }).flatMap((Function1 & Serializable)x$15 -> {
            Tuple4 tuple4 = x$15;
            if (tuple4 != null) {
                return ((Either)implicits$.MODULE$.toTraverseOps((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), fileCleanupInfo.fileRangeCount()).map((Function1 & Serializable)idx -> CleanupUtils.$anonfun$checkAndCleanup$3(this, filename, fileStoreLayer, BoxesRunTime.unboxToInt((Object)idx))).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).flatMap((Function1 & Serializable)filesExist -> new Right((Object)BoxesRunTime.boxToBoolean((boolean)filesExist.forall((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)x))))).map((Function1 & Serializable)allExist -> CleanupUtils.$anonfun$checkAndCleanup$6(this, filename, filesExist, BoxesRunTime.unboxToBoolean((Object)allExist))).flatMap((Function1 & Serializable)x$14 -> {
                    Tuple3 tuple3 = x$14;
                    if (tuple3 != null) {
                        Either<ConnectorError, BoxedUnit> either;
                        boolean allExist = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
                        if (allExist) {
                            BoxedUnit boxedUnit;
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug(new StringBuilder(26).append("File: ").append(filename).append(", Performing cleanup").toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            either = this.performCleanup(fileStoreLayer, fileCleanupInfo);
                        } else {
                            either = new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT);
                        }
                        return either.map((Function1 & Serializable)x$13 -> {
                            boxedUnit = x$13;
                            return BoxedUnit.UNIT;
                        });
                    }
                    throw new MatchError((Object)tuple3);
                }));
            }
            throw new MatchError((Object)tuple4);
        });
    }

    public static final /* synthetic */ Either $anonfun$performCleanup$1(CleanupUtils $this, String filename$1, FileStoreLayerInterface fileStoreLayer$2, int idx) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(10).append("Removing: ").append($this.recordFileName(filename$1, idx)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fileStoreLayer$2.removeFile($this.recordFileName(filename$1, idx));
    }

    public static final /* synthetic */ Either $anonfun$checkAndCleanup$3(CleanupUtils $this, String filename$2, FileStoreLayerInterface fileStoreLayer$3, int idx) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(20).append("Checking existence: ").append($this.recordFileName(filename$2, idx)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fileStoreLayer$3.fileExists($this.recordFileName(filename$2, idx));
    }

    public static final /* synthetic */ Tuple3 $anonfun$checkAndCleanup$6(CleanupUtils $this, String filename$2, List filesExist$1, boolean allExist) {
        BoxedUnit boxedUnit;
        BoxedUnit x$11;
        BoxedUnit boxedUnit2;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(20).append("File: ").append(filename$2).append(", filesExist: ").append(filesExist$1.toString()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = x$11 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(19).append("File: ").append(filename$2).append(", All exist: ").append(allExist).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$12 = boxedUnit;
        return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)allExist), (Object)x$11, (Object)x$12);
    }
}

