/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.cleanup;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer$;
import com.vertica.spark.datasource.partitions.mixin.Cleanup;
import com.vertica.spark.datasource.partitions.mixin.Identifiable;
import com.vertica.spark.util.cleanup.CleanupUtilsInterface;
import com.vertica.spark.util.cleanup.DistributedFilesCleaner$;
import com.vertica.spark.util.cleanup.FileCleanupInfo;
import com.vertica.spark.util.error.ConnectorError;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005S!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0011!1\u0004A!b\u0001\n\u00039\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u000b\u0011\u0003A\u0011A#\t\u000f)\u0003!\u0019!C\u0005\u0017\"1A\u000b\u0001Q\u0001\n1Cq!\u0016\u0001C\u0002\u0013%a\u000b\u0003\u0004X\u0001\u0001\u0006Ia\u000f\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019i\u0006\u0001)A\u00055\")a\f\u0001C\u0001?\")Q\u000e\u0001C\u0001]\u001e9\u00110FA\u0001\u0012\u0003Qha\u0002\u000b\u0016\u0003\u0003E\ta\u001f\u0005\u0006\tF!\t\u0001 \u0005\b{F\t\n\u0011\"\u0001\u007f\u0005]!\u0015n\u001d;sS\n,H/\u001a3GS2,7o\u00117fC:,'O\u0003\u0002\u0017/\u000591\r\\3b]V\u0004(B\u0001\r\u001a\u0003\u0011)H/\u001b7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u001d1XM\u001d;jG\u0006T\u0011AH\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017AB2p]\u001aLw-F\u0001*!\tQC&D\u0001,\u0015\t9\u0013$\u0003\u0002.W\tyB)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l'+Z1e\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005a1\r\\3b]V\u0004X\u000b^5mgV\t\u0011\u0007\u0005\u00023g5\tQ#\u0003\u00025+\t)2\t\\3b]V\u0004X\u000b^5mg&sG/\u001a:gC\u000e,\u0017!D2mK\u0006tW\u000f]+uS2\u001c\b%A\bpaRLwN\\1m\rNc\u0015-_3s+\u0005A\u0004c\u0001\u0012:w%\u0011!h\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014A\u00014t\u0015\t\u0001\u0015$\u0001\u0006eCR\f7o\\;sG\u0016L!AQ\u001f\u0003/\u0019KG.Z*u_J,G*Y=fe&sG/\u001a:gC\u000e,\u0017\u0001E8qi&|g.\u00197G'2\u000b\u00170\u001a:!\u0003\u0019a\u0014N\\5u}Q!ai\u0012%J!\t\u0011\u0004\u0001C\u0003(\u000f\u0001\u0007\u0011\u0006C\u00030\u000f\u0001\u0007\u0011\u0007C\u00047\u000fA\u0005\t\u0019\u0001\u001d\u0002\r1|wmZ3s+\u0005a\u0005CA'S\u001b\u0005q%BA(Q\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\tV$\u0001\u0005usB,7/\u00194f\u0013\t\u0019fJ\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u000391\u0017\u000e\\3Ti>\u0014X\rT1zKJ,\u0012aO\u0001\u0010M&dWm\u0015;pe\u0016d\u0015-_3sA\u0005ya-\u001b7f'R|'/Z\"p]\u001aLw-F\u0001[!\tQ3,\u0003\u0002]W\tya)\u001b7f'R|'/Z\"p]\u001aLw-\u0001\tgS2,7\u000b^8sK\u000e{gNZ5hA\u0005a1\r\\3b]V\u0004h)\u001b7fgR\u0011\u0001m\u0019\t\u0003E\u0005L!AY\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006I:\u0001\r!Z\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u000b5L\u00070\u001b8\u000b\u0005)|\u0014A\u00039beRLG/[8og&\u0011An\u001a\u0002\b\u00072,\u0017M\\;q\u000399W\r^\"mK\u0006tW\u000f]%oM>$2a\\:u!\r\u0011\u0013\b\u001d\t\u0003eEL!A]\u000b\u0003\u001f\u0019KG.Z\"mK\u0006tW\u000f]%oM>DQ\u0001Z\bA\u0002\u0015DQ!^\bA\u0002Y\fa\u0002]1si&$\u0018n\u001c8J]\u0012,\u0007\u0010\u0005\u0002#o&\u0011\u0001p\t\u0002\u0004\u0013:$\u0018a\u0006#jgR\u0014\u0018NY;uK\u00124\u0015\u000e\\3t\u00072,\u0017M\\3s!\t\u0011\u0014c\u0005\u0002\u0012CQ\t!0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0002\u007f*\u001a\u0001(!\u0001,\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0004$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\t9AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DistributedFilesCleaner {
    private final DistributedFilesystemReadConfig config;
    private final CleanupUtilsInterface cleanupUtils;
    private final Option<FileStoreLayerInterface> optionalFSLayer;
    private final Logger logger;
    private final FileStoreLayerInterface fileStoreLayer;
    private final FileStoreConfig fileStoreConfig;

    public static Option<FileStoreLayerInterface> $lessinit$greater$default$3() {
        return DistributedFilesCleaner$.MODULE$.$lessinit$greater$default$3();
    }

    public DistributedFilesystemReadConfig config() {
        return this.config;
    }

    public CleanupUtilsInterface cleanupUtils() {
        return this.cleanupUtils;
    }

    public Option<FileStoreLayerInterface> optionalFSLayer() {
        return this.optionalFSLayer;
    }

    private Logger logger() {
        return this.logger;
    }

    private FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    private FileStoreConfig fileStoreConfig() {
        return this.fileStoreConfig;
    }

    public void cleanupFiles(Cleanup partition) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Removing files before closing read pipe.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        partition.getPortions().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)fileIndex -> {
            if (!this.fileStoreConfig().preventCleanup()) {
                Option<FileCleanupInfo> option = this.getCleanupInfo(partition, fileIndex);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FileCleanupInfo cleanupInfo = (FileCleanupInfo)some.value();
                    Either<ConnectorError, BoxedUnit> either = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        ConnectorError err = (ConnectorError)left.value();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(69).append("Ran into error when calling cleaning up. Treating as non-fatal. Err: ").append(err.getFullContext()).toString());
                        }
                    } else if (either instanceof Right) {
                    } else {
                        throw new MatchError(either);
                    }
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("No cleanup info found.");
                        return;
                    }
                    return;
                }
                throw new MatchError(option);
            }
        });
    }

    public Option<FileCleanupInfo> getCleanupInfo(Cleanup partition, int partitionIndex) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(44).append("Getting cleanup info for partition with idx ").append(partitionIndex).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (partitionIndex >= partition.getPortions().size()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(40).append("Invalid fileIdx ").append(partitionIndex).append(", can't perform cleanup.").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        }
        Identifiable fileRange = (Identifiable)partition.getPortions().apply(partitionIndex);
        return new Some((Object)new FileCleanupInfo(fileRange.filename(), fileRange.index(), BoxesRunTime.unboxToInt((Object)partition.getPartitioningRecord().apply((Object)fileRange.filename()))));
    }

    public DistributedFilesCleaner(DistributedFilesystemReadConfig config, CleanupUtilsInterface cleanupUtils, Option<FileStoreLayerInterface> optionalFSLayer) {
        this.config = config;
        this.cleanupUtils = cleanupUtils;
        this.optionalFSLayer = optionalFSLayer;
        this.logger = LogProvider$.MODULE$.getLogger(this);
        this.fileStoreLayer = (FileStoreLayerInterface)optionalFSLayer.getOrElse((Function0 & Serializable)() -> HadoopFileStoreLayer$.MODULE$.make(this.config()));
        this.fileStoreConfig = config.fileStoreConfig();
    }
}

