/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.listeners;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer;
import com.vertica.spark.util.error.ConnectorError;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u000593A\u0001C\u0005\u0001)!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\rU\u0002\u0001\u0015!\u0003.\u0011\u001d1\u0004A1A\u0005\n]Ba\u0001\u0011\u0001!\u0002\u0013A\u0004\"B!\u0001\t\u0003\u0012%!G!qa2L7-\u0019;j_:\u0004\u0016M]9vKR\u001cE.Z1oKJT!AC\u0006\u0002\u00131L7\u000f^3oKJ\u001c(B\u0001\u0007\u000e\u0003\u0011)H/\u001b7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u001d1XM\u001d;jG\u0006T\u0011AE\u0001\u0004G>l7\u0001A\n\u0003\u0001U\u0001\"A\u0006\u0010\u000e\u0003]Q!\u0001G\r\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\b\u001b\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\n\u0005}9\"!D*qCJ\\G*[:uK:,'/\u0001\u0004d_:4\u0017n\u001a\t\u0003E\u0011j\u0011a\t\u0006\u0003A5I!!J\u0012\u0003?\u0011K7\u000f\u001e:jEV$X\r\u001a$jY\u0016\u001c\u0018p\u001d;f[J+\u0017\rZ\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0003Q)\u0002\"!\u000b\u0001\u000e\u0003%AQ\u0001\t\u0002A\u0002\u0005\na\u0001\\8hO\u0016\u0014X#A\u0017\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001a\u0012\u0003!!\u0018\u0010]3tC\u001a,\u0017B\u0001\u001b0\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u00044jY\u0016\u001cFo\u001c:f\u0019\u0006LXM]\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0003MNT!!P\u0007\u0002\u0015\u0011\fG/Y:pkJ\u001cW-\u0003\u0002@u\t!\u0002*\u00193p_B4\u0015\u000e\\3Ti>\u0014X\rT1zKJ\fqBZ5mKN#xN]3MCf,'\u000fI\u0001\u0011_:\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012$\"aQ%\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u001e\u0001\raS\u0001\u000fCB\u0004H.[2bi&|g.\u00128e!\t1B*\u0003\u0002N/\tY2\u000b]1sW2K7\u000f^3oKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012\u0004")
public class ApplicationParquetCleaner
extends SparkListener {
    private final DistributedFilesystemReadConfig config;
    private final Logger logger;
    private final HadoopFileStoreLayer fileStoreLayer;

    private Logger logger() {
        return this.logger;
    }

    private HadoopFileStoreLayer fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        String hdfsPath = this.config.fileStoreConfig().address();
        if (!this.config.fileStoreConfig().preventCleanup()) {
            Either<ConnectorError, BoxedUnit> either = this.fileStoreLayer().removeDir(hdfsPath);
            if (either instanceof Right) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(8).append("Removed ").append(hdfsPath).toString());
                    return;
                }
                return;
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError error = (ConnectorError)left.value();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error removing {}. {}", new Object[]{hdfsPath, error.toString()});
                    return;
                }
                return;
            }
            throw new MatchError(either);
        }
    }

    public ApplicationParquetCleaner(DistributedFilesystemReadConfig config) {
        None$ none$;
        this.config = config;
        this.logger = LogProvider$.MODULE$.getLogger(ApplicationParquetCleaner.class);
        FileStoreConfig fileStoreConfig = config.fileStoreConfig();
        Option<VerticaReadMetadata> option = config.metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaReadMetadata metadata = (VerticaReadMetadata)some.value();
            none$ = config.getRequiredSchema().nonEmpty() ? new Some((Object)config.getRequiredSchema()) : new Some((Object)metadata.schema());
        } else {
            none$ = None$.MODULE$;
        }
        this.fileStoreLayer = new HadoopFileStoreLayer(fileStoreConfig, (Option<StructType>)none$);
    }
}

