/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.pushdown;

import com.vertica.spark.datasource.v2.NonPushFilter;
import com.vertica.spark.datasource.v2.PushFilter;
import java.io.Serializable;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PushdownUtils$ {
    public static final PushdownUtils$ MODULE$ = new PushdownUtils$();

    private String wrapText(Object value) {
        Object object = value;
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Double.isInfinite(number.doubleValue())) {
                return new StringBuilder(2).append("'").append(value.toString()).append("'").toString();
            }
            return value.toString();
        }
        return new StringBuilder(2).append("'").append(value.toString()).append("'").toString();
    }

    public Either<NonPushFilter, PushFilter> genFilter(Filter filter) {
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attribute = equalTo.attribute();
            Object value = equalTo.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(7).append("(\"").append(attribute).append("\"").append(" = ").append(this.wrapText(value)).append(")").toString()));
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(7).append("(\"").append(attribute).append("\"").append(" > ").append(this.wrapText(value)).append(")").toString()));
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(8).append("(\"").append(attribute).append("\"").append(" >= ").append(this.wrapText(value)).append(")").toString()));
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(7).append("(\"").append(attribute).append("\"").append(" < ").append(this.wrapText(value)).append(")").toString()));
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(8).append("(\"").append(attribute).append("\"").append(" <= ").append(this.wrapText(value)).append(")").toString()));
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] value = in.values();
            return new Right((Object)new PushFilter(filter, new StringBuilder(10).append("(\"").append(attribute).append("\"").append(" in ").append("(").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)value), (Function1 & Serializable)x -> MODULE$.wrapText(x), ClassTag$.MODULE$.apply(String.class))).mkString(", ")).append(")").append(")").toString()));
        }
        if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            return new Right((Object)new PushFilter(filter, new StringBuilder(12).append("(\"").append(attribute).append("\"").append(" is NULL").append(")").toString()));
        }
        if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            return new Right((Object)new PushFilter(filter, new StringBuilder(16).append("(\"").append(attribute).append("\"").append(" is NOT NULL").append(")").toString()));
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            return this.genFilter(left).flatMap((Function1 & Serializable)pushFilterLeft -> MODULE$.genFilter(right).map((Function1 & Serializable)pushFilterRight -> new PushFilter(filter, new StringBuilder(7).append("(").append(pushFilterLeft.filterString()).append(" AND ").append(pushFilterRight.filterString()).append(")").toString()))).left().map((Function1 & Serializable)x$1 -> new NonPushFilter(filter));
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            return this.genFilter(left).flatMap((Function1 & Serializable)pushFilterLeft -> MODULE$.genFilter(right).map((Function1 & Serializable)pushFilterRight -> new PushFilter(filter, new StringBuilder(6).append("(").append(pushFilterLeft.filterString()).append(" OR ").append(pushFilterRight.filterString()).append(")").toString()))).left().map((Function1 & Serializable)x$2 -> new NonPushFilter(filter));
        }
        if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            Either<NonPushFilter, PushFilter> either = this.genFilter(child);
            if (either instanceof Left) {
                return new Left((Object)new NonPushFilter(filter));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                PushFilter pushFilter = (PushFilter)right.value();
                return new Right((Object)new PushFilter(filter, new StringBuilder(7).append("( NOT ").append(pushFilter.filterString()).append(")").toString()));
            }
            throw new MatchError(either);
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attribute = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(10).append("(\"").append(attribute).append("\"").append(" like ").append(this.wrapText(new StringBuilder(1).append(value).append("%").toString())).append(")").toString()));
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attribute = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(10).append("(\"").append(attribute).append("\"").append(" like ").append(this.wrapText(new StringBuilder(1).append("%").append(value).toString())).append(")").toString()));
        }
        if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attribute = stringContains.attribute();
            String value = stringContains.value();
            return new Right((Object)new PushFilter(filter, new StringBuilder(10).append("(\"").append(attribute).append("\"").append(" like ").append(this.wrapText(new StringBuilder(2).append("%").append(value).append("%").toString())).append(")").toString()));
        }
        return new Left((Object)new NonPushFilter(filter));
    }

    private PushdownUtils$() {
    }
}

