/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.table;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.EscapeUtils$;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerStringParam;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateTableError;
import com.vertica.spark.util.error.JdbcError;
import com.vertica.spark.util.error.JobStatusCreateError;
import com.vertica.spark.util.error.JobStatusUpdateError;
import com.vertica.spark.util.error.TableCheckError;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.table.TableUtilsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\n\u0015\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)!\b\u0001C\u0001w!9q\b\u0001b\u0001\n\u0013\u0001\u0005BB%\u0001A\u0003%\u0011\tC\u0003K\u0001\u0011%1\nC\u0005\u0002\u001a\u0001\t\n\u0011\"\u0003\u0002\u001c!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\tI\u000b\u0001C!\u0003W\u0013!\u0002V1cY\u0016,F/\u001b7t\u0015\t)b#A\u0003uC\ndWM\u0003\u0002\u00181\u0005!Q\u000f^5m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00059a/\u001a:uS\u000e\f'\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003O!j\u0011\u0001F\u0005\u0003SQ\u00111\u0003V1cY\u0016,F/\u001b7t\u0013:$XM\u001d4bG\u0016\f1b]2iK6\fGk\\8mgB\u0011AfL\u0007\u0002[)\u0011aFF\u0001\u0007g\u000eDW-\\1\n\u0005Aj#\u0001F*dQ\u0016l\u0017\rV8pYNLe\u000e^3sM\u0006\u001cW-A\u0005kI\n\u001cG*Y=feB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0005U\u0012\u00147M\u0003\u000281\u0005QA-\u0019;bg>,(oY3\n\u0005e\"$A\u0005&eE\u000ed\u0015-_3s\u0013:$XM\u001d4bG\u0016\fa\u0001P5oSRtDc\u0001\u001f>}A\u0011q\u0005\u0001\u0005\u0006U\r\u0001\ra\u000b\u0005\u0006c\r\u0001\rAM\u0001\u0007Y><w-\u001a:\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0019c\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005!\u001b%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002)\t,\u0018\u000e\u001c3De\u0016\fG/\u001a+bE2,7\u000b^7u)%a%N]A\u0001\u0003\u0017\ty\u0001E\u0002N?\nt!A\u0014/\u000f\u0005=SfB\u0001)Z\u001d\t\t\u0006L\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011QKH\u0001\u0007yI|w\u000e\u001e \n\u0003uI!a\u0007\u000f\n\u0005eQ\u0012BA\f\u0019\u0013\tYf#A\u0003feJ|'/\u0003\u0002^=\u0006iQI\u001d:pe\"\u000bg\u000e\u001a7j]\u001eT!a\u0017\f\n\u0005\u0001\f'aD\"p]:,7\r^8s%\u0016\u001cX\u000f\u001c;\u000b\u0005us\u0006CA2h\u001d\t!W\r\u0005\u0002TE%\u0011aMI\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002gE!)1N\u0002a\u0001Y\u0006IA/\u00192mK:\fW.\u001a\t\u0003[Bl\u0011A\u001c\u0006\u0003_b\taaY8oM&<\u0017BA9o\u0005%!\u0016M\u00197f\u001d\u0006lW\rC\u0003/\r\u0001\u00071\u000f\u0005\u0002u}6\tQO\u0003\u0002wo\u0006)A/\u001f9fg*\u0011\u00010_\u0001\u0004gFd'BA\r{\u0015\tYH0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0006\u0019qN]4\n\u0005},(AC*ueV\u001cG\u000fV=qK\"9\u00111\u0001\u0004A\u0002\u0005\u0015\u0011AB:ue2,g\u000eE\u0002\"\u0003\u000fI1!!\u0003#\u0005\u0011auN\\4\t\u000f\u00055a\u00011\u0001\u0002\u0006\u0005Y\u0011M\u001d:bs2+gn\u001a;i\u0011%\t\tB\u0002I\u0001\u0002\u0004\t\u0019\"\u0001\u0003uK6\u0004\bcA\u0011\u0002\u0016%\u0019\u0011q\u0003\u0012\u0003\u000f\t{w\u000e\\3b]\u0006q\"-^5mI\u000e\u0013X-\u0019;f)\u0006\u0014G.Z*u[R$C-\u001a4bk2$H%N\u000b\u0003\u0003;QC!a\u0005\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002,\t\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\buK6\u0004H+\u00192mK\u0016C\u0018n\u001d;t)\u0011\t)$a\u000e\u0011\t5{\u00161\u0003\u0005\u0006+!\u0001\r\u0001\\\u0001\u000bm&,w/\u0012=jgR\u001cH\u0003BA\u001b\u0003{Aa!a\u0010\n\u0001\u0004a\u0017\u0001\u0002<jK^\f1\u0002^1cY\u0016,\u00050[:ugR!\u0011QGA#\u0011\u0015)\"\u00021\u0001m\u0003M\u0019'/Z1uK\u0016CH/\u001a:oC2$\u0016M\u00197f)9\tY%a\u0015\u0002V\u0005}\u0013\u0011MA2\u0003O\u0002B!T0\u0002NA\u0019\u0011%a\u0014\n\u0007\u0005E#E\u0001\u0003V]&$\b\"B6\f\u0001\u0004a\u0007bBA,\u0017\u0001\u0007\u0011\u0011L\u0001\u000fi\u0006\u0014x-\u001a;UC\ndWmU9m!\u0011\t\u00131\f2\n\u0007\u0005u#E\u0001\u0004PaRLwN\u001c\u0005\u0006]-\u0001\ra\u001d\u0005\b\u0003\u0007Y\u0001\u0019AA\u0003\u0011\u0019\t)g\u0003a\u0001E\u0006iQO\u001d7U_\u000e{\u0007/\u001f$s_6Dq!!\u0004\f\u0001\u0004\t)!A\u000bwC2LG-\u0019;f\u000bb$XM\u001d8bYR\u000b'\r\\3\u0015\r\u0005-\u0013QNA8\u0011\u0015YG\u00021\u0001m\u0011\u0015qC\u00021\u0001t\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0019\u0005-\u0013QOA<\u0003s\nY(! \t\u000b-l\u0001\u0019\u00017\t\u000f\u0005]S\u00021\u0001\u0002Z!)a&\u0004a\u0001g\"9\u00111A\u0007A\u0002\u0005\u0015\u0001bBA\u0007\u001b\u0001\u0007\u0011QA\u0001\nIJ|\u0007\u000fV1cY\u0016$B!a\u0013\u0002\u0004\")1N\u0004a\u0001Y\u0006iAO];oG\u0006$X\rV1cY\u0016$B!a\u0013\u0002\n\")1n\u0004a\u0001Y\u0006y1M]3bi\u0016$V-\u001c9UC\ndW\r\u0006\u0006\u0002L\u0005=\u0015\u0011SAJ\u0003+CQa\u001b\tA\u00021DQA\f\tA\u0002MDq!a\u0001\u0011\u0001\u0004\t)\u0001C\u0004\u0002\u000eA\u0001\r!!\u0002\u00027\r\u0014X-\u0019;f\u0003:$\u0017J\\5u\u0015>\u00147\u000b^1ukN$\u0016M\u00197f))\tY%a'\u0002\u001e\u0006\u0005\u0016Q\u0015\u0005\u0006WF\u0001\r\u0001\u001c\u0005\u0007\u0003?\u000b\u0002\u0019\u00012\u0002\tU\u001cXM\u001d\u0005\u0007\u0003G\u000b\u0002\u0019\u00012\u0002\u0013M,7o]5p]&#\u0007BBAT#\u0001\u0007!-\u0001\u0005tCZ,Wj\u001c3f\u0003Q)\b\u000fZ1uK*{'m\u0015;biV\u001cH+\u00192mKRa\u00111JAW\u0003c\u000b\u0019,!0\u0002@\"1\u0011q\u0016\nA\u00021\fQ\"\\1j]R\u000b'\r\\3OC6,\u0007BBAP%\u0001\u0007!\rC\u0004\u00026J\u0001\r!a.\u0002#\u0019\f\u0017\u000e\\3e%><8\u000fU3sG\u0016tG\u000fE\u0002\"\u0003sK1!a/#\u0005\u0019!u.\u001e2mK\"1\u00111\u0015\nA\u0002\tDq!!1\u0013\u0001\u0004\t\u0019\"A\u0004tk\u000e\u001cWm]:")
public class TableUtils
implements TableUtilsInterface {
    private final SchemaToolsInterface schemaTools;
    private final JdbcLayerInterface jdbcLayer;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    private Either<ConnectorError, String> buildCreateTableStmt(TableName tablename, StructType schema, long strlen, long arrayLength, boolean temp) {
        return this.schemaTools.checkValidTableSchema(schema).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return $this.schemaTools.makeTableColumnDefs(schema, strlen, arrayLength).map((Function1 & Serializable)columnDefs -> {
                StringBuilder sb = new StringBuilder();
                StringBuilder stringBuilder = temp ? sb.append("CREATE TEMPORARY TABLE ") : sb.append("CREATE table ");
                sb.append(tablename.getFullTableName());
                sb.append(columnDefs);
                StringBuilder stringBuilder2 = temp ? sb.append(" ON COMMIT PRESERVE ROWS INCLUDE SCHEMA PRIVILEGES ") : sb.append(" INCLUDE SCHEMA PRIVILEGES ");
                return sb.toString();
            });
        });
    }

    private boolean buildCreateTableStmt$default$5() {
        return false;
    }

    @Override
    public Either<ConnectorError, Object> tempTableExists(TableName table) {
        String dbschema = (String)table.dbschema().getOrElse((Function0 & Serializable)() -> "public");
        String query = "select is_temp_table as t from v_catalog.tables where table_name=? and table_schema=?";
        .colon.colon params = new .colon.colon((Object)new JdbcLayerStringParam(table.name()), (List)new .colon.colon((Object)new JdbcLayerStringParam(dbschema), (List)Nil$.MODULE$));
        Either ret = this.jdbcLayer.query(query, (Seq<JdbcLayerParam>)params).map((Function1 & Serializable)rs -> {
            Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                if (rs.next()) {
                    return rs.getBoolean("t");
                }
                return false;
            });
            rs.close();
            BoxedUnit x$2 = BoxedUnit.UNIT;
            return new Tuple3(rs, (Object)res, (Object)x$2);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple3 tuple3 = x$3;
            if (tuple3 != null) {
                Try res = (Try)tuple3._2();
                return JdbcUtils$.MODULE$.tryJdbcToResult($this.jdbcLayer, res).map((Function1 & Serializable)isTemp -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isTemp)));
            }
            throw new MatchError((Object)tuple3);
        });
        return ret.left().map((Function1 & Serializable)err -> new TableCheckError((Option<ConnectorError>)new Some(err)).context("Cannot append to a temporary table"));
    }

    @Override
    public Either<ConnectorError, Object> viewExists(TableName view) {
        String query = "select count(*) from views where table_schema ILIKE ? and table_name ILIKE ?";
        String dbschema = (String)view.dbschema().getOrElse((Function0 & Serializable)() -> "public");
        .colon.colon params = new .colon.colon((Object)new JdbcLayerStringParam(dbschema), (List)new .colon.colon((Object)new JdbcLayerStringParam(view.name()), (List)Nil$.MODULE$));
        Either<ConnectorError, ResultSet> either = this.jdbcLayer.query(query, (Seq<JdbcLayerParam>)params);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            return new Left((Object)new TableCheckError((Option<ConnectorError>)new Some((Object)err)).context("JDBC Error when checking if view exists"));
        }
        if (either instanceof Right) {
            Left left;
            block8: {
                Right right = (Right)either;
                try (ResultSet rs = (ResultSet)right.value();){
                    try {
                        if (!rs.next()) {
                            left = new Left((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$).context("View check: empty result"));
                            break block8;
                        }
                        left = new Right((Object)BoxesRunTime.boxToBoolean((rs.getInt(1) >= 1 ? 1 : 0) != 0));
                    }
                    catch (Throwable e) {
                        this.jdbcLayer.handleJDBCException(e);
                        left = new Left((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$));
                    }
                }
            }
            return left;
        }
        throw new MatchError(either);
    }

    @Override
    public Either<ConnectorError, Object> tableExists(TableName table) {
        String query = "select count(*) from v_catalog.tables where table_schema ILIKE ? and table_name ILIKE ?";
        String dbschema = (String)table.dbschema().getOrElse((Function0 & Serializable)() -> "public");
        .colon.colon params = new .colon.colon((Object)new JdbcLayerStringParam(dbschema), (List)new .colon.colon((Object)new JdbcLayerStringParam(table.name()), (List)Nil$.MODULE$));
        Either<ConnectorError, ResultSet> either = this.jdbcLayer.query(query, (Seq<JdbcLayerParam>)params);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            return new Left((Object)new TableCheckError((Option<ConnectorError>)new Some((Object)err)).context("JDBC Error when checking if table exists"));
        }
        if (either instanceof Right) {
            Left left;
            block8: {
                Right right = (Right)either;
                try (ResultSet rs = (ResultSet)right.value();){
                    try {
                        if (!rs.next()) {
                            left = new Left((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$).context("Table check: empty result"));
                            break block8;
                        }
                        left = new Right((Object)BoxesRunTime.boxToBoolean((rs.getInt(1) >= 1 ? 1 : 0) != 0));
                    }
                    catch (Throwable e) {
                        this.jdbcLayer.handleJDBCException(e);
                        left = new Left((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$));
                    }
                }
            }
            return left;
        }
        throw new MatchError(either);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Either<ConnectorError, BoxedUnit> createExternalTable(TableName tablename, Option<String> targetTableSql, StructType schema, long strlen, String urlToCopyFrom, long arrayLength) {
        BoxedUnit boxedUnit;
        Right statement;
        Right right;
        Option<String> option = targetTableSql;
        if (option instanceof Some) {
            Some some = (Some)option;
            String sql = (String)some.value();
            right = new Right((Object)sql);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Either<ConnectorError, String> either = this.schemaTools.makeTableColumnDefs(schema, strlen, arrayLength);
            if (either instanceof Right) {
                Right right2 = (Right)either;
                String columnDefs = (String)right2.value();
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE EXTERNAL table ");
                sb.append(tablename.getFullTableName());
                sb.append(columnDefs);
                sb.append(" AS COPY FROM '");
                sb.append(urlToCopyFrom);
                sb.append("' PARQUET");
                right = new Right((Object)sb.toString());
            } else {
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left = (Left)either;
                ConnectorError err2 = (ConnectorError)left.value();
                right = new Left((Object)err2);
            }
        }
        Right right3 = statement = right;
        if (right3 instanceof Left) {
            Left left = (Left)right3;
            ConnectorError err3 = (ConnectorError)left.value();
            return new Left((Object)err3);
        }
        if (!(right3 instanceof Right)) throw new MatchError((Object)right3);
        Right right4 = right3;
        String st = (String)right4.value();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new java.lang.StringBuilder(38).append("BUILDING EXTERNAL TABLE WITH COMMAND: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
            return this.jdbcLayer.execute(st, this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable)err -> new CreateTableError((Option<ConnectorError>)new Some(err)).context("JDBC Error creating external table"));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.jdbcLayer.execute(st, this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable)err -> new CreateTableError((Option<ConnectorError>)new Some(err)).context("JDBC Error creating external table"));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> validateExternalTable(TableName tablename, StructType schema) {
        Seq schemaNoMap = (Seq)schema.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TableUtils.$anonfun$validateExternalTable$1(x$4)));
        if (schemaNoMap.isEmpty()) {
            return new Right((Object)BoxedUnit.UNIT);
        }
        String cols = ((IterableOnceOps)schemaNoMap.map((Function1 & Serializable)col -> new java.lang.StringBuilder(2).append("\"").append(col.name()).append("\"").toString())).mkString(", ");
        Either<ConnectorError, ResultSet> either = this.jdbcLayer.query(new java.lang.StringBuilder(22).append("SELECT ").append(cols).append(" FROM ").append(tablename.getFullTableName()).append(" LIMIT 1;").toString(), this.jdbcLayer.query$default$2());
        if (either instanceof Right) {
            return new Right((Object)BoxedUnit.UNIT);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            return new Left((Object)err);
        }
        throw new MatchError(either);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createTable(TableName tablename, Option<String> targetTableSql, StructType schema, long strlen, long arrayLength) {
        Either<ConnectorError, String> statement;
        Either<ConnectorError, String> either;
        Option<String> option = targetTableSql;
        if (option instanceof Some) {
            Some some = (Some)option;
            String sql = (String)some.value();
            either = new Either<ConnectorError, String>((Object)sql);
        } else if (None$.MODULE$.equals(option)) {
            either = this.buildCreateTableStmt(tablename, schema, strlen, arrayLength, this.buildCreateTableStmt$default$5());
        } else {
            throw new MatchError(option);
        }
        Either<ConnectorError, String> either2 = statement = either;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            ConnectorError err2 = (ConnectorError)left.value();
            return new Left((Object)err2);
        }
        if (either2 instanceof Right) {
            BoxedUnit boxedUnit;
            Right right = (Right)either2;
            String st = (String)right.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new java.lang.StringBuilder(29).append("BUILDING TABLE WITH COMMAND: ").append(statement).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.jdbcLayer.execute(st, this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable)err -> new CreateTableError((Option<ConnectorError>)new Some(err)).context("JDBC Error creating table"));
        }
        throw new MatchError(either2);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> dropTable(TableName tablename) {
        return this.jdbcLayer.execute(new java.lang.StringBuilder(21).append("DROP TABLE IF EXISTS ").append(tablename.getFullTableName()).toString(), this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable)err -> err.context("JDBC Error dropping table"));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> truncateTable(TableName tablename) {
        return this.jdbcLayer.execute(new java.lang.StringBuilder(15).append("TRUNCATE TABLE ").append(tablename.getFullTableName()).toString(), this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable)err -> err.context("JDBC Error truncating table"));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createTempTable(TableName tablename, StructType schema, long strlen, long arrayLength) {
        BoxedUnit boxedUnit;
        Either<ConnectorError, String> statement = this.buildCreateTableStmt(tablename, schema, strlen, arrayLength, true);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new java.lang.StringBuilder(34).append("BUILDING TEMP TABLE WITH COMMAND: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, String> either = statement;
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err2 = (ConnectorError)left.value();
            return new Left((Object)err2);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String st = (String)right.value();
            return this.jdbcLayer.execute(st, this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable)err -> new CreateTableError((Option<ConnectorError>)new Some(err)).context("JDBC Error creating table"));
        }
        throw new MatchError(either);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createAndInitJobStatusTable(TableName tablename, String user, String sessionId, String saveMode) {
        Either ret;
        String string;
        Option<String> option = tablename.dbschema();
        if (option instanceof Some) {
            String schema;
            Some some = (Some)option;
            string = schema = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = "public";
        } else {
            throw new MatchError(option);
        }
        String dbschema = string;
        String table = new java.lang.StringBuilder(20).append("S2V_JOB_STATUS_USER_").append(user.toUpperCase()).toString();
        TableName jobStatusTableName = new TableName(table, (Option<String>)new Some((Object)dbschema));
        String createStatement = new java.lang.StringBuilder(255).append("CREATE TABLE IF NOT EXISTS ").append(jobStatusTableName.getFullTableName()).append("(target_table_schema VARCHAR(128), ").append("target_table_name VARCHAR(128), ").append("save_mode VARCHAR(128), ").append("job_name VARCHAR(256), ").append("start_time TIMESTAMPTZ, ").append("all_done BOOLEAN NOT NULL, ").append("success BOOLEAN NOT NULL, ").append("percent_failed_rows DOUBLE PRECISION)").toString();
        String jobStartTime = Calendar.getInstance().getTime().toString();
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        String randJobName = sessionId;
        String comment = new java.lang.StringBuilder(149).append("COMMENT ON TABLE ").append(jobStatusTableName.getFullTableName()).append(" IS 'Persistent job status table showing all jobs, serving as permanent record of data loaded from Spark to Vertica. Creation time:").append(jobStartTime).append("'").toString();
        String insertStatement = new java.lang.StringBuilder(49).append("INSERT into ").append(jobStatusTableName.getFullTableName()).append(" VALUES ('").append(EscapeUtils$.MODULE$.sqlEscape(dbschema, '\'')).append("','").append(EscapeUtils$.MODULE$.sqlEscape(tablename.name(), '\'')).append("','").append(saveMode).append("','").append(randJobName).append("','").append(timestamp).append("',").append("false,false,").append(Double.toString(-1.0)).append(")").toString();
        Either either = ret = this.tableExists(jobStatusTableName).flatMap((Function1 & Serializable)tableExists -> TableUtils.$anonfun$createAndInitJobStatusTable$1(this, createStatement, comment, insertStatement, BoxesRunTime.unboxToBoolean((Object)tableExists)));
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            ConnectorError connectorError = err.getUnderlyingError();
            if (connectorError instanceof JdbcError) {
                JdbcError jdbcError = (JdbcError)connectorError;
                return new Left((Object)new JobStatusCreateError(jdbcError).context("JDBC error when trying to initialize job status table"));
            }
            if (connectorError != null) {
                return new Left((Object)err);
            }
            throw new MatchError((Object)connectorError);
        }
        if (either instanceof Right) {
            return new Right((Object)BoxedUnit.UNIT);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> updateJobStatusTable(TableName mainTableName, String user, double failedRowsPercent, String sessionId, boolean success) {
        BoxedUnit boxedUnit;
        String dbschema = (String)mainTableName.dbschema().getOrElse((Function0 & Serializable)() -> "public");
        String tablename = new java.lang.StringBuilder(20).append("S2V_JOB_STATUS_USER_").append(user.toUpperCase()).toString();
        TableName jobStatusTableName = new TableName(tablename, (Option<String>)new Some((Object)dbschema));
        String updateStatusTable = new java.lang.StringBuilder(112).append("UPDATE ").append(jobStatusTableName.getFullTableName()).append(" SET all_done=").append(true).append(",").append("success=").append(success).append(",").append("percent_failed_rows=").append(Double.toString(failedRowsPercent)).append(" ").append("WHERE job_name='").append(sessionId).append("' ").append("AND all_done=").append(false).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new java.lang.StringBuilder(17).append("Updating ").append(jobStatusTableName.getFullTableName()).append(" next...").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, Object> either = this.jdbcLayer.executeUpdate(updateStatusTable, this.jdbcLayer.executeUpdate$default$2());
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            return new Left((Object)new JobStatusUpdateError((Option<ConnectorError>)new Some((Object)err)).context("JDBC Error when updating status table"));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            int c = BoxesRunTime.unboxToInt((Object)right.value());
            if (c == 1) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new java.lang.StringBuilder(21).append("Update of ").append(jobStatusTableName.getFullTableName()).append(" succeeded.").toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return new Right((Object)BoxedUnit.UNIT);
            }
            return new Left((Object)new JobStatusUpdateError((Option<ConnectorError>)None$.MODULE$).context("Status_table update failed."));
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$validateExternalTable$1(StructField x$4) {
        return x$4.dataType() instanceof MapType;
    }

    public static final /* synthetic */ Either $anonfun$createAndInitJobStatusTable$1(TableUtils $this, String createStatement$1, String comment$1, String insertStatement$1, boolean tableExists) {
        return (!tableExists ? $this.jdbcLayer.execute(createStatement$1, $this.jdbcLayer.execute$default$2()) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$8 -> {
            BoxedUnit boxedUnit = x$8;
            return (!tableExists ? $this.jdbcLayer.execute(comment$1, $this.jdbcLayer.execute$default$2()) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$7 -> {
                BoxedUnit boxedUnit = x$7;
                return $this.jdbcLayer.execute(insertStatement$1, $this.jdbcLayer.execute$default$2()).flatMap((Function1 & Serializable)x$6 -> {
                    BoxedUnit boxedUnit = x$6;
                    return $this.jdbcLayer.commit().map((Function1 & Serializable)x$5 -> {
                        boxedUnit = x$5;
                        return BoxedUnit.UNIT;
                    });
                });
            });
        });
    }

    public TableUtils(SchemaToolsInterface schemaTools, JdbcLayerInterface jdbcLayer) {
        this.schemaTools = schemaTools;
        this.jdbcLayer = jdbcLayer;
        this.logger = LogProvider$.MODULE$.getLogger(TableUtils.class);
    }
}

