/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.version;

import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.ComplexTypeReadNotSupported;
import com.vertica.spark.util.error.ComplexTypeWriteNotSupported;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ExportToJsonNotSupported;
import com.vertica.spark.util.error.InternalMapNotSupported;
import com.vertica.spark.util.error.NativeArrayReadNotSupported;
import com.vertica.spark.util.error.NativeArrayWriteNotSupported;
import com.vertica.spark.util.error.UnrecognizedVerticaVersionString;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools;
import com.vertica.spark.util.version.Version;
import com.vertica.spark.util.version.Version$;
import java.io.Serializable;
import java.sql.ResultSet;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class VerticaVersionUtils$ {
    public static final VerticaVersionUtils$ MODULE$ = new VerticaVersionUtils$();
    private static final Version VERTICA_11 = new Version(11, Version$.MODULE$.apply$default$2(), Version$.MODULE$.apply$default$3(), Version$.MODULE$.apply$default$4());
    private static final Version VERTICA_11_1 = new Version(11, 1, Version$.MODULE$.apply$default$3(), Version$.MODULE$.apply$default$4());
    private static final Version VERTICA_11_1_1 = new Version(11, 1, 1, Version$.MODULE$.apply$default$4());
    private static final Version VERTICA_12_0_2 = new Version(12, 0, 2, Version$.MODULE$.apply$default$4());
    private static final Version VERTICA_DEFAULT = new Version(12, Version$.MODULE$.apply$default$2(), Version$.MODULE$.apply$default$3(), Version$.MODULE$.apply$default$4());
    private static final ComplexTypesSchemaTools complexTypeUtils = new ComplexTypesSchemaTools();

    public Version VERTICA_11() {
        return VERTICA_11;
    }

    public Version VERTICA_11_1() {
        return VERTICA_11_1;
    }

    public Version VERTICA_11_1_1() {
        return VERTICA_11_1_1;
    }

    public Version VERTICA_12_0_2() {
        return VERTICA_12_0_2;
    }

    public Version VERTICA_DEFAULT() {
        return VERTICA_DEFAULT;
    }

    public ComplexTypesSchemaTools complexTypeUtils() {
        return complexTypeUtils;
    }

    public Version getVersionOrDefault(JdbcLayerInterface jdbcLayer) {
        return (Version)this.getVersion(jdbcLayer).getOrElse((Function0 & Serializable)() -> MODULE$.VERTICA_DEFAULT());
    }

    public Either<ConnectorError, Version> getVersion(JdbcLayerInterface jdbcLayer) {
        return JdbcUtils$.MODULE$.queryAndNext("SELECT version();", jdbcLayer, (Function1 & Serializable)rs -> MODULE$.extractVersion((ResultSet)rs), JdbcUtils$.MODULE$.queryAndNext$default$4());
    }

    private Either<ConnectorError, Version> extractVersion(ResultSet rs) {
        return this.parseVerticaVersionString(rs.getString(1));
    }

    public Either<ConnectorError, Version> parseVerticaVersionString(String versionString) {
        Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*v([0-9]+)\\.([0-9]+)\\.([0-9])+-([0-9]+).*"));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Option option;
            String string = versionString;
            if (string == null || (option = pattern.unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(4) != 0) {
                throw new MatchError((Object)string);
            }
            String major = (String)((LinearSeqOps)option.get()).apply(0);
            String minor = (String)((LinearSeqOps)option.get()).apply(1);
            String service = (String)((LinearSeqOps)option.get()).apply(2);
            String hotfix = (String)((LinearSeqOps)option.get()).apply(3);
            Tuple4 tuple4 = new Tuple4((Object)major, (Object)minor, (Object)service, (Object)hotfix);
            String major2 = (String)tuple4._1();
            String minor2 = (String)tuple4._2();
            String service2 = (String)tuple4._3();
            String hotfix2 = (String)tuple4._4();
            return new Version(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(major2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(minor2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(service2)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(hotfix2)));
        });
        if (try_ instanceof Failure) {
            return new Left((Object)new UnrecognizedVerticaVersionString(versionString));
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Version version = (Version)success.value();
            return new Right((Object)version);
        }
        throw new MatchError((Object)try_);
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaTypesWriteSupport(StructType schema, Version version, boolean toInternalTable) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().filterColumnTypes(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        List nativeCols2 = (List)tuple22._1();
        List complexTypeCols2 = (List)tuple22._2();
        boolean complexTypeFound = complexTypeCols2.nonEmpty();
        List nativeArrayCols = nativeCols2.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesWriteSupport$1(x$3)));
        if (version.major() <= 9) {
            if (complexTypeFound) {
                return new Left((Object)new ComplexTypeWriteNotSupported((List<StructField>)complexTypeCols2, version.toString()));
            }
            if (nativeArrayCols.nonEmpty()) {
                return new Left((Object)new NativeArrayWriteNotSupported((List<StructField>)nativeArrayCols, version.toString()));
            }
            return new Right((Object)BoxedUnit.UNIT);
        }
        if (version.major() == 10) {
            if (complexTypeFound) {
                return new Left((Object)new ComplexTypeWriteNotSupported((List<StructField>)complexTypeCols2, version.toString()));
            }
            return new Right((Object)BoxedUnit.UNIT);
        }
        if (toInternalTable && complexTypeCols2.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesWriteSupport$2(x$4)))) {
            return new Left((Object)new InternalMapNotSupported());
        }
        return new Right((Object)BoxedUnit.UNIT);
    }

    public Either<ConnectorError, BoxedUnit> checkComplexTypesParquetExport(StructType schema, Version version) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().filterColumnTypes(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        List nativeCols2 = (List)tuple22._1();
        List complexTypeCols2 = (List)tuple22._2();
        if (version.$less(this.VERTICA_12_0_2())) {
            return new Left((Object)new ComplexTypeWriteNotSupported((List<StructField>)complexTypeCols2, version.toString()));
        }
        return new Right((Object)BoxedUnit.UNIT);
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaTypesReadSupport(StructType schema, Version version) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().filterColumnTypes(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        List nativeCols2 = (List)tuple22._1();
        List complexTypeCols2 = (List)tuple22._2();
        List nativeArrayCols = nativeCols2.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesReadSupport$1(x$7)));
        if (version.major() <= 10) {
            if (complexTypeCols2.nonEmpty()) {
                return new Left((Object)new ComplexTypeReadNotSupported((List<StructField>)complexTypeCols2, version.toString()));
            }
            if (nativeArrayCols.nonEmpty()) {
                return new Left((Object)new NativeArrayReadNotSupported((List<StructField>)nativeArrayCols, version.toString()));
            }
            return new Right((Object)BoxedUnit.UNIT);
        }
        if (version.$less$eq(this.VERTICA_11_1())) {
            if (complexTypeCols2.nonEmpty()) {
                return new Left((Object)new ComplexTypeReadNotSupported((List<StructField>)complexTypeCols2, version.toString()));
            }
            return new Right((Object)BoxedUnit.UNIT);
        }
        return new Right((Object)BoxedUnit.UNIT);
    }

    public Either<ConnectorError, BoxedUnit> checkJsonSupport(Version version) {
        if (version.$less(this.VERTICA_11_1_1())) {
            return new Left((Object)new ExportToJsonNotSupported(version.toString()));
        }
        return new Right((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesWriteSupport$1(StructField x$3) {
        return x$3.dataType() instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesWriteSupport$2(StructField x$4) {
        return x$4.dataType() instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesReadSupport$1(StructField x$7) {
        return x$7.dataType() instanceof ArrayType;
    }

    private VerticaVersionUtils$() {
    }
}

