/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet.vertica;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.Function0;
import scala.Predef$;

public final class ParquetRowConverter$ {
    public static final ParquetRowConverter$ MODULE$ = new ParquetRowConverter$();

    public long binaryToUnscaledLong(Binary binary) {
        ByteBuffer buffer = binary.toByteBuffer();
        byte[] bytes = buffer.array();
        int start = buffer.arrayOffset() + buffer.position();
        int end = buffer.arrayOffset() + buffer.limit();
        long unscaled = 0L;
        for (int i = start; i < end; ++i) {
            unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
        }
        int bits = 8 * (end - start);
        unscaled = unscaled << 64 - bits >> 64 - bits;
        return unscaled;
    }

    public long binaryToSQLTimestamp(Binary binary) {
        Predef$.MODULE$.assert(binary.length() == 12, (Function0 & Serializable)() -> new StringBuilder(111).append("Timestamps (with nanoseconds) are expected to be stored in").append(" 12-byte long binaries. Found a ").append(binary.length()).append("-byte binary instead.").toString());
        ByteBuffer buffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = buffer.getLong();
        int julianDay = buffer.getInt();
        return DateTimeUtils$.MODULE$.fromJulianDay(julianDay, timeOfDayNanos);
    }

    private ParquetRowConverter$() {
    }
}

