/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.rpc.serialization.stream.bytebuffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.gwtproject.rpc.serialization.api.SerializationException;
import org.gwtproject.rpc.serialization.api.SerializationStreamReader;
import org.gwtproject.rpc.serialization.api.TypeSerializer;
import org.gwtproject.rpc.serialization.api.impl.AbstractSerializationStreamReader;

public class ByteBufferSerializationStreamReader
extends AbstractSerializationStreamReader {
    private final TypeSerializer serializer;
    private final ByteBuffer bb;
    private final String[] strings;
    private int claimedTokens;

    public ByteBufferSerializationStreamReader(TypeSerializer serializer, ByteBuffer bb, String[] strings) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.serializer = serializer;
        this.bb = bb;
        this.strings = strings;
        int version = bb.getInt();
        int flags = bb.getInt();
        int length = bb.getInt();
        assert (length == bb.remaining());
        this.setVersion(version);
        this.setFlags(flags);
    }

    public ByteBufferSerializationStreamReader(TypeSerializer serializer, ByteBuffer bb) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.serializer = serializer;
        this.bb = bb;
        int version = bb.getInt();
        int flags = bb.getInt();
        int length = bb.getInt();
        this.setVersion(version);
        this.setFlags(flags);
        String[] strings = new String[]{};
        if (bb.limit() > 12 + length) {
            int stringsCount = bb.getInt(12 + length);
            if (stringsCount < 1) {
                throw new IllegalArgumentException("Invalid string count in payload: " + stringsCount);
            }
            bb.position(16 + length);
            if (bb.remaining() < stringsCount << 2) {
                throw new IllegalArgumentException("Payload claims to have " + stringsCount + " strings, but only has space left for " + (bb.remaining() >> 2));
            }
            strings = new String[stringsCount];
            for (int i = 0; i < stringsCount; ++i) {
                int stringLength = bb.getInt();
                if (bb.remaining() < stringLength) {
                    throw new IllegalArgumentException("Payload claims to have a string with length " + stringLength + " but only " + bb.remaining() + " bytes remain");
                }
                byte[] bytes = new byte[stringLength];
                bb.get(bytes);
                strings[i] = new String(bytes, Charset.forName("UTF-8"));
            }
        }
        bb.position(12);
        bb.limit(12 + length);
        this.strings = strings;
    }

    protected Object deserialize(String s) throws com.google.gwt.user.client.rpc.SerializationException {
        int id = this.reserveDecodedObjectIndex();
        Object instance = this.serializer.instantiate((SerializationStreamReader)this, s);
        this.rememberDecodedObject(id, instance);
        this.serializer.deserialize((SerializationStreamReader)this, instance, s);
        return instance;
    }

    protected String getString(int i) {
        return i > 0 ? this.strings[i - 1] : null;
    }

    public boolean readBoolean() throws SerializationException {
        return this.bb.get() == 1;
    }

    public byte readByte() throws SerializationException {
        return this.bb.get();
    }

    public char readChar() throws SerializationException {
        return this.bb.getChar();
    }

    public double readDouble() throws SerializationException {
        return this.bb.getDouble();
    }

    public float readFloat() throws SerializationException {
        return this.bb.getFloat();
    }

    public int readInt() throws SerializationException {
        return this.bb.getInt();
    }

    public long readLong() throws SerializationException {
        return this.bb.getLong();
    }

    public short readShort() throws SerializationException {
        return this.bb.getShort();
    }

    public String readString() throws SerializationException {
        return this.getString(this.readInt());
    }

    public void claimItems(int slots) throws SerializationException {
        if (this.claimedTokens + slots > (this.bb.limit() << 0) + this.strings.length) {
            throw new SerializationException("Request claims to be larger than it is");
        }
        this.claimedTokens += slots;
    }
}

