/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.rpc.serialization.stream.bytebuffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.gwtproject.rpc.serialization.api.SerializationException;
import org.gwtproject.rpc.serialization.api.SerializationStreamWriter;
import org.gwtproject.rpc.serialization.api.TypeSerializer;
import org.gwtproject.rpc.serialization.api.impl.AbstractSerializationStreamWriter;

public class ByteBufferSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private ByteBuffer bb;
    private final TypeSerializer serializer;

    public ByteBufferSerializationStreamWriter(TypeSerializer serializer) {
        this.serializer = serializer;
        this.bb = ByteBuffer.allocate(1024);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.position(12);
    }

    public ByteBuffer getPayloadBytes() {
        Objects.requireNonNull(this.bb);
        this.bb.limit(this.bb.position());
        this.bb.position(0);
        this.bb = this.bb.slice();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putInt(0, this.getVersion());
        this.bb.putInt(4, this.getFlags());
        this.bb.putInt(8, this.bb.limit() - 12);
        ByteBuffer retVal = this.bb;
        this.bb = null;
        return retVal;
    }

    public String[] getFinishedStringTable() {
        List stringTable = this.getStringTable();
        return stringTable.toArray(new String[0]);
    }

    public ByteBuffer getFullPayload() {
        ByteBuffer payloadBytes = this.getPayloadBytes();
        List stringTable = this.getStringTable();
        int stringCount = stringTable.size();
        if (stringCount == 0) {
            return payloadBytes;
        }
        int size = payloadBytes.limit() + (1 + stringCount << 2);
        byte[][] stringBytes = new byte[stringCount][];
        for (int i = 0; i < stringCount; ++i) {
            byte[] bytes = ((String)stringTable.get(i)).getBytes(Charset.forName("UTF-8"));
            stringBytes[i] = bytes;
            size += bytes.length;
        }
        ByteBuffer bb = ByteBuffer.allocate(size);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put(payloadBytes);
        bb.putInt(stringCount);
        for (int i = 0; i < stringCount; ++i) {
            byte[] bytes = stringBytes[i];
            bb.putInt(bytes.length);
            bb.put(bytes);
        }
        bb.position(0);
        return bb;
    }

    public String toString() {
        return "StreamWriter";
    }

    public void writeLong(long l) {
        this.maybeGrow();
        this.bb.putLong(l);
    }

    public void writeBoolean(boolean fieldValue) {
        this.maybeGrow();
        this.bb.put((byte)(fieldValue ? 1 : 0));
    }

    public void writeByte(byte fieldValue) {
        this.maybeGrow();
        this.bb.put(fieldValue);
    }

    public void writeChar(char ch) {
        this.maybeGrow();
        this.bb.putChar(ch);
    }

    public void writeFloat(float fieldValue) {
        this.maybeGrow();
        this.bb.putFloat(fieldValue);
    }

    public void writeDouble(double fieldValue) {
        this.maybeGrow();
        this.bb.putDouble(fieldValue);
    }

    public void writeInt(int fieldValue) {
        this.maybeGrow();
        this.bb.putInt(fieldValue);
    }

    private void maybeGrow() {
        if (this.bb.remaining() < 8) {
            ByteBuffer old = this.bb;
            this.bb = ByteBuffer.allocate(old.capacity() * 2);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            this.bb.put((ByteBuffer)old.flip());
        }
    }

    public void writeShort(short value) {
        this.maybeGrow();
        this.bb.putShort(value);
    }

    protected void append(String s) {
    }

    protected String getObjectTypeSignature(Object o) throws SerializationException {
        Class<Object> clazz = o.getClass();
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            clazz = e.getDeclaringClass();
        }
        return this.serializer.getSerializationSignature(clazz);
    }

    protected void serialize(Object o, String s) throws com.google.gwt.user.client.rpc.SerializationException {
        this.serializer.serialize((SerializationStreamWriter)this, o, s);
    }
}

