/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.rpc.api.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gwtproject.rpc.serialization.api.SerializationException;
import org.gwtproject.rpc.serialization.api.SerializationStreamReader;
import org.gwtproject.rpc.serialization.api.SerializationStreamWriter;
import org.gwtproject.rpc.serialization.api.TypeSerializer;

public abstract class AbstractEndpointImpl {
    private final Function<TypeSerializer, SerializationStreamWriter> writerFactory;
    private final Consumer<SerializationStreamWriter> send;
    private final TypeSerializer serializer;
    private AtomicInteger nextCallbackId = new AtomicInteger(1);
    private Map<Integer, ReadingCallback> callbacks = new ConcurrentHashMap<Integer, ReadingCallback>();

    protected <W extends SerializationStreamWriter> AbstractEndpointImpl(Function<TypeSerializer, W> writerFactory, Consumer<W> send, TypeSerializer serializer, BiConsumer<Consumer<SerializationStreamReader>, TypeSerializer> onMessage) {
        this.writerFactory = writerFactory;
        this.send = send;
        this.serializer = serializer;
        onMessage.accept(this::__onMessage, serializer);
    }

    protected abstract void __onError(Throwable var1);

    protected abstract void __invoke(int var1, SerializationStreamReader var2) throws com.google.gwt.user.client.rpc.SerializationException;

    public void __onMessage(SerializationStreamReader reader) {
        try {
            int recipient = reader.readInt();
            if (recipient >= 0) {
                this.__invoke(recipient, reader);
            } else {
                ReadingCallback callback = this.callbacks.remove(-recipient);
                callback.handle(reader);
            }
        }
        catch (com.google.gwt.user.client.rpc.SerializationException ex) {
            this.__onError(ex);
        }
    }

    private SerializationStreamWriter __startCall() {
        return this.writerFactory.apply(this.serializer);
    }

    private void __endCall(SerializationStreamWriter writer) {
        this.send.accept(writer);
    }

    protected void __send(int recipient, Send s) {
        SerializationStreamWriter writer = this.__startCall();
        try {
            writer.writeInt(recipient);
            s.send(writer);
            this.__endCall(writer);
        }
        catch (com.google.gwt.user.client.rpc.SerializationException e) {
            this.__onError(e);
            throw new RuntimeException(e);
        }
    }

    protected void __send(int recipient, Send s, ReadingCallback callback) {
        SerializationStreamWriter writer = this.__startCall();
        try {
            writer.writeInt(recipient);
            int callbackId = this.nextCallbackId.getAndIncrement();
            writer.writeInt(callbackId);
            s.send(writer);
            try {
                this.callbacks.put(callbackId, callback);
                this.__endCall(writer);
            }
            catch (Throwable t) {
                this.callbacks.remove(callbackId);
                throw t;
            }
        }
        catch (com.google.gwt.user.client.rpc.SerializationException e) {
            this.__onError(e);
            throw new RuntimeException(e);
        }
    }

    protected static abstract class ReadingCallback {
        protected ReadingCallback() {
        }

        public final void handle(SerializationStreamReader reader) throws com.google.gwt.user.client.rpc.SerializationException {
            boolean success = reader.readBoolean();
            if (success) {
                this.success(reader);
            } else {
                this.failure(reader);
            }
        }

        public abstract void success(SerializationStreamReader var1) throws SerializationException;

        public abstract void failure(SerializationStreamReader var1) throws SerializationException;
    }

    protected static interface Send {
        public void send(SerializationStreamWriter var1) throws com.google.gwt.user.client.rpc.SerializationException;
    }

    @FunctionalInterface
    public static interface EndpointImplConstructor<E> {
        public <W extends SerializationStreamWriter> E create(Function<TypeSerializer, W> var1, Consumer<W> var2, BiConsumer<Consumer<SerializationStreamReader>, TypeSerializer> var3);
    }
}

