/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.rpc.serialization.stream.string;

import java.util.ArrayList;
import java.util.List;
import org.gwtproject.rpc.serialization.api.SerializationException;
import org.gwtproject.rpc.serialization.api.SerializationStreamReader;
import org.gwtproject.rpc.serialization.api.TypeSerializer;
import org.gwtproject.rpc.serialization.api.impl.AbstractSerializationStreamReader;

public class StringSerializationStreamReader
extends AbstractSerializationStreamReader {
    private final TypeSerializer serializer;
    private int claimedTokens;
    private int tokenIndex = 0;
    private final List<String> tokens = new ArrayList<String>();
    private final List<String> stringTable = new ArrayList<String>();

    public StringSerializationStreamReader(TypeSerializer serializer, String payload) {
        int nextIdx;
        this.serializer = serializer;
        int idx = 0;
        while (-1 != (nextIdx = payload.indexOf(124, idx))) {
            String current = payload.substring(idx, nextIdx);
            this.tokens.add(current);
            idx = nextIdx + 1;
        }
        try {
            this.setVersion(this.readInt());
            this.setFlags(this.readInt());
            int stringCount = this.readInt();
            this.claimItems(stringCount);
            for (int typeNameIndex = 0; typeNameIndex < stringCount; ++typeNameIndex) {
                String str = this.token();
                idx = str.indexOf(92);
                if (idx >= 0) {
                    StringBuilder buf = new StringBuilder();
                    int pos = 0;
                    while (idx >= 0) {
                        buf.append(str.substring(pos, idx));
                        if (++idx == str.length()) {
                            throw new SerializationException("Unmatched backslash: \"" + str + "\"");
                        }
                        char ch = str.charAt(idx);
                        pos = idx + 1;
                        switch (ch) {
                            case '0': {
                                buf.append('\u0000');
                                break;
                            }
                            case '!': {
                                buf.append('|');
                                break;
                            }
                            case '\\': {
                                buf.append(ch);
                                break;
                            }
                            case 'u': {
                                try {
                                    ch = (char)Integer.parseInt(str.substring(idx + 1, idx + 5), 16);
                                }
                                catch (NumberFormatException e) {
                                    throw new SerializationException("Invalid Unicode escape sequence in \"" + str + "\"");
                                }
                                buf.append(ch);
                                pos += 4;
                                break;
                            }
                            default: {
                                throw new SerializationException("Unexpected escape character " + ch + " after backslash: \"" + str + "\"");
                            }
                        }
                        idx = str.indexOf(92, pos);
                    }
                    buf.append(str.substring(pos));
                    str = buf.toString();
                }
                this.stringTable.add(str);
            }
            if (this.stringTable.size() != stringCount) {
                throw new SerializationException("Expected " + stringCount + " string table elements; received " + this.stringTable.size());
            }
        }
        catch (SerializationException ex) {
            throw new IllegalStateException("Invalid payload: ", ex);
        }
    }

    protected Object deserialize(String typeSignature) throws com.google.gwt.user.client.rpc.SerializationException {
        int id = this.reserveDecodedObjectIndex();
        Object instance = this.serializer.instantiate((SerializationStreamReader)this, typeSignature);
        this.rememberDecodedObject(id, instance);
        this.serializer.deserialize((SerializationStreamReader)this, instance, typeSignature);
        return instance;
    }

    protected String getString(int index) {
        if (index == 0) {
            return null;
        }
        assert (index > 0);
        assert (index <= this.stringTable.size());
        return this.stringTable.get(index - 1);
    }

    private String token() {
        return this.tokens.get(this.tokenIndex++);
    }

    public boolean readBoolean() throws SerializationException {
        return !this.token().equals("0");
    }

    public byte readByte() throws SerializationException {
        return Byte.parseByte(this.token());
    }

    public char readChar() throws SerializationException {
        return (char)this.readInt();
    }

    public double readDouble() throws SerializationException {
        return Double.parseDouble(this.token());
    }

    public float readFloat() throws SerializationException {
        return (float)this.readDouble();
    }

    public int readInt() throws SerializationException {
        return Integer.parseInt(this.token());
    }

    public long readLong() throws SerializationException {
        return StringSerializationStreamReader.longFromBase64((String)this.token());
    }

    public short readShort() throws SerializationException {
        return Short.parseShort(this.token());
    }

    public String readString() throws SerializationException {
        return this.getString(this.readInt());
    }

    public void claimItems(int slots) throws SerializationException {
        if (this.claimedTokens + slots > this.tokens.size() + this.stringTable.size()) {
            throw new SerializationException("Request claims to be larger than it is");
        }
        this.claimedTokens += slots;
    }
}

