/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.rpc.serialization.stream.string;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.List;
import org.gwtproject.rpc.serialization.api.SerializationStreamWriter;
import org.gwtproject.rpc.serialization.api.TypeSerializer;
import org.gwtproject.rpc.serialization.api.impl.AbstractSerializationStreamWriter;

public class StringSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private StringBuilder encodeBuffer;
    private final TypeSerializer serializer;

    private static void append(StringBuilder sb, String token) {
        assert (token != null);
        sb.append(token);
        sb.append('|');
    }

    public StringSerializationStreamWriter(TypeSerializer serializer) {
        this.serializer = serializer;
    }

    public void prepareToWrite() {
        super.prepareToWrite();
        this.encodeBuffer = new StringBuilder();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.writeHeader(buffer);
        this.writeStringTable(buffer);
        this.writePayload(buffer);
        return buffer.toString();
    }

    public void writeLong(long value) {
        this.append(StringSerializationStreamWriter.longToBase64((long)value));
    }

    protected void append(String token) {
        StringSerializationStreamWriter.append(this.encodeBuffer, token);
    }

    protected String getObjectTypeSignature(Object o) {
        Class<Object> clazz = o.getClass();
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            clazz = e.getDeclaringClass();
        }
        return this.serializer.getSerializationSignature(clazz);
    }

    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        this.serializer.serialize((SerializationStreamWriter)this, instance, typeSignature);
    }

    private void writeHeader(StringBuilder buffer) {
        StringSerializationStreamWriter.append(buffer, String.valueOf(this.getVersion()));
        StringSerializationStreamWriter.append(buffer, String.valueOf(this.getFlags()));
    }

    private void writePayload(StringBuilder buffer) {
        buffer.append(this.encodeBuffer.toString());
    }

    private void writeStringTable(StringBuilder buffer) {
        List stringTable = this.getStringTable();
        StringSerializationStreamWriter.append(buffer, String.valueOf(stringTable.size()));
        for (String s : stringTable) {
            StringSerializationStreamWriter.append(buffer, StringSerializationStreamWriter.quoteString(s));
        }
    }

    private static String quoteString(String str) {
        return str.replaceAll("\\\\", "\\\\\\\\").replaceAll("\u0000", "\\\\0").replaceAll("\\|", "\\\\!").replaceAll("\"", "\\\"");
    }
}

