/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.doclet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SimpleDocTreeVisitor;
import com.vertispan.tsdefs.impl.Formatting;
import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.TsElement;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import jdk.javadoc.doclet.DocletEnvironment;

public class TsDocTreeVisitor
extends SimpleDocTreeVisitor<String, Element> {
    private final HasProcessorEnv env;
    private final DocletEnvironment docletEnv;

    public TsDocTreeVisitor(HasProcessorEnv env, DocletEnvironment docletEnv) {
        this.env = env;
        this.docletEnv = docletEnv;
    }

    @Override
    protected String defaultAction(DocTree node, Element element) {
        return node.toString();
    }

    @Override
    public String visitLink(LinkTree node, Element element) {
        return "{@link " + (String)this.visit(node.getReference(), element) + (node.getLabel().isEmpty() ? "" : this.formatLabel(String.valueOf(node.getLabel().get(0)))) + "}";
    }

    @Override
    public String visitReference(ReferenceTree node, Element element) {
        return this.getElementFromReference(node, element).map(referencedElement -> {
            if (ElementKind.METHOD == referencedElement.getKind()) {
                TsElement tsElement = TsElement.of(element, this.env);
                TsElement refTsElement = TsElement.of(referencedElement, this.env);
                TsElement parentTsElement = TsElement.of(referencedElement.getEnclosingElement(), this.env);
                String namespace = tsElement.getNamespace();
                String refNamespace = refTsElement.getNamespace();
                String parentNamespace = parentTsElement.getNamespace();
                boolean isSetterOrGetter = refTsElement.isSetter() || refTsElement.isGetter();
                String name = isSetterOrGetter ? Formatting.nonGetSetName(refTsElement.getName()) : refTsElement.getName();
                String parentName = parentTsElement.getName();
                if (refNamespace.equals(parentNamespace)) {
                    String fullName = refNamespace + "." + parentName + "." + name;
                    return fullName.replace(namespace + ".", "").replace(tsElement.getName() + ".", "");
                }
                return refNamespace + "." + name;
            }
            return this.formatName(TsElement.of(referencedElement, this.env));
        }).orElse(node.getSignature());
    }

    private Optional<Element> getElementFromReference(DocTree node, Element element) {
        DocTrees trees = this.docletEnv.getDocTrees();
        Element referencedElement = trees.getElement(new DocTreePath(new DocTreePath(trees.getPath(element), trees.getDocCommentTree(element)), node));
        return Optional.ofNullable(referencedElement);
    }

    public String formatName(TsElement tsElement) {
        String namespace = tsElement.getNamespace();
        String jsName = tsElement.getName();
        return namespace.isEmpty() ? jsName : namespace + "." + jsName;
    }

    private String formatLabel(String label) {
        if (Objects.nonNull(label) && !label.trim().isEmpty()) {
            return " | " + label;
        }
        return "";
    }

    @Override
    public String visitSee(SeeTree node, Element element) {
        return "@see " + node.getReference().stream().map(docTree -> this.getElementFromReference((DocTree)docTree, element).map(refElement -> "{@link " + docTree.accept(this, element) + "}").orElse(docTree.accept(this, element))).collect(Collectors.joining());
    }

    @Override
    public String visitDocComment(DocCommentTree node, Element element) {
        String body = node.getFullBody().stream().map(docTree -> (String)this.visit((DocTree)docTree, element)).collect(Collectors.joining());
        String tags = node.getBlockTags().stream().map(tag -> " " + tag.accept(this, element)).collect(Collectors.joining("\n"));
        return " " + body + "\n" + tags;
    }

    @Override
    public String visitLiteral(LiteralTree node, Element element) {
        if (Objects.nonNull(node.getBody())) {
            String body = node.getBody().getBody();
            String wrap = "`";
            if (body.contains(System.lineSeparator())) {
                wrap = "```";
            }
            return wrap + node.getBody().getBody() + wrap;
        }
        return (String)super.visitLiteral(node, element);
    }

    @Override
    public String visitText(TextTree node, Element element) {
        return node.getBody();
    }

    @Override
    public String visitReturn(ReturnTree node, Element element) {
        return "@return " + node.getDescription().stream().map(docTree -> docTree.accept(this, element)).collect(Collectors.joining());
    }

    @Override
    public String visitParam(ParamTree node, Element element) {
        return (node.isTypeParameter() ? "@typeParam " : "@param ") + node.getName() + " - " + node.getDescription().stream().map(docTree -> docTree.accept(this, element)).collect(Collectors.joining());
    }
}

