/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.doclet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.util.TreePath;
import com.vertispan.tsdefs.annotations.TsModule;
import com.vertispan.tsdefs.doclet.DocletLogWrapper;
import com.vertispan.tsdefs.doclet.TsDocTreeVisitor;
import com.vertispan.tsdefs.doclet.TsDocletOption;
import com.vertispan.tsdefs.impl.Formatting;
import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.LogWrapper;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TypeScriptModule;
import com.vertispan.tsdefs.impl.visitors.TypeVisitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

public class TsDoclet
implements Doclet,
HasProcessorEnv {
    private Locale locale;
    private Reporter reporter;
    private DocletEnvironment env;
    private Messager messager;
    private DocletLogWrapper logWrapper;
    public static final String TSOUT_DIR = "-d";
    private String outputDir;

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.locale = locale;
        this.reporter = reporter;
        this.logWrapper = new DocletLogWrapper(reporter);
    }

    @Override
    public String getName() {
        return "jsiterop-ts-defs-doclet";
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_11;
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return Set.of(TsDocletOption.of(TSOUT_DIR, "Type script generated definition file location", (opt, arguments) -> {
            if (arguments.isEmpty()) {
                this.reporter.print(Diagnostic.Kind.ERROR, "You must specify an output filepath with -d");
                return false;
            }
            this.outputDir = (String)arguments.get(0);
            return true;
        }), TsDocletOption.ignored("-doctitle"), TsDocletOption.ignored("-windowtitle"), TsDocletOption.ignored("-notimestamp"));
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        this.env = environment;
        this.reporter.print(Diagnostic.Kind.NOTE, "Running doclet.");
        try {
            TypeScriptModule.TsModuleBuilder tsModuleBuilder = TypeScriptModule.builder(this);
            Set jsTypes = environment.getIncludedElements().stream().filter(element -> Objects.nonNull(element.getAnnotation(JsType.class)) && !element.getAnnotation(JsType.class).isNative()).collect(Collectors.toSet());
            Set jsFunctions = environment.getIncludedElements().stream().filter(element -> Objects.nonNull(element.getAnnotation(JsFunction.class))).collect(Collectors.toSet());
            Set constructorsParentElements = environment.getIncludedElements().stream().filter(element -> Objects.isNull(element.getAnnotation(JsType.class))).filter(element -> element.getEnclosedElements().stream().anyMatch(e -> Objects.nonNull(e.getAnnotation(JsConstructor.class)) && !e.getModifiers().contains((Object)Modifier.NATIVE))).collect(Collectors.toSet());
            Set methodsParentElements = environment.getIncludedElements().stream().filter(element -> Objects.isNull(element.getAnnotation(JsType.class))).filter(element -> element.getEnclosedElements().stream().anyMatch(e -> Objects.nonNull(e.getAnnotation(JsMethod.class)) && !e.getModifiers().contains((Object)Modifier.NATIVE))).collect(Collectors.toSet());
            Set propertiesParentElements = environment.getIncludedElements().stream().filter(element -> Objects.isNull(element.getAnnotation(JsType.class))).filter(element -> element.getEnclosedElements().stream().anyMatch(e -> Objects.nonNull(e.getAnnotation(JsProperty.class)) && !e.getModifiers().contains((Object)Modifier.NATIVE))).collect(Collectors.toSet());
            HashSet eligibleElements = new HashSet();
            eligibleElements.addAll(jsTypes);
            eligibleElements.addAll(jsFunctions);
            eligibleElements.addAll(constructorsParentElements);
            eligibleElements.addAll(methodsParentElements);
            eligibleElements.addAll(propertiesParentElements);
            eligibleElements.stream().filter(element -> Objects.isNull(element.getAnnotation(JsType.class)) || !element.getAnnotation(JsType.class).isNative()).forEach(e -> {
                try {
                    new TypeVisitor((Element)e, (HasProcessorEnv)this).visit(tsModuleBuilder);
                }
                catch (Exception exception) {
                    this.messager().printMessage(Diagnostic.Kind.ERROR, Formatting.formatException(exception), (Element)e);
                    throw new RuntimeException(exception);
                }
            });
            String moduleName = environment.getIncludedElements().stream().filter(element -> Objects.nonNull(element.getAnnotation(TsModule.class))).findFirst().map(element -> element.getAnnotation(TsModule.class).value()).orElse("types");
            File outFile = Paths.get(this.outputDir, moduleName + ".d.ts").toFile();
            try {
                Files.createDirectories(outFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e2) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, Formatting.formatException(e2));
                throw new RuntimeException(e2);
            }
            try (PrintWriter writer = new PrintWriter(outFile);){
                writer.print("// Minimum TypeScript Version: 4.3\n");
                writer.print("// Generated using " + this.getClass().getCanonicalName() + "\n");
                writer.print(tsModuleBuilder.build().emit());
            }
        }
        catch (Exception e3) {
            this.messager().printMessage(Diagnostic.Kind.ERROR, Formatting.formatException(e3));
            throw new RuntimeException(e3);
        }
        return true;
    }

    @Override
    public TsDoc getDocs(Element element) {
        DocCommentTree tree;
        TreePath path = this.env.getDocTrees().getPath(element);
        if (Objects.nonNull(path) && Objects.nonNull(tree = this.env.getDocTrees().getDocCommentTree(path))) {
            Optional<DocCommentTree> docCommentTree = Optional.ofNullable(path).map(treePath -> this.env.getDocTrees().getDocCommentTree(path));
            return docCommentTree.map(doctree -> TsDoc.of(doctree.accept(new TsDocTreeVisitor(this, this.env), element))).orElse(TsDoc.empty());
        }
        return TsDoc.empty();
    }

    @Override
    public Types types() {
        return this.env.getTypeUtils();
    }

    @Override
    public Elements elements() {
        return this.env.getElementUtils();
    }

    @Override
    public LogWrapper messager() {
        return this.logWrapper;
    }
}

