/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;

public class Formatting {
    public static final String INDENT = "\t";
    public static final String NONE = "";
    public static final String NEW_LINE = "\n";
    public static final String SPACE = " ";
    public static final String END_LINE = ";";
    public static final String COMMA = ", ";

    public static String optionalln(Collection<?> list) {
        return Formatting.optionalAffix(NEW_LINE, list);
    }

    public static String optionalAffix(String affix, Collection<?> list) {
        return list.size() > 0 ? affix : NONE;
    }

    public static String capitalizeFirstLetter(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String lowerFirstLetter(String input) {
        if (input.length() > 1) {
            return input.substring(0, 1).toLowerCase() + input.substring(1);
        }
        return input.toLowerCase();
    }

    public static String formatException(Exception e) {
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        return out.getBuffer().toString();
    }

    public static String nonGetSetName(String originalName) {
        if (originalName.startsWith("get") || originalName.startsWith("set") && originalName.length() > 3) {
            return Formatting.lowerFirstLetter(originalName.substring(3));
        }
        if (originalName.startsWith("is") && originalName.length() > 2) {
            return Formatting.lowerFirstLetter(originalName.substring(2));
        }
        return originalName;
    }

    public static String resolveNameOr(String original, String alternative) {
        return Arrays.stream(SpecialNames.values()).filter(specialNames -> specialNames.specialName.equals(original)).findFirst().map(specialNames -> specialNames.fix(original)).orElse(alternative);
    }

    public static String resolveName(String original) {
        return Formatting.resolveNameOr(original, original);
    }

    public static enum SpecialNames {
        function("function", s2 -> "func"),
        star("*", s2 -> "any"),
        questionMark("?", s2 -> "any");

        private String specialName;
        private NameFix keywordFix;

        private SpecialNames(String specialName, NameFix nameFix) {
            this.specialName = specialName;
            this.keywordFix = nameFix;
        }

        public String fix(String original) {
            return this.keywordFix.apply(original);
        }

        public static interface NameFix {
            public String apply(String var1);
        }
    }
}

