/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.builders;

import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.TsElement;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ProcessorType {
    private final TypeMirror type;
    private HasProcessorEnv env;

    public ProcessorType(TypeMirror type, HasProcessorEnv env) {
        this.type = type;
        this.env = env;
    }

    public static ProcessorType of(TypeMirror typeMirror, HasProcessorEnv env) {
        return new ProcessorType(typeMirror, env);
    }

    public boolean isPrimitive() {
        return this.type.getKind().isPrimitive();
    }

    public boolean isPrimitiveArray() {
        return this.isArray() && ProcessorType.of(this.arrayComponentType(), this.env).isPrimitive() || this.isPrimitive2dArray();
    }

    private boolean isPrimitive2dArray() {
        return this.is2dArray() && ProcessorType.of(this.arrayComponentType(), this.env).isPrimitiveArray();
    }

    public boolean isArray() {
        return TypeKind.ARRAY.compareTo(this.type.getKind()) == 0;
    }

    public boolean is2dArray() {
        return this.isArray() && ProcessorType.of(this.arrayComponentType(), this.env).isArray();
    }

    public TypeMirror arrayComponentType() {
        return ((ArrayType)this.type).getComponentType();
    }

    public TypeMirror deepArrayComponentType() {
        TypeMirror componentType = ((ArrayType)this.type).getComponentType();
        return ProcessorType.of(componentType, this.env).isArray() ? ProcessorType.of(componentType, this.env).arrayComponentType() : componentType;
    }

    public boolean isCollection() {
        return !this.isPrimitive() && this.isAssignableFrom(Collection.class);
    }

    public boolean isIterable(TypeMirror typeMirror) {
        return !this.isPrimitive() && this.isAssignableFrom(Iterable.class);
    }

    public boolean isAssignableFrom(Class<?> targetClass) {
        return this.env.types().isAssignable(this.type, this.env.types().getDeclaredType(this.env.elements().getTypeElement(targetClass.getCanonicalName()), new TypeMirror[0]));
    }

    public boolean isSet() {
        return this.isAssignableFrom(Set.class);
    }

    public boolean isMap() {
        return !this.isPrimitive() && this.isAssignableFrom(Map.class);
    }

    public boolean isJsFunction() {
        Element element = this.env.types().asElement(this.type);
        return Objects.nonNull(element) && TsElement.of(element, this.env).isJsFunction();
    }

    public boolean isUnionType() {
        Element element = this.env.types().asElement(this.type);
        return Objects.nonNull(element) && TsElement.of(element, this.env).isUnionType();
    }
}

