/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.Formatting;
import com.vertispan.tsdefs.impl.builders.HasDocs;
import com.vertispan.tsdefs.impl.builders.HasParameters;
import com.vertispan.tsdefs.impl.builders.IsClassBuilder;
import com.vertispan.tsdefs.impl.model.IsType;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TsInterface;
import com.vertispan.tsdefs.impl.model.TsMethod;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TsParameter;
import com.vertispan.tsdefs.impl.model.TsProperty;
import com.vertispan.tsdefs.impl.model.TsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TsClass
implements IsType {
    private final String name;
    private final String namespace;
    private TsClass superClass;
    private final List<TsInterface> interfaces = new ArrayList<TsInterface>();
    private final List<TsModifier> modifiers = new ArrayList<TsModifier>();
    private final Set<TsProperty> properties = new LinkedHashSet<TsProperty>();
    private TsConstructor constructor;
    private final Set<TsMethod> functions = new LinkedHashSet<TsMethod>();
    private final List<TsType> typeArguments = new ArrayList<TsType>();
    private TsDoc tsDoc;
    private boolean deprecated;
    private boolean emitProtectedConstructor;
    private TsClassBuilder builder;

    public TsClassBuilder getBuilder() {
        return this.builder;
    }

    private TsClass(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public void mergeWith(TsClass other) {
        this.interfaces.addAll(other.interfaces);
        this.typeArguments.addAll(other.typeArguments);
        this.mergeFunctions(other);
        this.mergeProperties(other);
    }

    public void mergeProperties(TsClass other) {
        this.properties.addAll(other.properties);
    }

    public void mergeFunctions(TsClass other) {
        this.functions.addAll(other.functions);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static TsClassBuilder builder(String name, String namespace) {
        return new TsClassBuilder(name, namespace);
    }

    public static TsConstructor.TsConstructorBuilder constructorBuilder() {
        return new TsConstructor.TsConstructorBuilder();
    }

    public boolean isEmpty() {
        return this.interfaces.isEmpty() && this.properties.isEmpty() && this.functions.isEmpty();
    }

    public String emit(String indent, String parentNamespace) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.tsDoc)) {
            sb.append(this.tsDoc.emit(indent, this.deprecated));
        }
        sb.append(this.modifiers.stream().filter(tsModifier -> TsModifier.READONLY != tsModifier).map(TsModifier::emit).collect(Collectors.joining("")));
        sb.append("class ");
        sb.append(this.emitType(parentNamespace));
        if (Objects.nonNull(this.superClass)) {
            sb.append(" extends " + this.superClass.emitType(parentNamespace));
        }
        if (!this.interfaces.isEmpty()) {
            sb.append(" implements ");
            sb.append(this.interfaces.stream().map(tsInterface -> tsInterface.emitType(parentNamespace)).collect(Collectors.joining(", ")));
        }
        sb.append(" {");
        sb.append(this.properties.stream().map(property -> property.emit(indent + "\t", ";", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.properties), Formatting.optionalln(this.properties))));
        if (Objects.nonNull(this.constructor) && !this.emitProtectedConstructor) {
            sb.append("\n");
            sb.append(this.constructor.emit(indent + "\t", this.namespace));
            sb.append("\n");
        }
        if (this.emitProtectedConstructor) {
            sb.append("\n");
            sb.append(TsConstructor.TsConstructorBuilder.protectedConstructor().emit(indent + "\t", this.namespace));
            sb.append("\n");
        }
        sb.append(this.functions.stream().map(function -> function.emit(indent + "\t", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.functions), Formatting.optionalln(this.functions))));
        sb.append(indent).append("}").append("\n");
        return sb.toString();
    }

    private String emitType(String parentNamespace) {
        StringBuffer sb = new StringBuffer();
        if (this.namespace.equals(parentNamespace) || this.namespace.isEmpty()) {
            sb.append(this.name);
        } else {
            sb.append(this.namespace + "." + this.name);
        }
        if (!this.typeArguments.isEmpty()) {
            sb.append(this.typeArguments.stream().map(tsType -> tsType.emit(this.namespace)).collect(Collectors.joining(", ", "<", ">")));
        }
        return sb.toString();
    }

    public static class TsConstructor {
        private List<TsModifier> modifiers = new ArrayList<TsModifier>();
        private List<TsParameter> parameters = new ArrayList<TsParameter>();
        private TsDoc tsDoc;
        private boolean deprecated;

        private TsConstructor() {
        }

        public String emit(String indent, String parentNamespace) {
            StringBuffer sb = new StringBuffer();
            if (Objects.nonNull(this.tsDoc)) {
                sb.append(this.tsDoc.emit(indent, this.deprecated));
            }
            if (!this.modifiers.isEmpty()) {
                sb.append(indent);
            }
            sb.append(this.modifiers.stream().map(TsModifier::emit).collect(Collectors.joining(" ")));
            sb.append("constructor");
            sb.append("(");
            sb.append(this.parameters.stream().map(parameter -> parameter.emit("", "", parentNamespace)).collect(Collectors.joining(", ")));
            sb.append(");");
            return sb.toString();
        }

        public static class TsConstructorBuilder
        implements HasParameters<TsConstructorBuilder>,
        HasDocs<TsConstructorBuilder> {
            private final TsConstructor constructor = new TsConstructor();

            private TsConstructorBuilder() {
            }

            public TsConstructorBuilder addModifiers(TsModifier ... modifiers) {
                this.constructor.modifiers.addAll(Arrays.asList(modifiers));
                return this;
            }

            @Override
            public TsConstructorBuilder addParameter(TsParameter parameter) {
                this.constructor.parameters.add(parameter);
                return this;
            }

            @Override
            public TsConstructorBuilder setDocs(TsDoc tsDoc) {
                this.constructor.tsDoc = tsDoc;
                return this;
            }

            public TsConstructorBuilder setDeprecated(boolean deprecated) {
                this.constructor.deprecated = deprecated;
                return this;
            }

            private static TsConstructor protectedConstructor() {
                return new TsConstructorBuilder().addModifiers(TsModifier.PROTECTED).build();
            }

            public TsConstructor build() {
                return this.constructor;
            }
        }
    }

    public static class TsClassBuilder
    implements IsClassBuilder<TsClassBuilder> {
        private final TsClass tsClass;

        private TsClassBuilder(String name, String namespace) {
            this.tsClass = new TsClass(name, namespace);
            this.tsClass.builder = this;
        }

        public TsClassBuilder addModifiers(TsModifier ... modifiers) {
            this.tsClass.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        public TsClassBuilder superClass(TsClass superClass) {
            this.tsClass.superClass = superClass;
            return this;
        }

        @Override
        public TsClassBuilder addProperty(TsProperty property) {
            this.tsClass.properties.add(property);
            return this;
        }

        @Override
        public TsClassBuilder setConstructor(TsConstructor constructor) {
            this.tsClass.constructor = constructor;
            return this;
        }

        @Override
        public TsClassBuilder addFunction(TsMethod function) {
            this.tsClass.functions.add(function);
            return this;
        }

        @Override
        public TsClassBuilder addTypeArgument(TsType typeArgument) {
            this.tsClass.typeArguments.add(typeArgument);
            return this;
        }

        @Override
        public TsClassBuilder addInterface(TsInterface tsInterface) {
            this.tsClass.interfaces.add(tsInterface);
            return this;
        }

        @Override
        public TsClassBuilder setDocs(TsDoc tsDoc) {
            this.tsClass.tsDoc = tsDoc;
            return this;
        }

        public TsClassBuilder setDeprecated(boolean deprecated) {
            this.tsClass.deprecated = deprecated;
            return this;
        }

        public TsClassBuilder setEmitProtectedContr(boolean emit) {
            this.tsClass.emitProtectedConstructor = emit;
            return this;
        }

        public TsClass build() {
            return this.tsClass;
        }
    }
}

