/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.builders.HasDocs;
import com.vertispan.tsdefs.impl.builders.HasFunctions;
import com.vertispan.tsdefs.impl.builders.HasNamespace;
import com.vertispan.tsdefs.impl.model.TsClass;
import com.vertispan.tsdefs.impl.model.TsCustomType;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TsMethod;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TsProperty;
import com.vertispan.tsdefs.impl.model.TsType;
import com.vertispan.tsdefs.impl.model.TsVariable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class TsEnum
implements HasNamespace {
    private final String name;
    private final String namespace;
    private TsCustomType type;
    private final Set<TsModifier> modifiers = new LinkedHashSet<TsModifier>();
    private final Set<String> enumerations = new LinkedHashSet<String>();
    private final Set<TsMethod> functions = new LinkedHashSet<TsMethod>();
    private TsDoc tsDoc;
    private boolean deprecated;

    private TsEnum(String name, String namespace, TsCustomType type) {
        this.name = name;
        this.namespace = namespace;
        this.type = type;
    }

    public static TsEnumBuilder builder(String name, String namespace, TsCustomType type) {
        return new TsEnumBuilder(name, namespace, type);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public TsType getType() {
        return this.type;
    }

    public String emit(String indent, String parentNamespace) {
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.tsDoc)) {
            sb.append(this.tsDoc.emit(indent, this.deprecated));
        }
        sb.append(this.type.emitType(indent, parentNamespace));
        sb.append("\n");
        TsClass.TsClassBuilder classBuilder = TsClass.builder(this.name, this.namespace).addModifiers(TsModifier.EXPORT).setDocs(TsDoc.empty());
        this.enumerations.stream().map(enumeration -> (TsProperty)((TsVariable.TsPropertyBuilder)TsProperty.builder(enumeration, TsType.of(this.type.name)).setDocs(TsDoc.empty())).addModifiers(TsModifier.STATIC, TsModifier.READONLY).build()).forEach(classBuilder::addProperty);
        this.functions.forEach(classBuilder::addFunction);
        sb.append(classBuilder.build().emit(indent, parentNamespace));
        return sb.toString();
    }

    public static class TsEnumBuilder
    implements HasDocs<TsEnumBuilder>,
    HasFunctions<TsEnumBuilder> {
        private final TsEnum tsEnum;

        private TsEnumBuilder(String name, String namespace, TsCustomType type) {
            this.tsEnum = new TsEnum(name, namespace, type);
        }

        public TsEnumBuilder addEnumeration(String name) {
            this.tsEnum.enumerations.add(name);
            return this;
        }

        public TsEnumBuilder addModifiers(TsModifier ... modifiers) {
            this.tsEnum.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        @Override
        public TsEnumBuilder setDocs(TsDoc tsDoc) {
            this.tsEnum.tsDoc = tsDoc;
            return this;
        }

        public TsEnumBuilder setDeprecated(boolean deprecated) {
            this.tsEnum.deprecated = deprecated;
            return this;
        }

        @Override
        public TsEnumBuilder addFunction(TsMethod function) {
            this.tsEnum.functions.add(function);
            return this;
        }

        public TsEnum build() {
            return this.tsEnum;
        }
    }
}

