/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.builders.HasParameters;
import com.vertispan.tsdefs.impl.model.TsParameter;
import com.vertispan.tsdefs.impl.model.TsType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsInlinedFunctionType
extends TsType
implements HasParameters<TsInlinedFunctionType> {
    private List<TsParameter> parameters = new ArrayList<TsParameter>();
    private TsType returnType;

    public TsInlinedFunctionType() {
        super("", "");
    }

    @Override
    public TsInlinedFunctionType addParameter(TsParameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public TsType getReturnType() {
        return this.returnType;
    }

    public TsInlinedFunctionType setReturnType(TsType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    public String emit(String parentNamespace) {
        return "(" + this.emitParameters() + ")=>" + this.returnType.emit("");
    }

    private String emitParameters() {
        return this.parameters.stream().map(parameter -> parameter.emit("", "", "")).collect(Collectors.joining(","));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TsInlinedFunctionType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsInlinedFunctionType that = (TsInlinedFunctionType)o;
        return Objects.equals(this.parameters, that.parameters) && Objects.equals(this.getReturnType(), that.getReturnType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parameters, this.getReturnType());
    }
}

