/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.Formatting;
import com.vertispan.tsdefs.impl.builders.HasDocs;
import com.vertispan.tsdefs.impl.builders.HasInterfaces;
import com.vertispan.tsdefs.impl.builders.HasMembers;
import com.vertispan.tsdefs.impl.builders.HasTypeArguments;
import com.vertispan.tsdefs.impl.model.IsType;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TsMethod;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TsProperty;
import com.vertispan.tsdefs.impl.model.TsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsInterface
implements IsType {
    private String name;
    private String namespace;
    private List<TsModifier> modifiers = new ArrayList<TsModifier>();
    private List<TsProperty> properties = new ArrayList<TsProperty>();
    private List<TsMethod> jsFunctions = new ArrayList<TsMethod>();
    private List<TsType> typeArguments = new ArrayList<TsType>();
    private List<TsInterface> interfaces = new ArrayList<TsInterface>();
    private TsDoc tsDoc;
    private boolean deprecated;
    private TsInterfaceBuilder builder;

    public TsInterfaceBuilder getBuilder() {
        return this.builder;
    }

    public String emit(String indent, String parentNamespace) {
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.tsDoc)) {
            sb.append(this.tsDoc.emit(indent, this.deprecated));
        }
        sb.append(this.modifiers.stream().map(TsModifier::emit).collect(Collectors.joining(" ")));
        sb.append("interface ");
        sb.append(this.emitType(parentNamespace));
        if (!this.interfaces.isEmpty()) {
            sb.append(" extends ");
            sb.append(this.interfaces.stream().map(tsInterface -> tsInterface.emitType(parentNamespace)).collect(Collectors.joining(", ")));
        }
        sb.append(" {");
        sb.append(this.properties.stream().map(property -> property.emit(indent + "\t", ";", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.properties), Formatting.optionalln(this.properties))));
        sb.append(this.jsFunctions.stream().map(function -> function.emit(indent + "\t", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.jsFunctions), Formatting.optionalln(this.jsFunctions))));
        sb.append(indent);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String emitType(String parentNamespace) {
        StringBuffer sb = new StringBuffer();
        if (this.getNamespace().equals(parentNamespace) || this.namespace.isEmpty()) {
            sb.append(this.name);
        } else {
            sb.append(this.namespace + "." + this.name);
        }
        if (!this.typeArguments.isEmpty()) {
            sb.append(this.typeArguments.stream().map(tsType -> tsType.emit(this.namespace)).collect(Collectors.joining(", ", "<", ">")));
        }
        return sb.toString();
    }

    public static TsInterfaceBuilder builder(String name, String namespace) {
        return new TsInterfaceBuilder(name, namespace);
    }

    private TsInterface(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public static class TsInterfaceBuilder
    implements HasMembers<TsInterfaceBuilder>,
    HasTypeArguments<TsInterfaceBuilder>,
    HasInterfaces<TsInterfaceBuilder>,
    HasDocs<TsInterfaceBuilder> {
        private TsInterface tsInterface;

        private TsInterfaceBuilder(String name, String namespace) {
            this.tsInterface = new TsInterface(name, namespace);
            this.tsInterface.builder = this;
        }

        public TsInterfaceBuilder addModifiers(TsModifier ... modifiers) {
            this.tsInterface.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        @Override
        public TsInterfaceBuilder addFunction(TsMethod function) {
            this.tsInterface.jsFunctions.add(function);
            return this;
        }

        @Override
        public TsInterfaceBuilder addProperty(TsProperty property) {
            this.tsInterface.properties.add(property);
            return this;
        }

        @Override
        public TsInterfaceBuilder addTypeArgument(TsType typeArgument) {
            this.tsInterface.typeArguments.add(typeArgument);
            return this;
        }

        @Override
        public TsInterfaceBuilder addInterface(TsInterface tsInterface) {
            this.tsInterface.interfaces.add(tsInterface);
            return this;
        }

        @Override
        public TsInterfaceBuilder setDocs(TsDoc tsDoc) {
            this.tsInterface.tsDoc = tsDoc;
            return this;
        }

        public TsInterfaceBuilder setDeprecated(boolean deprecated) {
            this.tsInterface.deprecated = deprecated;
            return this;
        }

        public TsInterface build() {
            return this.tsInterface;
        }
    }
}

