/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.builders.HasDocs;
import com.vertispan.tsdefs.impl.builders.HasParameters;
import com.vertispan.tsdefs.impl.builders.HasTypeArguments;
import com.vertispan.tsdefs.impl.model.NoneTsType;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TsParameter;
import com.vertispan.tsdefs.impl.model.TsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsMethod {
    private final String name;
    private final TsType returnType;
    private final List<TsParameter> parameters = new ArrayList<TsParameter>();
    private final List<TsModifier> modifiers = new ArrayList<TsModifier>();
    private List<TsType> typeArguments = new ArrayList<TsType>();
    private TsDoc tsDoc;
    private boolean deprecated;

    public String getName() {
        return this.name;
    }

    private TsMethod(String name, TsType returnType) {
        this.name = name;
        this.returnType = returnType;
    }

    private TsMethod(String name) {
        this.name = name;
        this.returnType = new NoneTsType();
    }

    public static TsMethodBuilder builder(String name) {
        return new TsMethodBuilder(name);
    }

    public static TsMethodBuilder builder(String name, TsType returnType) {
        return new TsMethodBuilder(name, returnType);
    }

    public String emit(String indent, String parentNamespace) {
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.tsDoc)) {
            sb.append(this.tsDoc.emit(indent, this.deprecated));
        }
        sb.append(this.modifiers.stream().filter(tsModifier -> TsModifier.READONLY != tsModifier).map(TsModifier::emit).collect(Collectors.joining("")));
        sb.append(this.name);
        if (!this.typeArguments.isEmpty()) {
            sb.append(this.typeArguments.stream().map(tsType -> tsType.emit(parentNamespace)).collect(Collectors.joining(", ", "<", ">")));
        }
        sb.append("(");
        sb.append(this.parameters.stream().map(parameter -> parameter.emit(parentNamespace)).collect(Collectors.joining(", ")));
        sb.append(")");
        if (!(this.returnType instanceof NoneTsType)) {
            sb.append(":");
            sb.append(this.returnType.emit(parentNamespace));
        }
        sb.append(";");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TsMethod)) {
            return false;
        }
        TsMethod tsMethod = (TsMethod)o;
        return Objects.equals(this.getName(), tsMethod.getName()) && Objects.equals(this.returnType, tsMethod.returnType) && this.parameters.equals(tsMethod.parameters) && this.modifiers.equals(tsMethod.modifiers);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.returnType, this.parameters, this.modifiers);
    }

    public static class TsMethodBuilder
    implements HasParameters<TsMethodBuilder>,
    HasDocs<TsMethodBuilder>,
    HasTypeArguments<TsMethodBuilder> {
        private final TsMethod method;

        private TsMethodBuilder(String name, TsType returnType) {
            this.method = new TsMethod(name, returnType);
        }

        private TsMethodBuilder(String name) {
            this.method = new TsMethod(name);
        }

        @Override
        public TsMethodBuilder addParameter(TsParameter parameter) {
            this.method.parameters.add(parameter);
            return this;
        }

        public TsMethodBuilder addModifiers(TsModifier ... modifiers) {
            this.method.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        @Override
        public TsMethodBuilder setDocs(TsDoc tsDoc) {
            this.method.tsDoc = tsDoc;
            return this;
        }

        public TsMethodBuilder setDeprecated(boolean deprecated) {
            this.method.deprecated = deprecated;
            return this;
        }

        @Override
        public TsMethodBuilder addTypeArgument(TsType typeArgument) {
            this.method.typeArguments.add(typeArgument);
            return this;
        }

        public TsMethod build() {
            return this.method;
        }
    }
}

