/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.Formatting;
import com.vertispan.tsdefs.impl.model.TsClass;
import com.vertispan.tsdefs.impl.model.TsEnum;
import com.vertispan.tsdefs.impl.model.TsFunction;
import com.vertispan.tsdefs.impl.model.TsInterface;
import com.vertispan.tsdefs.impl.model.TsModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class TsNamespace {
    private final String namespace;
    private List<TsInterface> tsInterfaces = new ArrayList<TsInterface>();
    private List<TsFunction> tsFunctions = new ArrayList<TsFunction>();
    private List<TsClass> tsClasses = new ArrayList<TsClass>();
    private List<TsEnum> tsEnums = new ArrayList<TsEnum>();

    public TsNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void addClass(TsClass tsClass) {
        Optional<TsClass> first = this.tsClasses.stream().filter(c -> c.getName().equals(tsClass.getName())).findFirst();
        if (first.isPresent()) {
            first.get().mergeWith(tsClass);
        } else {
            this.tsClasses.add(tsClass);
        }
    }

    public void addInterface(TsInterface tsInterface) {
        this.tsInterfaces.add(tsInterface);
    }

    public void addFunction(TsFunction tsFunction) {
        this.tsFunctions.add(tsFunction);
    }

    public void addTsEnum(TsEnum tsEnum) {
        this.tsEnums.add(tsEnum);
    }

    public boolean isEmpty() {
        return this.tsInterfaces.isEmpty() && this.tsFunctions.isEmpty() && this.tsEnums.isEmpty() && (this.tsClasses.isEmpty() || this.tsClasses.stream().allMatch(TsClass::isEmpty));
    }

    public String emit(String indent, String parentNamespace) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(indent);
        sb.append(TsModifier.EXPORT.emit());
        sb.append(TsModifier.NAMESPACE.emit());
        if (Objects.nonNull(parentNamespace) && !parentNamespace.isEmpty()) {
            sb.append(parentNamespace);
            sb.append(".");
        }
        sb.append(this.namespace);
        sb.append(" {");
        sb.append("\n");
        sb.append(this.tsFunctions.stream().map(tsFunction -> tsFunction.emit(indent + "\t", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.tsFunctions), Formatting.optionalln(this.tsFunctions))));
        sb.append(this.tsInterfaces.stream().map(tsInterface -> tsInterface.emit(indent + "\t", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.tsInterfaces), Formatting.optionalln(this.tsInterfaces))));
        sb.append(this.tsClasses.stream().map(tsClass -> tsClass.emit(indent + "\t", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.tsClasses), Formatting.optionalln(this.tsClasses))));
        sb.append(this.tsEnums.stream().map(tsEnum -> tsEnum.emit(indent + "\t", this.namespace)).collect(Collectors.joining("\n", Formatting.optionalln(this.tsEnums), Formatting.optionalln(this.tsEnums))));
        sb.append("}").append("\n");
        return sb.toString();
    }

    public Optional<TsClass.TsClassBuilder> findClass(String name) {
        return this.tsClasses.stream().filter(tsClass -> tsClass.getName().equals(name)).map(TsClass::getBuilder).findFirst();
    }

    public Optional<TsInterface.TsInterfaceBuilder> findInterface(String name) {
        return this.tsInterfaces.stream().filter(tsInterface -> tsInterface.getName().equals(name)).map(TsInterface::getBuilder).findFirst();
    }
}

