/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.model.TsType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TsUnionType
extends TsType {
    private final Set<TsType> tsTypes;

    public TsUnionType(Collection<TsType> tsTypes) {
        super("", "");
        this.tsTypes = tsTypes.stream().flatMap(type -> {
            if (type instanceof TsUnionType) {
                return ((TsUnionType)type).tsTypes.stream();
            }
            return Stream.of(type);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static TsUnionType of(TsType ... types) {
        return new TsUnionType(new HashSet<TsType>(Arrays.asList(types)));
    }

    public static TsUnionType of(Set<TsType> types) {
        return new TsUnionType(types);
    }

    @Override
    public String emit(String parentNamespace) {
        return this.tsTypes.stream().map(tsType -> tsType.emit(parentNamespace)).collect(Collectors.joining("|"));
    }
}

