/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.Formatting;
import com.vertispan.tsdefs.impl.builders.Deprecation;
import com.vertispan.tsdefs.impl.builders.HasDocs;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class TsVariable {
    protected final String name;
    protected final TsType type;
    protected TsDoc tsDoc;
    protected boolean jsOptional;
    protected boolean deprecated;
    protected boolean varargs = false;
    protected List<TsModifier> modifiers = new ArrayList<TsModifier>();

    protected TsVariable(String name, TsType type) {
        this.name = name;
        this.type = type;
    }

    public abstract String emit(String var1, String var2, String var3);

    protected String emit(String indent, String ending, String parentNamespace, boolean skipModifiers) {
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.tsDoc)) {
            sb.append(this.tsDoc.emit(indent, this.deprecated));
        } else if (this.deprecated) {
            sb.append(Deprecation.emit(indent));
        }
        if (!skipModifiers) {
            sb.append(this.modifiers.stream().map(TsModifier::emit).collect(Collectors.joining("", "", "")));
        }
        if (this.varargs) {
            sb.append("...");
        }
        sb.append(Formatting.resolveName(this.name));
        if (this.jsOptional) {
            sb.append("?");
        }
        sb.append(":");
        sb.append(this.emitType(parentNamespace));
        sb.append(ending);
        return sb.toString();
    }

    public abstract String emitType(String var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TsVariable)) {
            return false;
        }
        TsVariable that = (TsVariable)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class TsPropertyBuilder<T extends TsVariable>
    implements HasDocs<TsPropertyBuilder<T>> {
        private final T property;

        public TsPropertyBuilder(T property) {
            this.property = property;
        }

        public TsPropertyBuilder<T> addModifiers(TsModifier ... modifiers) {
            ((TsVariable)this.property).modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        @Override
        public TsPropertyBuilder<T> setDocs(TsDoc tsDoc) {
            ((TsVariable)this.property).tsDoc = tsDoc;
            return this;
        }

        public TsPropertyBuilder<T> setOptional(boolean optional) {
            ((TsVariable)this.property).jsOptional = optional;
            return this;
        }

        public TsPropertyBuilder<T> setDeprecated(boolean deprecated) {
            ((TsVariable)this.property).deprecated = deprecated;
            return this;
        }

        public TsPropertyBuilder<T> setVarargs(boolean varargs) {
            ((TsVariable)this.property).varargs = varargs;
            return this;
        }

        public T build() {
            return this.property;
        }
    }
}

