/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.model;

import com.vertispan.tsdefs.impl.Formatting;
import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.HasMembers;
import com.vertispan.tsdefs.impl.builders.TsElement;
import com.vertispan.tsdefs.impl.model.TsClass;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TsEnum;
import com.vertispan.tsdefs.impl.model.TsFunction;
import com.vertispan.tsdefs.impl.model.TsInterface;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TsNamespace;
import com.vertispan.tsdefs.impl.visitors.FixedNsClassMethodVisitor;
import com.vertispan.tsdefs.impl.visitors.FixedNsFieldVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public class TypeScriptModule {
    private Map<String, TsNamespace> namespaces = new HashMap<String, TsNamespace>();
    private List<TsInterface> globalInterfaces = new ArrayList<TsInterface>();
    private List<TsFunction> globalFunctions = new ArrayList<TsFunction>();
    private List<TsClass> globalClasses = new ArrayList<TsClass>();
    private List<TsEnum> globalEnums = new ArrayList<TsEnum>();
    private final HasProcessorEnv env;

    public TypeScriptModule(HasProcessorEnv env) {
        this.env = env;
    }

    public String emit() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.globalInterfaces.stream().map(tsInterface -> tsInterface.emit("", "")).collect(Collectors.joining("\n", Formatting.optionalln(this.globalInterfaces), Formatting.optionalln(this.globalInterfaces))));
        sb.append(this.globalFunctions.stream().map(tsFunction -> tsFunction.emit("", "")).collect(Collectors.joining("\n", Formatting.optionalln(this.globalFunctions), Formatting.optionalln(this.globalFunctions))));
        sb.append(this.globalEnums.stream().map(tsEnum -> tsEnum.emit("", "")).collect(Collectors.joining("\n", Formatting.optionalln(this.globalEnums), Formatting.optionalln(this.globalEnums))));
        sb.append(this.globalClasses.stream().map(tsClass -> tsClass.emit("", "")).collect(Collectors.joining("\n", Formatting.optionalln(this.globalClasses), Formatting.optionalln(this.globalClasses))));
        sb.append(this.namespaces.values().stream().map(namespace -> namespace.emit("", "")).collect(Collectors.joining("\n", Formatting.optionalln(this.globalClasses), Formatting.optionalln(this.globalClasses))));
        return sb.toString();
    }

    public static TsModuleBuilder builder(HasProcessorEnv env) {
        return new TsModuleBuilder(env);
    }

    public static class TsModuleBuilder {
        private final TypeScriptModule typeScriptModule;

        private TsModuleBuilder(HasProcessorEnv env) {
            this.typeScriptModule = new TypeScriptModule(env);
        }

        public TsModuleBuilder addInterface(TsInterface tsInterface) {
            if (tsInterface.isGlobal()) {
                this.typeScriptModule.globalInterfaces.add(tsInterface);
            } else {
                if (!this.typeScriptModule.namespaces.containsKey(tsInterface.getNamespace())) {
                    this.typeScriptModule.namespaces.put(tsInterface.getNamespace(), new TsNamespace(tsInterface.getNamespace()));
                }
                this.typeScriptModule.namespaces.get(tsInterface.getNamespace()).addInterface(tsInterface);
            }
            return this;
        }

        public TsModuleBuilder addFunction(TsFunction tsFunction) {
            if (tsFunction.isGlobal()) {
                this.typeScriptModule.globalFunctions.add(tsFunction);
            } else {
                if (!this.typeScriptModule.namespaces.containsKey(tsFunction.getNamespace())) {
                    this.typeScriptModule.namespaces.put(tsFunction.getNamespace(), new TsNamespace(tsFunction.getNamespace()));
                }
                this.typeScriptModule.namespaces.get(tsFunction.getNamespace()).addFunction(tsFunction);
            }
            return this;
        }

        public TsModuleBuilder addClass(TsClass tsClass) {
            if (tsClass.isGlobal()) {
                this.typeScriptModule.globalClasses.add(tsClass);
            } else {
                if (!this.typeScriptModule.namespaces.containsKey(tsClass.getNamespace())) {
                    this.typeScriptModule.namespaces.put(tsClass.getNamespace(), new TsNamespace(tsClass.getNamespace()));
                }
                this.typeScriptModule.namespaces.get(tsClass.getNamespace()).addClass(tsClass);
            }
            return this;
        }

        public TsModuleBuilder addTsEnum(TsEnum tsEnum) {
            if (tsEnum.isGlobal()) {
                this.typeScriptModule.globalEnums.add(tsEnum);
            } else {
                if (!this.typeScriptModule.namespaces.containsKey(tsEnum.getNamespace())) {
                    this.typeScriptModule.namespaces.put(tsEnum.getNamespace(), new TsNamespace(tsEnum.getNamespace()));
                }
                this.typeScriptModule.namespaces.get(tsEnum.getNamespace()).addTsEnum(tsEnum);
            }
            return this;
        }

        public Optional<TsClass.TsClassBuilder> findClass(String namespace, String name) {
            if (!this.typeScriptModule.namespaces.containsKey(namespace)) {
                return Optional.empty();
            }
            return this.typeScriptModule.namespaces.get(namespace).findClass(name);
        }

        public Optional<TsInterface.TsInterfaceBuilder> findInterface(String namespace, String name) {
            if (!this.typeScriptModule.namespaces.containsKey(namespace)) {
                return Optional.empty();
            }
            return this.typeScriptModule.namespaces.get(namespace).findInterface(name);
        }

        public TsClass.TsClassBuilder createTypeBuilder(String namespace, String name) {
            TsClass.TsClassBuilder typeBuilder = TsClass.builder(name, namespace).addModifiers(TsModifier.EXPORT).setDocs(TsDoc.empty());
            return typeBuilder;
        }

        public TypeScriptModule build() {
            return this.typeScriptModule;
        }

        public void addToNewType(String namespace, String name, List<TsElement> tsElements) {
            TsClass.TsClassBuilder typeBuilder = this.createTypeBuilder(namespace, name);
            tsElements.forEach(tsElement -> this.visitFixedNs(namespace, typeBuilder, tsElement.element()));
            this.addClass(typeBuilder.build());
        }

        private void visitFixedNs(String namespace, HasMembers<?> builder, Element enclosedElement) {
            new FixedNsFieldVisitor(namespace, enclosedElement, this.typeScriptModule.env).visit(builder);
            new FixedNsClassMethodVisitor(namespace, enclosedElement, this.typeScriptModule.env).visit(builder);
        }
    }
}

