/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.visitors;

import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.HasFunctions;
import com.vertispan.tsdefs.impl.builders.TsElement;
import com.vertispan.tsdefs.impl.model.TsDoc;
import com.vertispan.tsdefs.impl.model.TsMethod;
import com.vertispan.tsdefs.impl.visitors.MethodTypeArgumentsVisitor;
import com.vertispan.tsdefs.impl.visitors.ParameterVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class ClassMethodVisitor<T>
extends TsElement {
    private final boolean copyDocs;

    public ClassMethodVisitor(Element element, HasProcessorEnv env) {
        super(element, env);
        this.copyDocs = true;
    }

    public ClassMethodVisitor(Element element, HasProcessorEnv env, boolean copyDocs) {
        super(element, env);
        this.copyDocs = copyDocs;
    }

    public void visit(HasFunctions<T> parent) {
        if (this.isMethod() && !this.isIgnored() && !this.isOverlay() && !this.isJsProperty() && this.isExportable() && !this.isGetter() && !this.isSetter() && (this.isJsMethod() || this.parent().isJsType() && this.isPublic().booleanValue())) {
            TsElement parentElement = TsElement.of(this.element.getEnclosingElement(), this.env);
            if (parentElement.isTsInterface() && parentElement.isInheritedMethod((ExecutableElement)this.element)) {
                return;
            }
            TsMethod.TsMethodBuilder builder = TsMethod.builder(this.getName(), this.getType()).addModifiers(this.getJsModifiers()).setDocs(this.copyDocs ? this.getDocs() : TsDoc.empty()).setDeprecated(this.isDeprecated());
            ExecutableElement executableElement = (ExecutableElement)this.element;
            new MethodTypeArgumentsVisitor<TsMethod.TsMethodBuilder>(executableElement, this.env).visit(builder);
            executableElement.getParameters().forEach(param -> new ParameterVisitor<TsMethod.TsMethodBuilder>((Element)param, this.env).visit(builder));
            parent.addFunction(builder.build());
        }
    }
}

