/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.visitors;

import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.TsElement;
import com.vertispan.tsdefs.impl.model.TsClass;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TypeScriptModule;
import com.vertispan.tsdefs.impl.visitors.ClassMethodVisitor;
import com.vertispan.tsdefs.impl.visitors.ConstructorVisitor;
import com.vertispan.tsdefs.impl.visitors.FieldVisitor;
import com.vertispan.tsdefs.impl.visitors.InheritedMethodsVisitor;
import com.vertispan.tsdefs.impl.visitors.InterfacesVisitor;
import com.vertispan.tsdefs.impl.visitors.SetterGetterMethodsVisitor;
import com.vertispan.tsdefs.impl.visitors.SuperTsInterfaceVisitor;
import com.vertispan.tsdefs.impl.visitors.TypeArgumentsVisitor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ClassTypeVisitor
extends TsElement {
    public ClassTypeVisitor(Element element, HasProcessorEnv env) {
        super(element, env);
    }

    public void visit(TypeScriptModule.TsModuleBuilder moduleBuilder) {
        if (this.isClass() && this.isPublic().booleanValue() && !this.isTsTypeDef() && !this.isTsIgnored()) {
            TsClass.TsClassBuilder builder = TsClass.builder(this.getName(), this.getNamespace()).setDocs(this.getDocs()).setDeprecated(this.isDeprecated()).addModifiers(TsModifier.EXPORT).addModifiers(this.getJsModifiers());
            new TypeArgumentsVisitor<TsClass.TsClassBuilder>(this.element.asType(), this.env).visit(builder);
            this.getSuperClass(this.element).ifPresent(builder::superClass);
            new InterfacesVisitor<TsClass.TsClassBuilder>(this.element, this.env).visit(builder);
            this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(e -> !e.getDeclaredNamespace().isPresent() || e.getNamespace().equals(this.getNamespace()) || e.getDeclaredNamespace().isPresent() && this.isSameNameSpaceAsParent((TsElement)e)).forEach(e -> this.visit(builder, e.element()));
            new InheritedMethodsVisitor<TsClass.TsClassBuilder>(this.element, this.env).visit(builder);
            new SetterGetterMethodsVisitor<TsClass.TsClassBuilder>(this.element, this.env).visit(builder);
            this.getJavaSuperClass().ifPresent(superclass -> new SuperTsInterfaceVisitor<TsClass.TsClassBuilder>((TypeMirror)superclass, this.env).visit(builder));
            TsClass tsClass = builder.build();
            this.getJavaSuperClass().ifPresent(superclass -> this.processSuperClass(tsClass, (TypeMirror)superclass));
            builder.setEmitProtectedContr(this.requiresProtectedConstructor());
            moduleBuilder.addClass(tsClass);
            Map<String, List<TsElement>> withDiffNs = this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(tsElement -> tsElement.getDeclaredNamespace().isPresent()).filter(e -> e.isExportable() && !this.isSameNameSpaceAsParent((TsElement)e)).collect(Collectors.groupingBy(TsElement::getNamespace));
            this.buildTypesFromNamespaces(moduleBuilder, withDiffNs);
        }
    }

    private void processSuperClass(TsClass tsClass, TypeMirror superclass) {
        TsElement superTsElement = TsElement.of(superclass, this.env);
        if (superTsElement.isTsIgnored() || superTsElement.isTsInterface()) {
            this.mergeSuperClass(tsClass, superTsElement);
        }
        superTsElement.getJavaSuperClass().ifPresent(typeMirror -> this.processSuperClass(tsClass, (TypeMirror)typeMirror));
    }

    private void mergeSuperClass(TsClass tsClass, TsElement superTsElement) {
        TsClass.TsClassBuilder superBuilder = TsClass.builder(superTsElement.getName(), superTsElement.getNamespace());
        superTsElement.element().getEnclosedElements().forEach(e -> this.visit(superBuilder, (Element)e));
        TsClass superTsClass = superBuilder.build();
        tsClass.mergeFunctions(superTsClass);
        tsClass.mergeProperties(superTsClass);
    }

    private boolean isSameNameSpaceAsParent(TsElement e) {
        if (e.getDeclaredNamespace().isPresent()) {
            String childNameSpace = e.getDeclaredNamespace().get();
            return childNameSpace.equals(this.getNamespace()) || childNameSpace.equals(e.getNamespace() + "." + e.getName());
        }
        return true;
    }

    private void buildTypesFromNamespaces(TypeScriptModule.TsModuleBuilder moduleBuilder, Map<String, List<TsElement>> withDiffNs) {
        withDiffNs.keySet().forEach(declaredNamespace -> {
            String typeName = this.typeFromDeclaredNamespace((String)declaredNamespace);
            String actualNamespace = this.namespaceFromDeclaredNamespace((String)declaredNamespace);
            moduleBuilder.addToNewType(actualNamespace, typeName, (List)withDiffNs.get(declaredNamespace));
        });
    }

    private String namespaceFromDeclaredNamespace(String declaredNamespace) {
        if (declaredNamespace.contains(".")) {
            return declaredNamespace.substring(0, declaredNamespace.lastIndexOf("."));
        }
        return this.getNamespace();
    }

    private String typeFromDeclaredNamespace(String namespace) {
        if (namespace.contains(".")) {
            return namespace.substring(namespace.lastIndexOf(".") + 1);
        }
        return namespace;
    }

    private void visit(TsClass.TsClassBuilder classBuilder, Element enclosedElement) {
        new ConstructorVisitor<TsClass.TsClassBuilder>(enclosedElement, this.env).visit(classBuilder);
        new FieldVisitor<TsClass.TsClassBuilder>(enclosedElement, this.env).visit(classBuilder);
        new ClassMethodVisitor<TsClass.TsClassBuilder>(enclosedElement, this.env).visit(classBuilder);
    }

    private Optional<TsClass> getSuperClass(Element element) {
        TypeMirror superclass = ((TypeElement)element).getSuperclass();
        if (((TypeElement)this.env.types().asElement(superclass)).getSuperclass().getKind().equals((Object)TypeKind.NONE)) {
            return Optional.empty();
        }
        Element superElement = this.env.types().asElement(superclass);
        TsElement superTsElement = TsElement.of(superElement, this.env);
        if (superTsElement.isExportable() && !superTsElement.isTsInterface() && !superTsElement.isTsIgnored()) {
            TsClass.TsClassBuilder builder = TsClass.builder(superTsElement.getName(), superTsElement.getNamespace());
            new TypeArgumentsVisitor<TsClass.TsClassBuilder>(superclass, this.env).visit(builder);
            return Optional.of(builder.build());
        }
        return this.getSuperClass(superTsElement.element());
    }
}

