/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.visitors;

import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.HasConstructor;
import com.vertispan.tsdefs.impl.builders.TsElement;
import com.vertispan.tsdefs.impl.exception.MultipleConstructorsException;
import com.vertispan.tsdefs.impl.model.TsClass;
import com.vertispan.tsdefs.impl.visitors.ParameterVisitor;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

public class ConstructorVisitor<T>
extends TsElement {
    public ConstructorVisitor(Element element, HasProcessorEnv env) {
        super(element, env);
    }

    @Override
    public String getName() {
        return "constructor";
    }

    public void visit(HasConstructor<T> tsClassBuilder) {
        if (this.isConstructor() && this.isPublic().booleanValue() && Objects.isNull(this.element.getAnnotation(JsIgnore.class)) && (Objects.nonNull(this.element.getAnnotation(JsConstructor.class)) || Objects.nonNull(this.element.getEnclosingElement().getAnnotation(JsType.class)))) {
            TsClass.TsConstructor.TsConstructorBuilder constructor = TsClass.constructorBuilder().addModifiers(this.getJsModifiers()).setDocs(this.getDocs()).setDeprecated(this.isDeprecated());
            ExecutableElement executableElement = (ExecutableElement)this.element;
            executableElement.getParameters().forEach(param -> new ParameterVisitor<TsClass.TsConstructor.TsConstructorBuilder>((Element)param, this.env).visit(constructor));
            try {
                tsClassBuilder.setConstructor(constructor.build());
            }
            catch (MultipleConstructorsException e) {
                this.env.messager().printMessage(Diagnostic.Kind.ERROR, "Multiple constructors are not allowed", this.element);
            }
        }
    }
}

