/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.visitors;

import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.HasInterfaces;
import com.vertispan.tsdefs.impl.builders.IsClassBuilder;
import com.vertispan.tsdefs.impl.builders.TsElement;
import com.vertispan.tsdefs.impl.model.TsInterface;
import com.vertispan.tsdefs.impl.visitors.TypeArgumentsVisitor;
import javax.lang.model.type.TypeMirror;

public class SuperTsInterfaceVisitor<T>
extends TsElement {
    private final TypeMirror type;

    public SuperTsInterfaceVisitor(TypeMirror typeMirror, HasProcessorEnv env) {
        super(typeMirror, env);
        this.type = typeMirror;
    }

    public void visit(IsClassBuilder<T> builder) {
        if (this.isTsInterface()) {
            this.addInterface(builder, this.type);
        } else {
            this.getJavaSuperClass().ifPresent(typeMirror -> new SuperTsInterfaceVisitor<T>((TypeMirror)typeMirror, this.env).visit(builder));
        }
    }

    private void addInterface(HasInterfaces<T> builder, TypeMirror typeMirror) {
        TsElement tsElement = TsElement.of(typeMirror, this.env);
        if (!tsElement.isTsIgnored()) {
            TsInterface.TsInterfaceBuilder interfaceBuilder = TsInterface.builder(tsElement.getName(), tsElement.getNamespace());
            new TypeArgumentsVisitor<TsInterface.TsInterfaceBuilder>(typeMirror, this.env).visit(interfaceBuilder);
            builder.addInterface(interfaceBuilder.build());
        }
    }
}

