/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.visitors;

import com.vertispan.tsdefs.annotations.TsTypeDef;
import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.TsElement;
import com.vertispan.tsdefs.impl.model.TsCustomType;
import com.vertispan.tsdefs.impl.model.TsEnum;
import com.vertispan.tsdefs.impl.model.TsModifier;
import com.vertispan.tsdefs.impl.model.TsType;
import com.vertispan.tsdefs.impl.model.TypeScriptModule;
import com.vertispan.tsdefs.impl.visitors.ClassMethodVisitor;
import java.util.Objects;
import javax.lang.model.element.Element;

public class TsEnumTypeVisitor
extends TsElement {
    public TsEnumTypeVisitor(Element element, HasProcessorEnv env) {
        super(element, env);
    }

    public void visit(TypeScriptModule.TsModuleBuilder moduleBuilder) {
        if (this.isClass() && this.isPublic().booleanValue() && this.isTsTypeDef()) {
            TsEnum.TsEnumBuilder builder = TsEnum.builder(this.getName(), this.getNamespace(), (TsCustomType)this.getType()).setDocs(this.getDocs()).setDeprecated(this.isDeprecated()).addModifiers(TsModifier.EXPORT);
            this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).forEach(e -> {
                if (e.isStatic().booleanValue() && e.isPublic().booleanValue() && e.isField() && e.isFinal().booleanValue()) {
                    builder.addEnumeration(e.getName());
                } else {
                    new ClassMethodVisitor<TsEnum.TsEnumBuilder>(e.element(), this.env).visit(builder);
                }
            });
            moduleBuilder.addTsEnum(builder.build());
        }
    }

    @Override
    public TsType getType() {
        TsTypeDef tsTypeDef = this.element.getAnnotation(TsTypeDef.class);
        if (Objects.nonNull(tsTypeDef.name()) && !tsTypeDef.name().trim().isEmpty() && !"<auto>".equals(tsTypeDef.name())) {
            return TsCustomType.of(tsTypeDef.name(), this.getNamespace(), TsType.of(tsTypeDef.tsType()));
        }
        return TsCustomType.of(this.getName() + "Type", this.getNamespace(), TsType.of(tsTypeDef.tsType()));
    }
}

