/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.impl.visitors;

import com.vertispan.tsdefs.impl.HasProcessorEnv;
import com.vertispan.tsdefs.impl.builders.TsElement;
import com.vertispan.tsdefs.impl.model.TypeScriptModule;
import com.vertispan.tsdefs.impl.visitors.ClassTypeVisitor;
import com.vertispan.tsdefs.impl.visitors.InterfaceTypeVisitor;
import com.vertispan.tsdefs.impl.visitors.TsEnumTypeVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jsinterop.annotations.JsConstructor;

public class TypeVisitor
extends TsElement {
    public static final String MULTIPLE_CONSTRUCTORS_ARE_NOT_ALLOWED = "Multiple constructors are not allowed in JS exports";
    public static final String DUPLICATE_MEMBERS_ARE_NOT_ALLOWED = "Members with duplicate names are not allowed in JS exports.";
    public static final String PUBLIC_FIELD_WITH_PUBLIC_ACCESSOR_NOT_ALLOWED_IN_JS_EXPORTS = "Public field with public accessors not allowed in in JS exports";

    public TypeVisitor(Element element, HasProcessorEnv env) {
        super(element, env);
    }

    public void visit(TypeScriptModule.TsModuleBuilder module) {
        this.validate();
        new ClassTypeVisitor(this.element, this.env).visit(module);
        new InterfaceTypeVisitor(this.element, this.env).visit(module);
        new TsEnumTypeVisitor(this.element, this.env).visit(module);
    }

    private void validate() {
        this.singleConstructorValidation();
        this.duplicateMembersValidation();
        this.publicMemberWithPublicAccessor();
    }

    private void publicMemberWithPublicAccessor() {
        this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(e -> e.isField() && e.isPublic() != false).filter(this::hasPublicAccessor).forEach(e -> this.env.messager().printMessage(Diagnostic.Kind.ERROR, PUBLIC_FIELD_WITH_PUBLIC_ACCESSOR_NOT_ALLOWED_IN_JS_EXPORTS, e.element()));
    }

    private boolean hasPublicAccessor(TsElement field) {
        return this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(e -> e.isMethod() && e.isPublic() != false).anyMatch(e -> e.getName().equals(field.getGetterName()) || e.getName().equals(field.getSetterName()));
    }

    private void singleConstructorValidation() {
        long count;
        List constructors = this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(e -> e.isExportable() && e.isConstructor() && !e.isIgnored()).collect(Collectors.toList());
        if (constructors.size() > 1 && (count = constructors.stream().filter(ctor -> Objects.nonNull(ctor.element().getAnnotation(JsConstructor.class))).count()) != 1L) {
            this.env.messager().printMessage(Diagnostic.Kind.ERROR, MULTIPLE_CONSTRUCTORS_ARE_NOT_ALLOWED, this.element);
        }
    }

    private void duplicateMembersValidation() {
        HashSet nonStaticNames = new HashSet();
        this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(tsElement -> tsElement.isMethod() || tsElement.isField()).filter(e -> !e.isConstructor()).filter(e -> e.isExportable() && !e.isSetter() && !e.isGetter() && !e.isIgnored() && e.isStatic() == false).filter(e -> !nonStaticNames.add(e.getName())).collect(Collectors.toList()).forEach(duplicate -> this.env.messager().printMessage(Diagnostic.Kind.ERROR, DUPLICATE_MEMBERS_ARE_NOT_ALLOWED, duplicate.element()));
        HashSet staticNames = new HashSet();
        this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(tsElement -> tsElement.isMethod() || tsElement.isField()).filter(e -> !e.isConstructor()).filter(e -> e.isExportable() && !e.isSetter() && !e.isGetter() && !e.isIgnored() && e.isStatic() != false).filter(e -> !staticNames.add(e.getName())).collect(Collectors.toList()).forEach(duplicate -> this.env.messager().printMessage(Diagnostic.Kind.ERROR, DUPLICATE_MEMBERS_ARE_NOT_ALLOWED, duplicate.element()));
        HashSet setGetNames = new HashSet();
        this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(tsElement -> tsElement.isMethod() || tsElement.isField()).filter(e -> !e.isConstructor()).filter(e -> e.isExportable() && (e.isSetter() || e.isGetter())).map(TsElement::nonGetSetName).forEach(setGetNames::add);
        this.element.getEnclosedElements().stream().map(e -> TsElement.of(e, this.env)).filter(TsElement::isField).filter(TsElement::isExportable).filter(e -> !setGetNames.add(e.getName())).collect(Collectors.toList()).forEach(duplicate -> this.env.messager().printMessage(Diagnostic.Kind.ERROR, DUPLICATE_MEMBERS_ARE_NOT_ALLOWED, duplicate.element()));
    }
}

