/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs;

import com.vertispan.tsdefs.Formatting;
import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.annotations.TsModule;
import com.vertispan.tsdefs.model.TypeScriptModule;
import com.vertispan.tsdefs.shaded.com.google.auto.common.BasicAnnotationProcessor;
import com.vertispan.tsdefs.shaded.com.google.common.collect.SetMultimap;
import com.vertispan.tsdefs.shaded.com.google.common.collect.Sets;
import com.vertispan.tsdefs.visitors.TypeVisitor;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

public class JsTypesProcessingStep
implements BasicAnnotationProcessor.ProcessingStep,
HasProcessorEnv {
    private final ProcessingEnvironment processingEnv;

    public JsTypesProcessingStep(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return new HashSet<Class>(Arrays.asList(JsType.class, JsFunction.class, JsConstructor.class, JsMethod.class, JsProperty.class, TsModule.class));
    }

    @Override
    public Set<? extends Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        try {
            TypeScriptModule.TsModuleBuilder tsModuleBuilder = TypeScriptModule.builder(this);
            Set jsTypes = elementsByAnnotation.get(JsType.class).stream().filter(element -> !element.getAnnotation(JsType.class).isNative()).collect(Collectors.toSet());
            Collection jsFunctions = elementsByAnnotation.get(JsFunction.class);
            Set constructorsParentElements = elementsByAnnotation.get(JsConstructor.class).stream().filter(element -> Objects.isNull(element.getEnclosingElement().getAnnotation(JsType.class))).filter(element -> !element.getModifiers().contains((Object)Modifier.NATIVE)).map(Element::getEnclosingElement).collect(Collectors.toSet());
            Set methodsParentElements = elementsByAnnotation.get(JsMethod.class).stream().filter(element -> Objects.isNull(element.getEnclosingElement().getAnnotation(JsType.class))).filter(element -> !element.getModifiers().contains((Object)Modifier.NATIVE)).map(Element::getEnclosingElement).collect(Collectors.toSet());
            Set propertiesParentElements = elementsByAnnotation.get(JsProperty.class).stream().filter(element -> Objects.isNull(element.getEnclosingElement().getAnnotation(JsType.class))).filter(element -> !element.getModifiers().contains((Object)Modifier.NATIVE)).map(Element::getEnclosingElement).collect(Collectors.toSet());
            HashSet eligibleElements = new HashSet();
            eligibleElements.addAll(jsTypes);
            eligibleElements.addAll(jsFunctions);
            eligibleElements.addAll(constructorsParentElements);
            eligibleElements.addAll(methodsParentElements);
            eligibleElements.addAll(propertiesParentElements);
            eligibleElements.stream().filter(element -> Objects.isNull(element.getAnnotation(JsType.class)) || !element.getAnnotation(JsType.class).isNative()).forEach(e -> {
                try {
                    new TypeVisitor((Element)e, (HasProcessorEnv)this).visit(tsModuleBuilder);
                }
                catch (Exception exception) {
                    this.messager().printMessage(Diagnostic.Kind.ERROR, Formatting.formatException(exception), (Element)e);
                    throw new RuntimeException(exception);
                }
            });
            String moduleName = elementsByAnnotation.get(TsModule.class).stream().map(element -> element.getAnnotation(TsModule.class).value()).findFirst().orElse("types");
            FileObject resource = null;
            resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", moduleName + ".d.ts", new Element[0]);
            try (PrintWriter writer = new PrintWriter(resource.openOutputStream());){
                writer.print("// Minimum TypeScript Version: 4.3\n");
                writer.print(tsModuleBuilder.build().emit());
            }
        }
        catch (Exception e2) {
            this.messager().printMessage(Diagnostic.Kind.ERROR, Formatting.formatException(e2));
            throw new RuntimeException(e2);
        }
        return Sets.newHashSet();
    }

    @Override
    public Types types() {
        return this.processingEnv.getTypeUtils();
    }

    @Override
    public Elements elements() {
        return this.processingEnv.getElementUtils();
    }

    @Override
    public Messager messager() {
        return this.processingEnv.getMessager();
    }

    @Override
    public ProcessingEnvironment env() {
        return this.processingEnv;
    }
}

