/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.builders;

import com.vertispan.tsdefs.Formatting;
import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.annotations.TsTypeDef;
import com.vertispan.tsdefs.annotations.TsTypeRef;
import com.vertispan.tsdefs.builders.ProcessorType;
import com.vertispan.tsdefs.builders.TsElement;
import com.vertispan.tsdefs.model.Array2dTsType;
import com.vertispan.tsdefs.model.ArrayTsType;
import com.vertispan.tsdefs.model.ParameterizedTsType;
import com.vertispan.tsdefs.model.TsCustomType;
import com.vertispan.tsdefs.model.TsInlinedFunctionType;
import com.vertispan.tsdefs.model.TsTemplatedInlinedType;
import com.vertispan.tsdefs.model.TsType;
import com.vertispan.tsdefs.visitors.ParameterVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import jsinterop.base.JsPropertyMap;

public class JavaToTsTypeConverter {
    private final HasProcessorEnv env;
    private final Element element;

    public JavaToTsTypeConverter(Element element, HasProcessorEnv env) {
        this.env = env;
        this.element = element;
    }

    public TsType toTsType(TypeMirror type) {
        return this.toTsType(type, false);
    }

    public TsType toTsType(TypeMirror type, boolean checkTypeDef) {
        TypeMirror arrayComponentType;
        Optional<TsType> tsType;
        if (checkTypeDef && TsElement.of(type, this.env).isTsTypeDef() && (tsType = this.fromTsTypeDef(TsElement.of((TypeMirror)type, (HasProcessorEnv)this.env).element)).isPresent()) {
            return tsType.get();
        }
        if (type.getKind().isPrimitive()) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    return TsType.of("boolean");
                }
                case DOUBLE: 
                case INT: {
                    return TsType.of("number");
                }
                case VOID: {
                    return TsType.of("void");
                }
            }
            return TsType.of("unknown");
        }
        if (this.isSameType(type, String.class)) {
            return TsType.of("string");
        }
        if (this.isSameType(type, Double.class)) {
            return TsType.of("number");
        }
        if (this.isSameType(type, Boolean.class)) {
            return TsType.of("boolean");
        }
        if (this.isSameType(type, Void.class) || "void".equals(type.toString())) {
            return TsType.of("void");
        }
        if (Object.class.getCanonicalName().equals(type.toString())) {
            return TsType.of("object");
        }
        if (ProcessorType.of(type, this.env).is2dArray()) {
            arrayComponentType = ProcessorType.of(type, this.env).deepArrayComponentType();
            return Array2dTsType.of(this.toTsType(arrayComponentType)).nullable(TsElement.of(arrayComponentType, this.env).isJsNullable());
        }
        if (ProcessorType.of(type, this.env).isArray()) {
            arrayComponentType = ProcessorType.of(type, this.env).arrayComponentType();
            return ArrayTsType.of(this.toTsType(arrayComponentType)).nullable(TsElement.of(arrayComponentType, this.env).isJsNullable());
        }
        if (ProcessorType.of(type, this.env).isAssignableFrom(JsPropertyMap.class)) {
            DeclaredType declaredType = (DeclaredType)type;
            return TsTemplatedInlinedType.of("{ [key: string]: $T; }", this.asTypeWithArgument(declaredType).get(0));
        }
        if (ProcessorType.of(type, this.env).isJsFunction()) {
            return this.inlineJsFunctionType(type);
        }
        return this.getReferenceType(type);
    }

    private TsInlinedFunctionType inlineJsFunctionType(TypeMirror type) {
        Optional<TsElement> first = TsElement.of(type, this.env).element().getEnclosedElements().stream().filter(element -> ElementKind.METHOD.equals((Object)element.getKind())).map(element -> TsElement.of(element, this.env)).filter(tsElement -> !tsElement.isOverlay() && !tsElement.isIgnored()).findFirst();
        TsInlinedFunctionType tsType = new TsInlinedFunctionType();
        ExecutableElement executableElement = (ExecutableElement)first.get().element();
        List<? extends TypeMirror> declaredArguments = ((DeclaredType)type).getTypeArguments();
        List<? extends TypeMirror> argumentVars = ((DeclaredType)executableElement.getEnclosingElement().asType()).getTypeArguments();
        HashMap typeMapping = new HashMap();
        argumentVars.forEach(typeMirror -> typeMapping.put(typeMirror.toString(), this.toTsType((TypeMirror)declaredArguments.get(argumentVars.indexOf(typeMirror)))));
        executableElement.getParameters().forEach(param -> new ParameterVisitor<TsInlinedFunctionType>((Element)param, typeMapping, this.env).visit(tsType));
        TypeMirror returnType = executableElement.getReturnType();
        if (TypeKind.TYPEVAR.equals((Object)returnType.getKind()) && typeMapping.containsKey(returnType.toString())) {
            tsType.setReturnType((TsType)typeMapping.get(returnType.toString()));
        } else {
            tsType.setReturnType(this.toTsType(executableElement.getReturnType()));
        }
        return tsType;
    }

    private TsType getReferenceType(TypeMirror type) {
        if (TypeKind.TYPEVAR.equals((Object)type.getKind())) {
            return TsType.of(type.toString(), "");
        }
        if (TypeKind.TYPEVAR.equals((Object)type.getKind())) {
            return TsType.of("any");
        }
        if (TypeKind.DECLARED.equals((Object)type.getKind())) {
            DeclaredType declaredType = (DeclaredType)type;
            if (TsElement.of(declaredType, this.env).isTsTypeRef()) {
                return this.getTsTypeReference(declaredType);
            }
            if (!TsElement.of(declaredType, this.env).isPublic().booleanValue()) {
                this.env.messager().printMessage(Diagnostic.Kind.ERROR, "A none public type [" + declaredType.asElement().getSimpleName() + "] is referenced but it will not be exported.", this.element);
            } else {
                TsElement typeElement = new TsElement(declaredType.asElement(), this.env);
                if (typeElement.isJsType() || typeElement.isJsFunction() || typeElement.hasJsMembers()) {
                    return this.getDeclaredType(declaredType, typeElement);
                }
            }
        }
        return TsType.of(Formatting.resolveNameOr(type.toString(), "unknown"));
    }

    private TsType getDeclaredType(DeclaredType declaredType, TsElement typeElement) {
        String nameSpace;
        String name = typeElement.getName();
        String string = nameSpace = typeElement.isJsFunction() ? "" : typeElement.getNamespace();
        if (!declaredType.getTypeArguments().isEmpty()) {
            return ParameterizedTsType.of(name, nameSpace, this.asTypeWithArgument(declaredType));
        }
        return TsType.of(name, nameSpace);
    }

    private TsType getTsTypeReference(DeclaredType declaredType) {
        if (!TsElement.of(declaredType, this.env).isPublic().booleanValue()) {
            this.env.messager().printMessage(Diagnostic.Kind.ERROR, "A none public type [" + declaredType.asElement().getSimpleName() + "] is referenced but it will not be exported.", this.element);
        }
        Optional<TypeMirror> typeRef = TsElement.of(declaredType.asElement(), this.env).getClassValueFromAnnotation(TsTypeRef.class, "value");
        return this.toTsType(typeRef.get());
    }

    private List<TsType> asTypeWithArgument(DeclaredType type) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        return typeArguments.stream().map(this::getTypeOrTypeRef).map(typeMirror -> this.toTsType((TypeMirror)typeMirror, true).nullable(TsElement.of(typeMirror, this.env).isJsNullable())).collect(Collectors.toList());
    }

    public TypeMirror getTypeOrTypeRef(TypeMirror typeMirror) {
        List<? extends AnnotationMirror> annotations = typeMirror.getAnnotationMirrors();
        return annotations.stream().filter(annotationMirror -> this.isSameType(annotationMirror.getAnnotationType(), TsTypeRef.class)).map(annotationMirror -> this.getValueFromAnnotationMirror((AnnotationMirror)annotationMirror, "value")).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(typeMirror);
    }

    public boolean isSameType(TypeMirror typeMirror, Class<?> targetClass) {
        return this.env.types().isSameType(typeMirror, this.env.elements().getTypeElement(targetClass.getCanonicalName()).asType());
    }

    public static boolean isSameType(TypeMirror typeMirror, Class<?> targetClass, HasProcessorEnv env) {
        return env.types().isSameType(typeMirror, env.elements().getTypeElement(targetClass.getCanonicalName()).asType());
    }

    public static boolean isVoidType(TypeMirror typeMirror, HasProcessorEnv env) {
        return typeMirror.getKind() == TypeKind.VOID || JavaToTsTypeConverter.isSameType(typeMirror, Void.class, env);
    }

    public Optional<TypeMirror> getValueFromAnnotationMirror(AnnotationMirror am, String paramName) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            if (!paramName.equals(entry.getKey().getSimpleName().toString())) continue;
            AnnotationValue annotationValue = entry.getValue();
            return Optional.of((DeclaredType)annotationValue.getValue());
        }
        return Optional.empty();
    }

    public Optional<TsType> fromTsTypeDef(Element element) {
        TsElement tsElement = TsElement.of(element, this.env);
        if (tsElement.isTsTypeDef()) {
            TsTypeDef tsTypeDef = element.getAnnotation(TsTypeDef.class);
            if (Objects.nonNull(tsTypeDef.name()) && !tsTypeDef.name().trim().isEmpty() && !"<auto>".equals(tsTypeDef.name())) {
                return Optional.of(TsCustomType.of(tsTypeDef.name(), tsElement.getNamespace(), TsType.of(tsTypeDef.tsType())));
            }
            return Optional.of(TsCustomType.of(tsElement.getName() + "Type", tsElement.getNamespace(), TsType.of(tsTypeDef.tsType())));
        }
        if (tsElement.isJsType()) {
            return Optional.of(TsType.of(tsElement.getName(), tsElement.getNamespace()));
        }
        return Optional.empty();
    }
}

