/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.builders;

import com.vertispan.tsdefs.Formatting;
import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.annotations.TsIgnore;
import com.vertispan.tsdefs.annotations.TsInterface;
import com.vertispan.tsdefs.annotations.TsName;
import com.vertispan.tsdefs.annotations.TsTypeDef;
import com.vertispan.tsdefs.annotations.TsTypeRef;
import com.vertispan.tsdefs.builders.JavaToTsTypeConverter;
import com.vertispan.tsdefs.model.TsDoc;
import com.vertispan.tsdefs.model.TsModifier;
import com.vertispan.tsdefs.model.TsType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsNullable;
import jsinterop.annotations.JsOptional;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

public class TsElement {
    protected final Element element;
    protected final HasProcessorEnv env;
    private final JavaToTsTypeConverter typeConverter;
    private TypeMirror typeMirror;

    public TsElement(Element element, HasProcessorEnv env) {
        this.element = element;
        this.env = env;
        this.typeConverter = new JavaToTsTypeConverter(element, env);
        this.typeMirror = Objects.nonNull(element) ? element.asType() : null;
    }

    public TsElement(TypeMirror typeMirror, HasProcessorEnv env) {
        this.typeMirror = typeMirror;
        this.element = env.types().asElement(typeMirror);
        this.env = env;
        this.typeConverter = new JavaToTsTypeConverter(this.element, env);
    }

    public static TsElement of(Element element, HasProcessorEnv env) {
        return new TsElement(element, env);
    }

    public static TsElement of(TypeMirror typeMirror, HasProcessorEnv env) {
        return new TsElement(typeMirror, env);
    }

    public Element element() {
        return this.element;
    }

    public String elementName() {
        return this.element.getSimpleName().toString();
    }

    public TsDoc getDocs() {
        String docComment = this.env.elements().getDocComment(this.element);
        return Optional.ofNullable(docComment).map(TsDoc::of).orElse(TsDoc.empty());
    }

    public List<? extends TypeMirror> getInterfaces() {
        return ((TypeElement)this.element).getInterfaces();
    }

    public boolean isGetter() {
        return this.isMethod() && this.isStatic() == false && (this.isJsProperty() && this.matchGetterPattern() || this.isInheritedGetter());
    }

    public boolean isInheritedGetter() {
        List superGetters = TsElement.of(this.element.getEnclosingElement(), this.env).allSuperMethods().stream().filter(executableElement -> TsElement.of(executableElement, this.env).isGetter()).collect(Collectors.toList());
        return superGetters.stream().anyMatch(possibleOverridden -> {
            ExecutableElement currentMethod = (ExecutableElement)this.element;
            return this.env.elements().overrides(currentMethod, (ExecutableElement)possibleOverridden, (TypeElement)this.element.getEnclosingElement());
        });
    }

    private boolean matchGetterPattern() {
        ExecutableElement executableElement = (ExecutableElement)this.element;
        return !JavaToTsTypeConverter.isVoidType(executableElement.getReturnType(), this.env) && executableElement.getParameters().size() == 0;
    }

    public boolean isSetter() {
        return this.isMethod() && this.isStatic() == false && (this.isJsProperty() && this.matchSetterPattern() || this.isInheritedSetter());
    }

    private boolean matchSetterPattern() {
        ExecutableElement executableElement = (ExecutableElement)this.element;
        return JavaToTsTypeConverter.isVoidType(executableElement.getReturnType(), this.env) && executableElement.getParameters().size() == 1;
    }

    public boolean isInheritedSetter() {
        List superGetters = TsElement.of(this.element.getEnclosingElement(), this.env).allSuperMethods().stream().filter(executableElement -> TsElement.of(executableElement, this.env).isSetter()).collect(Collectors.toList());
        return superGetters.stream().anyMatch(possibleOverridden -> {
            ExecutableElement currentMethod = (ExecutableElement)this.element;
            return this.env.elements().overrides(currentMethod, (ExecutableElement)possibleOverridden, (TypeElement)this.element.getEnclosingElement());
        });
    }

    public String getName() {
        return this.getDeclaredJsName().orElse(this.elementName());
    }

    private <T extends Annotation> T getAnnotation(Class<T> annotation) {
        if (Objects.nonNull(this.element)) {
            return this.element.getAnnotation(annotation);
        }
        if (Objects.nonNull(this.typeMirror)) {
            return this.typeMirror.getAnnotation(annotation);
        }
        return null;
    }

    public Optional<String> getDeclaredJsName() {
        TsName tsNameAnnotation = this.getAnnotation(TsName.class);
        JsType jsTypeAnnotation = this.getAnnotation(JsType.class);
        JsProperty jsPropertyAnnotation = this.getAnnotation(JsProperty.class);
        JsMethod jsMethodAnnotation = this.getAnnotation(JsMethod.class);
        if (Objects.nonNull(tsNameAnnotation) && Objects.nonNull(tsNameAnnotation.name()) && !tsNameAnnotation.name().trim().isEmpty() && !"<auto>".equals(tsNameAnnotation.name())) {
            return Optional.of(tsNameAnnotation.name());
        }
        if (Objects.nonNull(jsTypeAnnotation) && Objects.nonNull(jsTypeAnnotation.name()) && !jsTypeAnnotation.name().trim().isEmpty() && !"<auto>".equals(jsTypeAnnotation.name())) {
            return Optional.of(jsTypeAnnotation.name());
        }
        if (Objects.nonNull(jsPropertyAnnotation) && Objects.nonNull(jsPropertyAnnotation.name()) && !jsPropertyAnnotation.name().trim().isEmpty() && !"<auto>".equals(jsPropertyAnnotation.name())) {
            return Optional.of(jsPropertyAnnotation.name());
        }
        if (Objects.nonNull(jsMethodAnnotation) && Objects.nonNull(jsMethodAnnotation.name()) && !jsMethodAnnotation.name().trim().isEmpty() && !"<auto>".equals(jsMethodAnnotation.name())) {
            return Optional.of(jsMethodAnnotation.name());
        }
        return Optional.empty();
    }

    public String nonGetSetName() {
        return this.getDeclaredJsName().orElseGet(() -> Formatting.nonGetSetName(this.elementName()));
    }

    public String getNamespace() {
        return this.getDeclaredNamespace().orElse(this.parentNamespace());
    }

    public Optional<String> getDeclaredNamespace() {
        TsName tsNameAnnotation = this.getAnnotation(TsName.class);
        JsType jsTypeAnnotation = this.getAnnotation(JsType.class);
        JsProperty jsPropertyAnnotation = this.getAnnotation(JsProperty.class);
        JsMethod jsMethodAnnotation = this.getAnnotation(JsMethod.class);
        if (Objects.nonNull(tsNameAnnotation) && Objects.nonNull(tsNameAnnotation.namespace()) && !"<auto>".equals(tsNameAnnotation.namespace())) {
            return Optional.of(tsNameAnnotation.namespace().equals("<global>") ? "" : tsNameAnnotation.namespace());
        }
        if (Objects.nonNull(jsTypeAnnotation) && Objects.nonNull(jsTypeAnnotation.namespace()) && !"<auto>".equals(jsTypeAnnotation.namespace())) {
            return Optional.of(jsTypeAnnotation.namespace().equals("<global>") ? "" : jsTypeAnnotation.namespace());
        }
        if (Objects.nonNull(jsPropertyAnnotation) && Objects.nonNull(jsPropertyAnnotation.namespace()) && !"<auto>".equals(jsPropertyAnnotation.namespace())) {
            return Optional.of(jsPropertyAnnotation.namespace().equals("<global>") ? "" : jsPropertyAnnotation.namespace());
        }
        if (Objects.nonNull(jsMethodAnnotation) && Objects.nonNull(jsMethodAnnotation.namespace()) && !"<auto>".equals(jsMethodAnnotation.namespace())) {
            return Optional.of(jsMethodAnnotation.namespace().equals("<global>") ? "" : jsMethodAnnotation.namespace());
        }
        return Optional.empty();
    }

    private String parentNamespace() {
        if (ElementKind.PACKAGE.equals((Object)this.element.getKind())) {
            return this.getDeclaredNamespace().orElse(this.env.elements().getPackageOf(this.element).getQualifiedName().toString());
        }
        if (Objects.nonNull(this.parent().element)) {
            return this.parent().getNamespace();
        }
        return this.env.elements().getPackageOf(this.element).getQualifiedName().toString();
    }

    public TsElement parent() {
        return TsElement.of(this.element.getEnclosingElement(), this.env);
    }

    public TsType getType() {
        TsType elementTsType = this.getElementTsType();
        if (!elementTsType.isNullable()) {
            elementTsType.nullable(this.isJsNullable());
        }
        return elementTsType;
    }

    private TsType getElementTsType() {
        if (this.isTsTypeRef()) {
            Optional<TypeMirror> typeDefClass = this.getClassValueFromAnnotation(TsTypeRef.class, "value");
            if (typeDefClass.isPresent()) {
                Optional<TsType> tsType = this.typeConverter.fromTsTypeDef(this.env.types().asElement(typeDefClass.get()));
                if (tsType.isPresent()) {
                    return tsType.get();
                }
                return this.typeConverter.toTsType(typeDefClass.get());
            }
            this.env.messager().printMessage(Diagnostic.Kind.ERROR, "Referenced type not found", this.element);
            return TsType.of("unknown");
        }
        if (this.element instanceof ExecutableElement) {
            return this.typeConverter.toTsType(((ExecutableElement)this.element).getReturnType());
        }
        return this.typeConverter.toTsType(this.element.asType());
    }

    public List<ExecutableElement> allSuperMethods() {
        List<ExecutableElement> superMethods = this.superMethods();
        superMethods.addAll(this.allSuperInterfacesMethods());
        return superMethods;
    }

    public List<ExecutableElement> allNotOverriddenMethods() {
        List<ExecutableElement> executableElements = this.enclosedMethods();
        List<ExecutableElement> superMethods = this.allSuperMethods();
        return superMethods.stream().filter(possibleOverridden -> executableElements.stream().noneMatch(overrider -> this.env.elements().overrides((ExecutableElement)overrider, (ExecutableElement)possibleOverridden, (TypeElement)this.element))).collect(Collectors.toList());
    }

    public List<ExecutableElement> allNotOverriddenInterfacesMethods() {
        return this.allNotOverriddenInterfacesMethods(executableElement -> true);
    }

    public List<ExecutableElement> allNotOverriddenInterfacesMethods(Predicate<TypeMirror> predicate) {
        List<ExecutableElement> executableElements = this.enclosedMethods();
        List<ExecutableElement> superMethods = this.allSuperInterfacesMethods(predicate);
        return superMethods.stream().filter(possibleOverridden -> executableElements.stream().noneMatch(overrider -> this.env.elements().overrides((ExecutableElement)overrider, (ExecutableElement)possibleOverridden, (TypeElement)this.element))).collect(Collectors.toList());
    }

    public List<ExecutableElement> enclosedMethods() {
        return this.element.getEnclosedElements().stream().filter(e -> ElementKind.METHOD == e.getKind()).map(e -> (ExecutableElement)e).collect(Collectors.toList());
    }

    public List<ExecutableElement> enclosedNonInheritedMethods() {
        List<ExecutableElement> superMethods = this.allSuperMethods();
        return this.element.getEnclosedElements().stream().filter(e -> ElementKind.METHOD == e.getKind()).map(e -> (ExecutableElement)e).filter(method -> superMethods.stream().noneMatch(possibleOverridden -> this.env.elements().overrides((ExecutableElement)method, (ExecutableElement)possibleOverridden, (TypeElement)this.element))).collect(Collectors.toList());
    }

    public boolean isInheritedMethod(ExecutableElement method) {
        List<ExecutableElement> superMethods = this.superMethods();
        superMethods.addAll(this.allSuperInterfacesMethods());
        return this.overridesOneOf(method, superMethods);
    }

    private boolean overridesOneOf(ExecutableElement method, List<ExecutableElement> superMethods) {
        return superMethods.stream().anyMatch(superMethod -> this.env.elements().overrides(method, (ExecutableElement)superMethod, (TypeElement)this.element));
    }

    public List<ExecutableElement> superMethods() {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        this.superElement().ifPresent(superElement -> {
            if (!superElement.superClass().getKind().equals((Object)TypeKind.NONE) && !superElement.isTsInterface()) {
                methods.addAll(ElementFilter.methodsIn(superElement.element.getEnclosedElements()));
                methods.addAll(superElement.superMethods());
            }
        });
        return methods;
    }

    public List<ExecutableElement> allMethodsAndSuperClassesMethods() {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(ElementFilter.methodsIn(this.element.getEnclosedElements()));
        this.superElement().ifPresent(tsElement -> methods.addAll(tsElement.allMethodsAndSuperClassesMethods()));
        return methods;
    }

    public List<ExecutableElement> allSuperInterfacesMethods() {
        return this.allSuperInterfacesMethods(typeMirror -> true);
    }

    public List<ExecutableElement> allSuperInterfacesMethods(Predicate<TypeMirror> predicate) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        ((TypeElement)this.element).getInterfaces().stream().filter(predicate::test).map(typeMirror -> (TypeElement)this.env.types().asElement((TypeMirror)typeMirror)).forEach(typeElement -> methods.addAll(this.allMethodsInInterface((TypeElement)typeElement)));
        this.getJavaSuperClass().ifPresent(typeMirror -> {
            TsElement superClass = TsElement.of(typeMirror, this.env);
            if (superClass.isTsInterface()) {
                methods.addAll(superClass.allSuperInterfacesMethods());
                methods.addAll(superClass.enclosedNonInheritedMethods());
            }
        });
        return methods;
    }

    private List<ExecutableElement> allMethodsInInterface(TypeElement interfaceElement) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        methods.addAll(ElementFilter.methodsIn(interfaceElement.getEnclosedElements()));
        interfaceElement.getInterfaces().stream().map(typeMirror -> (TypeElement)this.env.types().asElement((TypeMirror)typeMirror)).forEach(typeElement -> methods.addAll(this.allMethodsInInterface((TypeElement)typeElement)));
        return methods;
    }

    public boolean override(ExecutableElement method) {
        return this.allMethodsAndSuperClassesMethods().stream().anyMatch(elementMethod -> this.env.elements().overrides(method, (ExecutableElement)elementMethod, (TypeElement)this.element));
    }

    public Optional<TsElement> superElement() {
        TypeMirror superclass = ((TypeElement)this.element).getSuperclass();
        if (Objects.nonNull(superclass) && !superclass.getKind().equals((Object)TypeKind.NONE)) {
            return Optional.of(TsElement.of(superclass, this.env));
        }
        return Optional.empty();
    }

    public TypeMirror superClass() {
        return ((TypeElement)this.element).getSuperclass();
    }

    public boolean isExportable() {
        return !this.isIgnored() && !this.isOverlay() && (this.isField() && this.isExportableField() || this.isMethod() && this.isExportableMethod() || this.isConstructor() && this.isExportableConstructor() || this.isInterface() && this.isExportableInterface() || this.isClass() && this.isExportableClass());
    }

    private boolean isExportableClass() {
        return this.isJsType() || this.hasJsMembers();
    }

    private boolean isExportableInterface() {
        return this.isJsType() || this.hasJsMembers();
    }

    private boolean isExportableConstructor() {
        return this.isJsConstructor() || this.isPublic() != false && this.parent().isJsType();
    }

    private boolean isExportableMethod() {
        return (this.isJsMethod() || this.isJsProperty() || this.isPublic() != false && this.parent().isJsType()) && !this.disallowedStatic();
    }

    private boolean isExportableField() {
        return (this.isJsProperty() || this.isPublic() != false && this.parent().isJsType()) && !this.disallowedStatic();
    }

    private boolean disallowedStatic() {
        boolean disallowed;
        boolean bl = disallowed = this.isStatic() != false && (this.parent().isInterface() || this.parent().isTsInterface());
        if (disallowed) {
            this.env.messager().printMessage(Diagnostic.Kind.ERROR, "Interfaces or TsInterfaces cannot export static members.", this.element);
        }
        return disallowed;
    }

    public boolean isJsMember() {
        return this.isJsProperty() || this.isJsMethod() || this.isJsConstructor();
    }

    public Boolean isReadOnly() {
        return this.element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public Optional<TsModifier> readonlyModifier() {
        return this.isReadOnly() != false ? Optional.of(TsModifier.READONLY) : Optional.empty();
    }

    public Boolean isStatic() {
        return this.element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public Boolean isAbstract() {
        return this.element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private Optional<TsModifier> staticModifier() {
        return this.isStatic() != false ? Optional.of(TsModifier.STATIC) : Optional.empty();
    }

    private Optional<TsModifier> abstractModifier() {
        return this.isAbstract() != false && !this.parent().isInterface() ? Optional.of(TsModifier.ABSTRACT) : Optional.empty();
    }

    public Boolean isPrivate() {
        return this.element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private Optional<TsModifier> privateModifier() {
        return this.isPrivate() != false ? Optional.of(TsModifier.PRIVATE) : Optional.empty();
    }

    public Boolean isProtected() {
        return this.element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    public Boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public Boolean isFinal() {
        return this.element.getModifiers().contains((Object)Modifier.FINAL);
    }

    private Optional<TsModifier> protectedModifier() {
        return this.isProtected() != false ? Optional.of(TsModifier.PROTECTED) : Optional.empty();
    }

    public Boolean isOptional() {
        return Objects.nonNull(this.getAnnotation(JsOptional.class));
    }

    public boolean isJsType() {
        return Objects.nonNull(this.getAnnotation(JsType.class));
    }

    public boolean isJsNullable() {
        TypeMirror typeMirror;
        if (Objects.nonNull(this.element) && ElementKind.METHOD == this.element.getKind()) {
            typeMirror = ((ExecutableElement)this.element).getReturnType();
        } else if (Objects.nonNull(this.typeMirror)) {
            typeMirror = this.typeMirror;
        } else if (Objects.nonNull(this.element)) {
            typeMirror = this.element.asType();
        } else {
            return false;
        }
        List<? extends AnnotationMirror> annotations = typeMirror.getAnnotationMirrors();
        return annotations.stream().anyMatch(annotationMirror -> JavaToTsTypeConverter.isSameType(annotationMirror.getAnnotationType(), JsNullable.class, this.env));
    }

    public boolean isTsTypeRef() {
        TypeMirror typeMirror = this.element.asType();
        List<? extends AnnotationMirror> annotations = typeMirror.getAnnotationMirrors();
        return Objects.nonNull(this.element.getAnnotation(TsTypeRef.class)) || annotations.stream().anyMatch(annotationMirror -> JavaToTsTypeConverter.isSameType(annotationMirror.getAnnotationType(), TsTypeRef.class, this.env));
    }

    public boolean hasJsMembers() {
        return this.element.getEnclosedElements().stream().anyMatch(e -> TsElement.of(e, this.env).isJsMember());
    }

    public boolean isIgnored() {
        return Objects.nonNull(this.getAnnotation(JsIgnore.class));
    }

    public boolean isTsIgnored() {
        return Objects.nonNull(this.getAnnotation(TsIgnore.class));
    }

    public boolean isOverlay() {
        return Objects.nonNull(this.getAnnotation(JsOverlay.class));
    }

    public boolean isJsProperty() {
        return Objects.nonNull(this.getAnnotation(JsProperty.class));
    }

    public boolean isJsOptional() {
        return Objects.nonNull(this.getAnnotation(JsOptional.class));
    }

    public boolean isTsTypeDef() {
        return Objects.nonNull(this.getAnnotation(TsTypeDef.class));
    }

    public boolean isTsInterface() {
        return Objects.nonNull(this.getAnnotation(TsInterface.class));
    }

    public Optional<TypeMirror> getJavaSuperClass() {
        TypeMirror superclass = ((TypeElement)this.element).getSuperclass();
        if (TypeKind.NONE.equals((Object)superclass.getKind()) || ((TypeElement)this.env.types().asElement(superclass)).getSuperclass().getKind().equals((Object)TypeKind.NONE)) {
            return Optional.empty();
        }
        return Optional.of(superclass);
    }

    public boolean isInterface() {
        return this.element.getKind().isInterface() || this.isTsInterface();
    }

    public boolean isClass() {
        return this.element.getKind().isClass() && !this.isTsInterface();
    }

    public boolean isMethod() {
        return ElementKind.METHOD.equals((Object)this.element.getKind());
    }

    public boolean isJsMethod() {
        return Objects.nonNull(this.getAnnotation(JsMethod.class));
    }

    public boolean isJsConstructor() {
        return Objects.nonNull(this.getAnnotation(JsConstructor.class));
    }

    public boolean isField() {
        return this.element.getKind().isField();
    }

    public boolean isJsFunction() {
        return Objects.nonNull(this.getAnnotation(JsFunction.class));
    }

    public boolean isConstructor() {
        return Objects.nonNull(this.element) && ElementKind.CONSTRUCTOR.equals((Object)this.element.getKind());
    }

    public boolean isPrimitiveBoolean() {
        TypeMirror type = this.element.asType();
        return type.getKind().isPrimitive() && "boolean".equals(type.toString());
    }

    public boolean isDeprecated() {
        return Objects.nonNull(this.getAnnotation(Deprecated.class));
    }

    public String getGetterName() {
        return (this.isPrimitiveBoolean() ? "is" : "get") + Formatting.capitalizeFirstLetter(this.element.getSimpleName().toString());
    }

    public String getSetterName() {
        return "set" + Formatting.capitalizeFirstLetter(this.element.getSimpleName().toString());
    }

    public TsModifier[] getJsModifiers() {
        return (TsModifier[])Stream.of(this.protectedModifier(), this.abstractModifier(), this.staticModifier(), this.readonlyModifier()).filter(Optional::isPresent).map(Optional::get).toArray(TsModifier[]::new);
    }

    public Optional<TypeMirror> getClassValueFromAnnotation(Class<? extends Annotation> annotation, String paramName) {
        for (AnnotationMirror annotationMirror : this.element.getAnnotationMirrors()) {
            if (!this.env.types().isSameType(annotationMirror.getAnnotationType(), this.env.elements().getTypeElement(annotation.getCanonicalName()).asType())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!paramName.equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue annotationValue = entry.getValue();
                return Optional.of((DeclaredType)annotationValue.getValue());
            }
        }
        return Optional.empty();
    }

    public boolean requiresProtectedConstructor() {
        if (this.isJsType()) {
            boolean allIgnored;
            List constructors = this.element.getEnclosedElements().stream().map(enclosedElement -> TsElement.of(enclosedElement, this.env)).filter(TsElement::isConstructor).collect(Collectors.toList());
            boolean bl = allIgnored = !constructors.isEmpty() && constructors.stream().allMatch(TsElement::isIgnored);
            if (allIgnored) {
                return true;
            }
        } else {
            Optional<TsElement> jsConstructor = this.element.getEnclosedElements().stream().map(enclosedElement -> TsElement.of(enclosedElement, this.env)).filter(TsElement::isConstructor).filter(tsElement -> !((ExecutableElement)tsElement.element()).getParameters().isEmpty() || tsElement.isJsConstructor()).filter(TsElement::isJsConstructor).findAny();
            if (!jsConstructor.isPresent()) {
                return true;
            }
        }
        return false;
    }
}

