/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.model;

import com.vertispan.tsdefs.Formatting;
import com.vertispan.tsdefs.model.TsType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ParameterizedTsType
extends TsType {
    private final List<TsType> typeArguments = new ArrayList<TsType>();

    public static ParameterizedTsType of(String name, String namespace, List<TsType> typeArguments) {
        return new ParameterizedTsType(name, namespace, typeArguments);
    }

    public ParameterizedTsType(String name, String namespace, List<TsType> typeArguments) {
        super(name, namespace);
        this.typeArguments.addAll(typeArguments);
    }

    @Override
    public String emitType(String parentNamespace) {
        if (!this.typeArguments.isEmpty()) {
            return super.emitType(parentNamespace) + this.emitTypeArgs(parentNamespace);
        }
        return super.emitType(parentNamespace);
    }

    private String emitTypeArgs(String parentNamespace) {
        return this.typeArguments.stream().map(tsType -> tsType.emit(parentNamespace)).collect(Collectors.joining(", ", Formatting.optionalAffix("<", this.typeArguments), Formatting.optionalAffix(">", this.typeArguments)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedTsType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterizedTsType that = (ParameterizedTsType)o;
        return this.typeArguments.equals(that.typeArguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.typeArguments);
    }
}

