/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsDoc {
    private final String docs;

    public static TsDoc of(String docs) {
        return new TsDoc(docs);
    }

    public static TsDoc empty() {
        return TsDoc.of("");
    }

    private TsDoc(String docs) {
        this.docs = docs;
    }

    public String emit(String indent, boolean deprecated) {
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.docs) && !this.docs.trim().isEmpty()) {
            sb.append(indent);
            sb.append("/**");
            sb.append(Arrays.stream(this.docs.split("\\r?\\n|\\r")).map(line -> "\n" + indent + "*" + line).collect(Collectors.joining()));
            if (deprecated && !this.docs.contains("@deprecated")) {
                sb.append("\n");
                sb.append(indent);
                sb.append("* @deprecated");
            }
            sb.append("\n");
            sb.append(indent);
            sb.append("*/");
            sb.append("\n");
            sb.append(indent);
        } else if (deprecated) {
            sb.append(indent);
            sb.append("/**");
            sb.append("\n");
            sb.append(indent);
            sb.append("* @deprecated");
            sb.append("\n");
            sb.append(indent);
            sb.append("*/");
            sb.append("\n");
            sb.append(indent);
        } else {
            sb.append(indent);
        }
        return sb.toString();
    }
}

