/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.model;

import com.vertispan.tsdefs.builders.HasDocs;
import com.vertispan.tsdefs.builders.HasInterfaces;
import com.vertispan.tsdefs.builders.HasNamespace;
import com.vertispan.tsdefs.builders.HasTypeArguments;
import com.vertispan.tsdefs.model.TsDoc;
import com.vertispan.tsdefs.model.TsInterface;
import com.vertispan.tsdefs.model.TsMethod;
import com.vertispan.tsdefs.model.TsModifier;
import com.vertispan.tsdefs.model.TsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsFunction
implements HasNamespace {
    private String name;
    private String namespace;
    private List<TsModifier> modifiers = new ArrayList<TsModifier>();
    private TsMethod jsMethod;
    private List<TsType> typeArguments = new ArrayList<TsType>();
    private List<TsInterface> interfaces = new ArrayList<TsInterface>();
    private TsDoc tsDoc;
    private boolean deprecated;

    public String emit(String indent, String parentNamespace) {
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.tsDoc)) {
            sb.append(this.tsDoc.emit(indent, this.deprecated));
        }
        sb.append(this.modifiers.stream().map(TsModifier::emit).collect(Collectors.joining(" ")));
        sb.append("interface ");
        sb.append(this.emitType(parentNamespace));
        if (!this.interfaces.isEmpty()) {
            sb.append(" extends ");
            sb.append(this.interfaces.stream().map(tsInterface -> tsInterface.emitType(parentNamespace)).collect(Collectors.joining(", ")));
        }
        sb.append("{");
        sb.append("\n");
        sb.append(this.jsMethod.emit(indent + "\t", this.namespace));
        sb.append("\n");
        sb.append(indent);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public String emitType(String parentNamespace) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (!this.typeArguments.isEmpty()) {
            sb.append(this.typeArguments.stream().map(tsType -> tsType.emit(this.namespace)).collect(Collectors.joining(", ", "<", ">")));
        }
        return sb.toString();
    }

    public static TsFunctionBuilder builder(String name, String namespace) {
        return new TsFunctionBuilder(name, namespace);
    }

    private TsFunction(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public static class TsFunctionBuilder
    implements HasTypeArguments<TsFunctionBuilder>,
    HasInterfaces<TsFunctionBuilder>,
    HasDocs<TsFunctionBuilder> {
        private TsFunction tsFunction;

        private TsFunctionBuilder(String name, String namespace) {
            this.tsFunction = new TsFunction(name, namespace);
        }

        public TsFunctionBuilder addModifiers(TsModifier ... modifiers) {
            this.tsFunction.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        public TsFunctionBuilder setFunction(TsMethod method) {
            this.tsFunction.jsMethod = method;
            return this;
        }

        @Override
        public TsFunctionBuilder addTypeArgument(TsType typeArgument) {
            this.tsFunction.typeArguments.add(typeArgument);
            return this;
        }

        @Override
        public TsFunctionBuilder addInterface(TsInterface tsInterface) {
            this.tsFunction.interfaces.add(tsInterface);
            return this;
        }

        @Override
        public TsFunctionBuilder setDocs(TsDoc tsDoc) {
            this.tsFunction.tsDoc = tsDoc;
            return this;
        }

        public TsFunctionBuilder setDeprecated(boolean deprecated) {
            this.tsFunction.deprecated = deprecated;
            return this;
        }

        public TsFunction build() {
            return this.tsFunction;
        }
    }
}

