/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.model;

import com.vertispan.tsdefs.builders.HasProperties;
import com.vertispan.tsdefs.model.TsProperty;
import com.vertispan.tsdefs.model.TsType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsInlinedFunctionType
extends TsType
implements HasProperties<TsInlinedFunctionType> {
    private List<TsProperty> properties = new ArrayList<TsProperty>();
    private TsType returnType;

    public TsInlinedFunctionType() {
        super("", "");
    }

    @Override
    public TsInlinedFunctionType addProperty(TsProperty property) {
        this.properties.add(property);
        return this;
    }

    public TsType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TsType returnType) {
        this.returnType = returnType;
    }

    @Override
    public String emit(String parentNamespace) {
        return "(" + this.emitProperties() + ")=>" + this.returnType.emit("");
    }

    private String emitProperties() {
        return this.properties.stream().map(property -> property.emit("", "", "")).collect(Collectors.joining(","));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TsInlinedFunctionType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsInlinedFunctionType that = (TsInlinedFunctionType)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.getReturnType(), that.getReturnType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties, this.getReturnType());
    }
}

