/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.model;

import com.vertispan.tsdefs.Formatting;
import com.vertispan.tsdefs.builders.Deprecation;
import com.vertispan.tsdefs.builders.HasDocs;
import com.vertispan.tsdefs.model.TsDoc;
import com.vertispan.tsdefs.model.TsModifier;
import com.vertispan.tsdefs.model.TsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsProperty {
    private final String name;
    private final TsType type;
    private TsDoc tsDoc;
    private boolean jsOptional;
    private boolean deprecated;
    private boolean varargs = false;
    private List<TsModifier> modifiers = new ArrayList<TsModifier>();

    private TsProperty(String name, TsType type) {
        this.name = name;
        this.type = type;
    }

    public String emit(String indent, String ending, String parentNamespace) {
        return this.emitProperty(indent, ending, parentNamespace, false);
    }

    private String emitProperty(String indent, String ending, String parentNamespace, boolean skipModifiers) {
        StringBuffer sb = new StringBuffer();
        if (Objects.nonNull(this.tsDoc)) {
            sb.append(this.tsDoc.emit(indent, this.deprecated));
        } else if (this.deprecated) {
            sb.append(Deprecation.emit(indent));
        }
        if (!skipModifiers) {
            sb.append(this.modifiers.stream().map(TsModifier::emit).collect(Collectors.joining("", "", "")));
        }
        if (this.varargs) {
            sb.append("...");
        }
        sb.append(Formatting.resolveName(this.name));
        if (this.jsOptional) {
            sb.append("?");
        }
        sb.append(":");
        sb.append(this.type.emit(parentNamespace));
        sb.append(ending);
        return sb.toString();
    }

    public String emitAsParameter(String parentNamespace) {
        return this.emitProperty("", "", parentNamespace, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TsProperty)) {
            return false;
        }
        TsProperty that = (TsProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static TsPropertyBuilder builder(String name, TsType type) {
        return new TsPropertyBuilder(name, type);
    }

    public static class TsPropertyBuilder
    implements HasDocs<TsPropertyBuilder> {
        private final TsProperty property;

        private TsPropertyBuilder(String name, TsType type) {
            this.property = new TsProperty(name, type);
        }

        public TsPropertyBuilder addModifiers(TsModifier ... modifiers) {
            this.property.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        @Override
        public TsPropertyBuilder setDocs(TsDoc tsDoc) {
            this.property.tsDoc = tsDoc;
            return this;
        }

        public TsPropertyBuilder setOptional(boolean optional) {
            this.property.jsOptional = optional;
            return this;
        }

        public TsPropertyBuilder setDeprecated(boolean deprecated) {
            this.property.deprecated = deprecated;
            return this;
        }

        public TsPropertyBuilder setVarargs(boolean varargs) {
            this.property.varargs = varargs;
            return this;
        }

        public TsProperty build() {
            return this.property;
        }
    }
}

