/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.model;

import com.vertispan.tsdefs.Formatting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsType {
    protected final String name;
    protected final String namespace;
    private List<TsType> bounds = new ArrayList<TsType>();
    private boolean nullable;

    public static TsType of(String name, String namespace) {
        return new TsType(name, namespace);
    }

    public static TsType of(String name) {
        return new TsType(name, "");
    }

    public TsType(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public TsType nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public TsType addBounds(TsType tsType) {
        this.bounds.add(tsType);
        return this;
    }

    public String emit(String parentNamespace) {
        return this.emitType(parentNamespace) + this.emitNullable();
    }

    protected String emitType(String parentNamespace) {
        if (this.namespace.isEmpty() || this.namespace.equals(parentNamespace)) {
            return Formatting.resolveName(this.name) + this.emitBounds(parentNamespace);
        }
        return this.namespace + "." + Formatting.resolveName(this.name) + this.emitBounds(parentNamespace);
    }

    private String emitNullable() {
        if (this.nullable) {
            return "|null|undefined";
        }
        return "";
    }

    private String emitBounds(String parentNamespace) {
        if (this.bounds.isEmpty()) {
            return "";
        }
        return " extends " + this.bounds.stream().map(tsType -> tsType.emit(parentNamespace)).collect(Collectors.joining(" & "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TsType)) {
            return false;
        }
        TsType tsType = (TsType)o;
        return Objects.equals(this.getName(), tsType.getName()) && Objects.equals(this.getNamespace(), tsType.getNamespace()) && Objects.equals(this.bounds, tsType.bounds);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getNamespace());
    }
}

