/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.shaded.com.google.auto.common;

import com.vertispan.tsdefs.shaded.com.google.auto.common.MoreTypes;
import com.vertispan.tsdefs.shaded.com.google.common.base.Preconditions;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class SimpleTypeAnnotationValue
implements AnnotationValue {
    private final TypeMirror value;

    private SimpleTypeAnnotationValue(TypeMirror value) {
        Preconditions.checkArgument(value.getKind().isPrimitive() || value.getKind().equals((Object)TypeKind.DECLARED) || value.getKind().equals((Object)TypeKind.ARRAY), "value must be a primitive, array, or declared type, but was %s (%s)", (Object)value.getKind(), (Object)value);
        if (value.getKind().equals((Object)TypeKind.DECLARED)) {
            Preconditions.checkArgument(MoreTypes.asDeclared(value).getTypeArguments().isEmpty(), "value must not be a parameterized type: %s", (Object)value);
        }
        this.value = value;
    }

    public static AnnotationValue of(TypeMirror value) {
        return new SimpleTypeAnnotationValue(value);
    }

    @Override
    public TypeMirror getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        String string = String.valueOf(this.value);
        return new StringBuilder(6 + String.valueOf(string).length()).append(string).append(".class").toString();
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> visitor, P parameter) {
        return visitor.visitType(this.getValue(), parameter);
    }
}

