/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.visitors;

import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.builders.TsElement;
import com.vertispan.tsdefs.model.TsInterface;
import com.vertispan.tsdefs.model.TsMethod;
import com.vertispan.tsdefs.model.TsModifier;
import com.vertispan.tsdefs.model.TsProperty;
import com.vertispan.tsdefs.model.TypeScriptModule;
import com.vertispan.tsdefs.visitors.ClassMethodVisitor;
import com.vertispan.tsdefs.visitors.InheritedMethodsVisitor;
import com.vertispan.tsdefs.visitors.InterfacesVisitor;
import com.vertispan.tsdefs.visitors.SetterGetterMethodsVisitor;
import com.vertispan.tsdefs.visitors.TypeArgumentsVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class InterfaceTypeVisitor
extends TsElement {
    public static final String TS_INTERFACE_CANNOT_EXTEND_FROM_NONE_TS_INTERFACE_CLASSES = "TsInterface classes cannot extend from non TsInterface classes.";

    public InterfaceTypeVisitor(Element element, HasProcessorEnv env) {
        super(element, env);
    }

    public void visit(TypeScriptModule.TsModuleBuilder moduleBuilder) {
        if (this.isInterface() && this.isPublic().booleanValue() && !this.isJsFunction() & !this.isTsIgnored()) {
            TsInterface.TsInterfaceBuilder builder = TsInterface.builder(this.getName(), this.getNamespace()).setDocs(this.getDocs()).setDeprecated(this.isDeprecated()).addModifiers(TsModifier.EXPORT);
            this.getJavaSuperClass().ifPresent(superclass -> {
                if (!TsElement.of(superclass, this.env).isTsInterface()) {
                    this.env.messager().printMessage(Diagnostic.Kind.ERROR, TS_INTERFACE_CANNOT_EXTEND_FROM_NONE_TS_INTERFACE_CLASSES, this.element);
                } else if (!TsElement.of(superclass, this.env).isTsIgnored()) {
                    this.addInterface(builder, (TypeMirror)superclass);
                }
            });
            new TypeArgumentsVisitor<TsInterface.TsInterfaceBuilder>(this.element.asType(), this.env).visit(builder);
            new InterfacesVisitor<TsInterface.TsInterfaceBuilder>(this.element, this.env).visit(builder);
            this.element.getEnclosedElements().forEach(e -> this.visit(builder, (Element)e));
            if (this.isTsInterface()) {
                this.element.getEnclosedElements().stream().filter(member -> ElementKind.FIELD == member.getKind()).map(field -> TsElement.of(field, this.env)).filter(TsElement::isExportable).forEach(tsElement -> {
                    if (tsElement.isFinal().booleanValue()) {
                        builder.addFunction(TsMethod.builder(tsElement.getName(), tsElement.getType()).addModifiers(TsModifier.GET).setDocs(tsElement.getDocs()).setDeprecated(this.isDeprecated()).build());
                    } else {
                        builder.addProperty(TsProperty.builder(tsElement.getName(), tsElement.getType()).setDocs(tsElement.getDocs()).setDeprecated(this.isDeprecated()).build());
                    }
                });
            }
            if (!this.isTsInterface()) {
                new InheritedMethodsVisitor<TsInterface.TsInterfaceBuilder>(this.element, this.env).visit(builder);
            }
            new SetterGetterMethodsVisitor<TsInterface.TsInterfaceBuilder>(this.element, this.env).visit(builder);
            moduleBuilder.addInterface(builder.build());
        }
    }

    private void visit(TsInterface.TsInterfaceBuilder interfaceBuilder, Element enclosedElement) {
        new ClassMethodVisitor<TsInterface.TsInterfaceBuilder>(enclosedElement, this.env).visit(interfaceBuilder);
    }

    private void addInterface(TsInterface.TsInterfaceBuilder builder, TypeMirror interfaceElement) {
        TsElement tsElement = TsElement.of(interfaceElement, this.env);
        if (!tsElement.isTsIgnored()) {
            TsInterface.TsInterfaceBuilder interfaceBuilder = TsInterface.builder(tsElement.getName(), tsElement.getNamespace());
            new TypeArgumentsVisitor<TsInterface.TsInterfaceBuilder>(interfaceElement, this.env).visit(interfaceBuilder);
            builder.addInterface(interfaceBuilder.build());
        }
    }
}

