/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.visitors;

import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.builders.HasInterfaces;
import com.vertispan.tsdefs.builders.TsElement;
import com.vertispan.tsdefs.model.TsInterface;
import com.vertispan.tsdefs.visitors.TypeArgumentsVisitor;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class InterfacesVisitor<T>
extends TsElement {
    public InterfacesVisitor(Element element, HasProcessorEnv env) {
        super(element, env);
    }

    public void visit(HasInterfaces<T> builder) {
        List<? extends TypeMirror> interfaces = ((TypeElement)this.element).getInterfaces();
        interfaces.stream().filter(e -> TsElement.of(e, this.env).isExportable() && !TsElement.of(e, this.env).isTsIgnored()).forEach(interfaceElement -> this.addInterface(builder, (TypeMirror)interfaceElement));
    }

    private void addInterface(HasInterfaces<T> builder, TypeMirror interfaceElement) {
        TsElement tsElement = TsElement.of(interfaceElement, this.env);
        if (!tsElement.isTsIgnored()) {
            TsInterface.TsInterfaceBuilder interfaceBuilder = TsInterface.builder(tsElement.getName(), tsElement.getNamespace());
            new TypeArgumentsVisitor<TsInterface.TsInterfaceBuilder>(interfaceElement, this.env).visit(interfaceBuilder);
            builder.addInterface(interfaceBuilder.build());
        }
    }
}

