/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.visitors;

import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.builders.HasTypeArguments;
import com.vertispan.tsdefs.builders.JavaToTsTypeConverter;
import com.vertispan.tsdefs.builders.TsElement;
import com.vertispan.tsdefs.model.TsType;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

public class MethodTypeArgumentsVisitor<T>
extends TsElement {
    private final ExecutableElement element;

    public MethodTypeArgumentsVisitor(ExecutableElement element, HasProcessorEnv env) {
        super(element, env);
        this.element = element;
    }

    public void visit(HasTypeArguments<T> builder) {
        List<? extends TypeParameterElement> typeParameters = this.element.getTypeParameters();
        typeParameters.forEach(typeElement -> {
            TsType type = TsElement.of(typeElement, this.env).getType();
            if (typeElement.getKind().equals((Object)ElementKind.TYPE_PARAMETER)) {
                List<? extends TypeMirror> bounds = typeElement.getBounds();
                bounds.stream().filter(boundType -> !JavaToTsTypeConverter.isSameType(boundType, Object.class, this.env)).map(boundType -> TsElement.of(boundType, this.env).getType()).forEach(type::addBounds);
            }
            builder.addTypeArgument(type);
        });
    }
}

