/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.visitors;

import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.builders.HasInterfaces;
import com.vertispan.tsdefs.builders.IsClassBuilder;
import com.vertispan.tsdefs.builders.TsElement;
import com.vertispan.tsdefs.model.TsInterface;
import com.vertispan.tsdefs.visitors.TypeArgumentsVisitor;
import javax.lang.model.type.TypeMirror;

public class SuperTsInterfaceVisitor<T>
extends TsElement {
    private final TypeMirror type;

    public SuperTsInterfaceVisitor(TypeMirror typeMirror, HasProcessorEnv env) {
        super(typeMirror, env);
        this.type = typeMirror;
    }

    public void visit(IsClassBuilder<T> builder) {
        if (this.isTsInterface()) {
            this.addInterface(builder, this.type);
        }
    }

    private void addInterface(HasInterfaces<T> builder, TypeMirror typeMirror) {
        TsElement tsElement = TsElement.of(typeMirror, this.env);
        if (!tsElement.isTsIgnored()) {
            TsInterface.TsInterfaceBuilder interfaceBuilder = TsInterface.builder(tsElement.getName(), tsElement.getNamespace());
            new TypeArgumentsVisitor<TsInterface.TsInterfaceBuilder>(typeMirror, this.env).visit(interfaceBuilder);
            builder.addInterface(interfaceBuilder.build());
        }
    }
}

